/*
 * Decompiled with CFR 0.152.
 */
package net.revenj.database.postgres.converters;

import java.io.Serializable;
import java.sql.PreparedStatement;
import net.revenj.database.postgres.PostgresBuffer;
import net.revenj.database.postgres.PostgresReader;
import net.revenj.database.postgres.converters.NumberConverter$;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.postgresql.util.PGobject;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.concurrent.TrieMap;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class JodaTimestampConverter$ {
    public static final JodaTimestampConverter$ MODULE$ = new JodaTimestampConverter$();
    private static final DateTime net$revenj$database$postgres$converters$JodaTimestampConverter$$MIN_DATE_TIME_UTC = DateTime.parse((String)"0001-01-01T00:00:00Z");
    private static final int[] TIMESTAMP_REMINDER = (int[])Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100000, 10000, 1000, 100, 10, 1}), (ClassTag)ClassTag$.MODULE$.Int());
    private static final DateTimeZone[] hourOffsets = (DateTimeZone[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(-23), 23).map((Function1 & Serializable)x$1 -> JodaTimestampConverter$.$anonfun$hourOffsets$1(BoxesRunTime.unboxToInt((Object)x$1))).toArray(ClassTag$.MODULE$.apply(DateTimeZone.class));
    private static final TrieMap<Object, DateTimeZone> millisOffsets = new TrieMap();
    private static final int ZERO_OFFSET = 4920;

    public DateTime net$revenj$database$postgres$converters$JodaTimestampConverter$$MIN_DATE_TIME_UTC() {
        return net$revenj$database$postgres$converters$JodaTimestampConverter$$MIN_DATE_TIME_UTC;
    }

    private int[] TIMESTAMP_REMINDER() {
        return TIMESTAMP_REMINDER;
    }

    private DateTimeZone[] hourOffsets() {
        return hourOffsets;
    }

    private TrieMap<Object, DateTimeZone> millisOffsets() {
        return millisOffsets;
    }

    public void setParameter(PostgresBuffer sw, PreparedStatement ps, int index, DateTime value) {
        PGobject pg = new PGobject();
        pg.setType("timestamptz");
        char[] buf = sw.tempBuffer();
        int len = this.serialize(buf, 0, value);
        pg.setValue(new String(buf, 0, len));
        ps.setObject(index, pg);
    }

    private int serialize(char[] buffer, int pos, LocalDateTime value) {
        int year = value.getYear();
        if (year > 9999) {
            throw new IllegalArgumentException(new StringBuilder(64).append("Invalid year detected: ").append(value).append(". Only dates up to 9999-12-31 are allowed").toString());
        }
        buffer[pos + 4] = 45;
        buffer[pos + 7] = 45;
        buffer[pos + 10] = 32;
        buffer[pos + 13] = 58;
        buffer[pos + 16] = 58;
        NumberConverter$.MODULE$.write4(year, buffer, pos);
        NumberConverter$.MODULE$.write2(value.getMonthOfYear(), buffer, pos + 5);
        NumberConverter$.MODULE$.write2(value.getDayOfMonth(), buffer, pos + 8);
        NumberConverter$.MODULE$.write2(value.getHourOfDay(), buffer, pos + 11);
        NumberConverter$.MODULE$.write2(value.getMinuteOfHour(), buffer, pos + 14);
        NumberConverter$.MODULE$.write2(value.getSecondOfMinute(), buffer, pos + 17);
        int millis = value.getMillisOfSecond();
        int end = pos + 19;
        if (millis != 0) {
            buffer[pos + 19] = 46;
            NumberConverter$.MODULE$.write3(millis, buffer, 20);
            end = pos + 22;
            while (buffer[end] == '0') {
                --end;
            }
            ++end;
        }
        buffer[end] = 43;
        buffer[end + 1] = 48;
        buffer[end + 2] = 48;
        return end + 3;
    }

    private int ZERO_OFFSET() {
        return ZERO_OFFSET;
    }

    public int serialize(char[] buffer, int start, DateTime value) {
        int n;
        int offset = value.getZone().getOffset(value.getMillis()) / 1000;
        if (value.getYear() < 1884) {
            LocalDateTime at122 = value.toLocalDateTime().plusSeconds(this.ZERO_OFFSET() - offset);
            int pos = this.serialize(buffer, start, at122);
            buffer[pos - 1] = 49;
            buffer[pos] = 58;
            buffer[pos + 1] = 50;
            buffer[pos + 2] = 50;
            n = pos + 3;
        } else {
            int offsetHours = offset / 3600;
            int offsetDiff = offset - offsetHours * 3600;
            n = offsetDiff != 0 ? this.serializeNormalized(buffer, start, value.toLocalDateTime().minusSeconds(offsetDiff), offsetHours) : this.serializeNormalized(buffer, start, value.toLocalDateTime(), offsetHours);
        }
        return n;
    }

    private int serializeNormalized(char[] buffer, int pos, LocalDateTime value, int offsetHours) {
        int year = value.getYear();
        if (year > 9999) {
            throw new IllegalArgumentException(new StringBuilder(64).append("Invalid year detected: ").append(value).append(". Only dates up to 9999-12-31 are allowed").toString());
        }
        buffer[pos + 4] = 45;
        buffer[pos + 7] = 45;
        buffer[pos + 10] = 32;
        buffer[pos + 13] = 58;
        buffer[pos + 16] = 58;
        NumberConverter$.MODULE$.write4(year, buffer, pos);
        NumberConverter$.MODULE$.write2(value.getMonthOfYear(), buffer, pos + 5);
        NumberConverter$.MODULE$.write2(value.getDayOfMonth(), buffer, pos + 8);
        NumberConverter$.MODULE$.write2(value.getHourOfDay(), buffer, pos + 11);
        NumberConverter$.MODULE$.write2(value.getMinuteOfHour(), buffer, pos + 14);
        NumberConverter$.MODULE$.write2(value.getSecondOfMinute(), buffer, pos + 17);
        int millis = value.getMillisOfSecond();
        int end = pos + 19;
        if (millis != 0) {
            buffer[pos + 19] = 46;
            NumberConverter$.MODULE$.write3(millis, buffer, 20);
            end = pos + 22;
            while (buffer[end] == '0') {
                --end;
            }
            ++end;
        }
        if (offsetHours >= 0) {
            buffer[end] = 43;
            NumberConverter$.MODULE$.write2(offsetHours, buffer, end + 1);
        } else {
            buffer[end] = 45;
            NumberConverter$.MODULE$.write2(-offsetHours, buffer, end + 1);
        }
        return end + 3;
    }

    private DateTimeZone hourOffset(int offset) {
        Predef$.MODULE$.require(offset > -24 && offset < 24, (Function0 & Serializable)() -> new StringBuilder(30).append("Invalid hour offset provided: ").append(offset).toString());
        return this.hourOffsets()[offset + 23];
    }

    private DateTimeZone millisOffset(int offset) {
        return (DateTimeZone)this.millisOffsets().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)offset), (Function0 & Serializable)() -> DateTimeZone.forOffsetMillis((int)offset));
    }

    public DateTime net$revenj$database$postgres$converters$JodaTimestampConverter$$parseDateTime(PostgresReader reader, int context, boolean asUtc) {
        DateTime dateTime;
        int cur = reader.read(context);
        char[] buf = reader.tmp();
        buf[0] = (char)cur;
        int len = reader.fillUntil(buf, 1, '\\', '\"') + 1;
        reader.read(context + 1);
        if (buf[10] != ' ') {
            int foundAt;
            for (foundAt = 11; foundAt < buf.length && buf[foundAt] != ' '; ++foundAt) {
            }
            if (foundAt == buf.length) {
                throw new RuntimeException(new StringBuilder(25).append("Invalid timestamp value: ").append(new String(buf, 0, foundAt)).toString());
            }
            buf[foundAt] = 84;
            dateTime = DateTime.parse((String)new String(buf, 0, len));
        } else {
            int year = NumberConverter$.MODULE$.read4(buf, 0);
            int month = NumberConverter$.MODULE$.read2(buf, 5);
            int date = NumberConverter$.MODULE$.read2(buf, 8);
            int hour = NumberConverter$.MODULE$.read2(buf, 11);
            int minutes = NumberConverter$.MODULE$.read2(buf, 14);
            int seconds = NumberConverter$.MODULE$.read2(buf, 17);
            if (buf[19] == '.') {
                boolean pos;
                int nano = 0;
                int max = len - 3;
                int offsetSeconds = NumberConverter$.MODULE$.read2(buf, len - 2);
                if (buf[max] == ':') {
                    offsetSeconds = NumberConverter$.MODULE$.read2(buf, len - 5) * 60 + offsetSeconds;
                    if (buf[max -= 3] == ':') {
                        max -= 3;
                        offsetSeconds = NumberConverter$.MODULE$.read2(buf, len - 8) * 3600 + offsetSeconds;
                    } else {
                        offsetSeconds *= 60;
                    }
                } else {
                    offsetSeconds *= 3600;
                }
                int i = 20;
                for (int r = 0; i < max && r < this.TIMESTAMP_REMINDER().length; ++i, ++r) {
                    nano += this.TIMESTAMP_REMINDER()[r] * (buf[i] - 48);
                }
                boolean bl = pos = buf[max] == '+';
                dateTime = asUtc ? new DateTime(year, month, date, hour, minutes, seconds, nano / 1000, DateTimeZone.UTC).plusSeconds(pos ? -offsetSeconds : offsetSeconds) : (offsetSeconds != 0 ? new DateTime(year, month, date, hour, minutes, seconds, nano / 1000, this.millisOffset((pos ? offsetSeconds : -offsetSeconds) * 1000)) : new DateTime(year, month, date, hour, minutes, seconds, nano / 1000, DateTimeZone.UTC));
            } else if (len == 20 && buf[19] == 'Z') {
                dateTime = new DateTime(year, month, date, hour, minutes, seconds, 0, DateTimeZone.UTC);
            } else if (len == 22) {
                boolean pos = buf[19] == '+';
                int offset = NumberConverter$.MODULE$.read2(buf, 20);
                dateTime = asUtc ? new DateTime(year, month, date, hour, minutes, seconds, 0, DateTimeZone.UTC).plusHours(pos ? -offset : offset) : (offset != 0 ? new DateTime(year, month, date, hour, minutes, seconds, 0, this.hourOffset(pos ? offset : -offset)) : new DateTime(year, month, date, hour, minutes, seconds, 0, DateTimeZone.UTC));
            } else if (len == 25) {
                boolean pos = buf[19] == '+';
                int offsetSeconds = NumberConverter$.MODULE$.read2(buf, 20) * 3600 + NumberConverter$.MODULE$.read2(buf, 23) * 60;
                dateTime = asUtc ? new DateTime(year, month, date, hour, minutes, seconds, 0, DateTimeZone.UTC).plusSeconds(pos ? -offsetSeconds : offsetSeconds) : new DateTime(year, month, date, hour, minutes, seconds, 0, this.millisOffset((pos ? offsetSeconds : -offsetSeconds) * 1000));
            } else {
                buf[10] = 84;
                dateTime = DateTime.parse((String)new String(buf, 0, len));
            }
        }
        return dateTime;
    }

    public static final /* synthetic */ DateTimeZone $anonfun$hourOffsets$1(int x$1) {
        return DateTimeZone.forOffsetHours((int)x$1);
    }

    private JodaTimestampConverter$() {
    }
}

