/*
 * Decompiled with CFR 0.152.
 */
package net.revenj.database.postgres.converters;

import java.io.Serializable;
import net.revenj.database.postgres.PostgresReader;
import net.revenj.database.postgres.converters.ArrayTuple;
import net.revenj.database.postgres.converters.PostgresTuple;
import net.revenj.database.postgres.converters.PostgresTuple$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.concurrent.TrieMap;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Growable;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class ArrayTuple$ {
    public static final ArrayTuple$ MODULE$ = new ArrayTuple$();
    private static final PostgresTuple EMPTY = new ArrayTuple.EmptyArrayTuple();
    private static final PostgresTuple NULL = new ArrayTuple.NullTuple();
    private static final TrieMap<String, String> escapingCache = new TrieMap();
    private static final Some<IndexedSeq<Nothing$>> someEmptyCollection = new Some((Object)IndexedSeq$.MODULE$.empty());
    private static final Some<IndexedSeq<Option<Nothing$>>> someEmptyOptionCollection = new Some((Object)IndexedSeq$.MODULE$.empty());

    public PostgresTuple EMPTY() {
        return EMPTY;
    }

    public PostgresTuple NULL() {
        return NULL;
    }

    private TrieMap<String, String> escapingCache() {
        return escapingCache;
    }

    public String nextEscape(String input) {
        return input.length() < 16 ? (String)this.escapingCache().getOrElseUpdate((Object)input, (Function0 & Serializable)() -> PostgresTuple$.MODULE$.buildNextEscape(input, '0')) : PostgresTuple$.MODULE$.buildNextEscape(input, '0');
    }

    public PostgresTuple apply(PostgresTuple[] elements) {
        return elements == null ? this.NULL() : (elements.length == 0 ? this.EMPTY() : new ArrayTuple(elements));
    }

    public <T> PostgresTuple createIndexed(IndexedSeq<T> elements, Function1<T, PostgresTuple> converter) {
        PostgresTuple postgresTuple;
        if (elements == null) {
            postgresTuple = this.NULL();
        } else if (elements.isEmpty()) {
            postgresTuple = this.EMPTY();
        } else {
            PostgresTuple[] tuples = new PostgresTuple[elements.size()];
            for (int i = 0; i < elements.size(); ++i) {
                tuples[i] = (PostgresTuple)converter.apply(elements.apply(i));
            }
            postgresTuple = new ArrayTuple(tuples);
        }
        return postgresTuple;
    }

    public <T> PostgresTuple createIndexedOption(IndexedSeq<Option<T>> elements, Function1<T, PostgresTuple> converter) {
        PostgresTuple postgresTuple;
        if (elements == null) {
            postgresTuple = this.NULL();
        } else if (elements.isEmpty()) {
            postgresTuple = this.EMPTY();
        } else {
            PostgresTuple[] tuples = new PostgresTuple[elements.size()];
            for (int i = 0; i < elements.size(); ++i) {
                BoxedUnit boxedUnit;
                Option option = (Option)elements.apply(i);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Object el = some.value();
                    tuples[i] = (PostgresTuple)converter.apply(el);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                tuples[i] = PostgresTuple$.MODULE$.NULL();
                boxedUnit = BoxedUnit.UNIT;
            }
            postgresTuple = new ArrayTuple(tuples);
        }
        return postgresTuple;
    }

    public <T> PostgresTuple createSeq(Seq<T> elements, Function1<T, PostgresTuple> converter) {
        PostgresTuple postgresTuple;
        if (elements == null) {
            postgresTuple = this.NULL();
        } else if (elements.isEmpty()) {
            postgresTuple = this.EMPTY();
        } else {
            PostgresTuple[] tuples = new PostgresTuple[elements.size()];
            int i = 0;
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                tuples[i] = (PostgresTuple)converter.apply(it.next());
                ++i;
            }
            postgresTuple = new ArrayTuple(tuples);
        }
        return postgresTuple;
    }

    public <T> PostgresTuple createSeqOption(Seq<Option<T>> elements, Function1<T, PostgresTuple> converter) {
        PostgresTuple postgresTuple;
        if (elements == null) {
            postgresTuple = this.NULL();
        } else if (elements.isEmpty()) {
            postgresTuple = this.EMPTY();
        } else {
            PostgresTuple[] tuples = new PostgresTuple[elements.size()];
            int i = 0;
            for (Option option : elements) {
                BoxedUnit boxedUnit;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Object el = some.value();
                    tuples[i] = (PostgresTuple)converter.apply(el);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    tuples[i] = PostgresTuple$.MODULE$.NULL();
                    boxedUnit = BoxedUnit.UNIT;
                }
                ++i;
            }
            postgresTuple = new ArrayTuple(tuples);
        }
        return postgresTuple;
    }

    public <T> PostgresTuple createSet(Set<T> elements, Function1<T, PostgresTuple> converter) {
        PostgresTuple postgresTuple;
        if (elements == null) {
            postgresTuple = this.NULL();
        } else if (elements.isEmpty()) {
            postgresTuple = this.EMPTY();
        } else {
            PostgresTuple[] tuples = new PostgresTuple[elements.size()];
            int i = 0;
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                tuples[i] = (PostgresTuple)converter.apply(it.next());
                ++i;
            }
            postgresTuple = new ArrayTuple(tuples);
        }
        return postgresTuple;
    }

    public <T> PostgresTuple createSetOption(Set<Option<T>> elements, Function1<T, PostgresTuple> converter) {
        PostgresTuple postgresTuple;
        if (elements == null) {
            postgresTuple = this.NULL();
        } else if (elements.isEmpty()) {
            postgresTuple = this.EMPTY();
        } else {
            PostgresTuple[] tuples = new PostgresTuple[elements.size()];
            int i = 0;
            for (Option option : elements) {
                BoxedUnit boxedUnit;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Object el = some.value();
                    tuples[i] = (PostgresTuple)converter.apply(el);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    tuples[i] = PostgresTuple$.MODULE$.NULL();
                    boxedUnit = BoxedUnit.UNIT;
                }
                ++i;
            }
            postgresTuple = new ArrayTuple(tuples);
        }
        return postgresTuple;
    }

    private Some<IndexedSeq<Nothing$>> someEmptyCollection() {
        return someEmptyCollection;
    }

    private Some<IndexedSeq<Option<Nothing$>>> someEmptyOptionCollection() {
        return someEmptyOptionCollection;
    }

    public <T> Option<IndexedSeq<T>> parse(PostgresReader reader, int context, Function2<PostgresReader, Object, T> converter, Function0<T> function0) {
        Some some;
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            some = None$.MODULE$;
        } else {
            boolean escaped = cur != 123;
            Object object = escaped ? BoxesRunTime.boxToInteger((int)reader.read(context)) : BoxedUnit.UNIT;
            cur = reader.peek();
            if (cur == 125) {
                int n = escaped ? reader.read(context + 2) : reader.read(2);
                some = this.someEmptyCollection();
            } else {
                ArrayBuffer result = new ArrayBuffer(4);
                int arrayContext = Math.max(context << 1, 1);
                int recordContext = arrayContext << 1;
                while (cur != -1 && cur != 125) {
                    Growable growable;
                    cur = reader.read();
                    if (cur == 78) {
                        cur = reader.read(4);
                        growable = result.$plus$eq(function0.apply());
                        continue;
                    }
                    boolean innerEscaped = cur != 40;
                    Object object2 = innerEscaped ? BoxesRunTime.boxToInteger((int)reader.read(arrayContext)) : BoxedUnit.UNIT;
                    result.$plus$eq(converter.apply((Object)reader, (Object)BoxesRunTime.boxToInteger((int)recordContext)));
                    cur = innerEscaped ? reader.read(arrayContext + 1) : reader.read();
                    growable = BoxedUnit.UNIT;
                }
                int n = escaped ? reader.read(context + 1) : reader.read();
                some = new Some((Object)result);
            }
        }
        return some;
    }

    public <T> Option<IndexedSeq<Option<T>>> parseOption(PostgresReader reader, int context, Function2<PostgresReader, Object, T> converter) {
        Some some;
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            some = None$.MODULE$;
        } else {
            boolean escaped = cur != 123;
            Object object = escaped ? BoxesRunTime.boxToInteger((int)reader.read(context)) : BoxedUnit.UNIT;
            cur = reader.peek();
            if (cur == 125) {
                int n = escaped ? reader.read(context + 2) : reader.read(2);
                some = this.someEmptyOptionCollection();
            } else {
                ArrayBuffer result = new ArrayBuffer(4);
                int arrayContext = Math.max(context << 1, 1);
                int recordContext = arrayContext << 1;
                while (cur != -1 && cur != 125) {
                    Growable growable;
                    cur = reader.read();
                    if (cur == 78) {
                        cur = reader.read(4);
                        growable = result.$plus$eq((Object)None$.MODULE$);
                        continue;
                    }
                    boolean innerEscaped = cur != 40;
                    Object object2 = innerEscaped ? BoxesRunTime.boxToInteger((int)reader.read(arrayContext)) : BoxedUnit.UNIT;
                    result.$plus$eq((Object)new Some(converter.apply((Object)reader, (Object)BoxesRunTime.boxToInteger((int)recordContext))));
                    cur = innerEscaped ? reader.read(arrayContext + 1) : reader.read();
                    growable = BoxedUnit.UNIT;
                }
                int n = escaped ? reader.read(context + 1) : reader.read();
                some = new Some((Object)result);
            }
        }
        return some;
    }

    private ArrayTuple$() {
    }
}

