/*
 * Decompiled with CFR 0.152.
 */
package net.revenj.database.postgres;

import java.io.IOException;
import java.util.Arrays;
import net.revenj.database.postgres.PostgresBuffer;
import net.revenj.database.postgres.PostgresReader$;
import net.revenj.patterns.ServiceLocator;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tua\u0001B\u001d;\u0001\rC\u0001B\u0016\u0001\u0003\u0002\u0004%Ia\u0016\u0005\tC\u0002\u0011\t\u0019!C\u0005E\"A\u0001\u000e\u0001B\u0001B\u0003&\u0001\fC\u0003j\u0001\u0011\u0005!\u000eC\u0004n\u0001\u0001\u0007I\u0011\u00028\t\u000fi\u0004\u0001\u0019!C\u0005w\"1Q\u0010\u0001Q!\n=DqA \u0001A\u0002\u0013%q\u0010C\u0005\u0002\b\u0001\u0001\r\u0011\"\u0003\u0002\n!A\u0011Q\u0002\u0001!B\u0013\t\t\u0001\u0003\u0005\u0002\u0010\u0001\u0001\r\u0011\"\u0003\u0000\u0011%\t\t\u0002\u0001a\u0001\n\u0013\t\u0019\u0002\u0003\u0005\u0002\u0018\u0001\u0001\u000b\u0015BA\u0001\u0011!\tI\u0002\u0001a\u0001\n\u0013y\b\"CA\u000e\u0001\u0001\u0007I\u0011BA\u000f\u0011!\t\t\u0003\u0001Q!\n\u0005\u0005\u0001\"CA\u0012\u0001\u0001\u0007I\u0011BA\u0013\u0011%\t\u0019\u0004\u0001a\u0001\n\u0013\t)\u0004\u0003\u0005\u0002:\u0001\u0001\u000b\u0015BA\u0014\u0011!\tY\u0004\u0001a\u0001\n\u0013y\b\"CA\u001f\u0001\u0001\u0007I\u0011BA \u0011!\t\u0019\u0005\u0001Q!\n\u0005\u0005\u0001\"CA#\u0001\t\u0007I\u0011AA\u0013\u0011!\t9\u0005\u0001Q\u0001\n\u0005\u001d\u0002BB5\u0001\t\u0003\tI\u0005\u0003\u0004\u0002L\u0001!\ta\u0016\u0005\t\u0003\u001b\u0002A\u0011\u0001\u001e\u0002P!9\u00111\u000b\u0001\u0005\u0002\u0005U\u0003bBA,\u0001\u0011\u0005\u0011\u0011\f\u0005\b\u0003;\u0002A\u0011AA0\u0011\u001d\ti\u0006\u0001C\u0001\u0003CBa!a\u001a\u0001\t\u0003y\bBBA5\u0001\u0011\u0005q\u0010C\u0004\u0002l\u0001!\t!!\n\t\u000f\u00055\u0004\u0001\"\u0001\u0002V!9\u0011Q\u000e\u0001\u0005\u0002\u0005=\u0004bBA;\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0003k\u0002A\u0011AA>\u0011\u001d\t)\b\u0001C\u0001\u0003\u0003Cq!!\u001e\u0001\t\u0003\tI\tC\u0004\u0002v\u0001!\t!!&\t\u000f\u0005e\u0005\u0001\"\u0001\u0002\u001c\"9\u0011\u0011\u0014\u0001\u0005\u0002\u0005\u0015\u0006bBAY\u0001\u0011\u0005\u00111\u0017\u0005\u0007\u0003{\u0003A\u0011A@\t\u000f\u0005}\u0006\u0001\"\u0001\u0002&!9\u0011\u0011\u0019\u0001\u0005\u0002\u0005\r\u0007bBAc\u0001\u0011\u0005\u0011q\u0019\u0005\b\u0003W\u0004A\u0011AAw\u0011\u0019\tI\u0010\u0001C\u0001\u007f\u001e9\u00111 \u001e\t\u0002\u0005uhAB\u001d;\u0011\u0003\ty\u0010\u0003\u0004ji\u0011\u0005!\u0011\u0001\u0005\b\u0005\u0007!D\u0011\u0001B\u0003\u0011\u001d\u0011I\u0001\u000eC\u0005\u0005\u0017AqAa\u00045\t\u0003\u0011\tB\u0001\bQ_N$xM]3t%\u0016\fG-\u001a:\u000b\u0005mb\u0014\u0001\u00039pgR<'/Z:\u000b\u0005ur\u0014\u0001\u00033bi\u0006\u0014\u0017m]3\u000b\u0005}\u0002\u0015A\u0002:fm\u0016t'NC\u0001B\u0003\rqW\r^\u0002\u0001'\u0011\u0001AI\u0013(\u0011\u0005\u0015CU\"\u0001$\u000b\u0003\u001d\u000bQa]2bY\u0006L!!\u0013$\u0003\r\u0005s\u0017PU3g!\tYE*D\u0001;\u0013\ti%H\u0001\bQ_N$xM]3t\u0005V4g-\u001a:\u0011\u0005=#V\"\u0001)\u000b\u0005E\u0013\u0016\u0001\u00027b]\u001eT\u0011aU\u0001\u0005U\u00064\u0018-\u0003\u0002V!\ni\u0011)\u001e;p\u00072|7/Z1cY\u0016\fab]3sm&\u001cW\rT8dCR|'/F\u0001Y!\r)\u0015lW\u0005\u00035\u001a\u0013aa\u00149uS>t\u0007C\u0001/`\u001b\u0005i&B\u00010?\u0003!\u0001\u0018\r\u001e;fe:\u001c\u0018B\u00011^\u00059\u0019VM\u001d<jG\u0016dunY1u_J\f!c]3sm&\u001cW\rT8dCR|'o\u0018\u0013fcR\u00111M\u001a\t\u0003\u000b\u0012L!!\u001a$\u0003\tUs\u0017\u000e\u001e\u0005\bO\n\t\t\u00111\u0001Y\u0003\rAH%M\u0001\u0010g\u0016\u0014h/[2f\u0019>\u001c\u0017\r^8sA\u00051A(\u001b8jiz\"\"a\u001b7\u0011\u0005-\u0003\u0001\"\u0002,\u0005\u0001\u0004A\u0016!B5oaV$X#A8\u0011\u0005A<hBA9v!\t\u0011h)D\u0001t\u0015\t!()\u0001\u0004=e>|GOP\u0005\u0003m\u001a\u000ba\u0001\u0015:fI\u00164\u0017B\u0001=z\u0005\u0019\u0019FO]5oO*\u0011aOR\u0001\nS:\u0004X\u000f^0%KF$\"a\u0019?\t\u000f\u001d4\u0011\u0011!a\u0001_\u00061\u0011N\u001c9vi\u0002\na\u0001\\3oORDWCAA\u0001!\r)\u00151A\u0005\u0004\u0003\u000b1%aA%oi\u0006QA.\u001a8hi\"|F%Z9\u0015\u0007\r\fY\u0001\u0003\u0005h\u0013\u0005\u0005\t\u0019AA\u0001\u0003\u001daWM\\4uQ\u0002\nq\u0002]8tSRLwN\\%o\u0013:\u0004X\u000f^\u0001\u0014a>\u001c\u0018\u000e^5p]&s\u0017J\u001c9vi~#S-\u001d\u000b\u0004G\u0006U\u0001\u0002C4\r\u0003\u0003\u0005\r!!\u0001\u0002!A|7/\u001b;j_:Le.\u00138qkR\u0004\u0013\u0001\u00037bgR\u001c\u0005.\u0019:\u0002\u00191\f7\u000f^\"iCJ|F%Z9\u0015\u0007\r\fy\u0002\u0003\u0005h\u001f\u0005\u0005\t\u0019AA\u0001\u0003%a\u0017m\u001d;DQ\u0006\u0014\b%\u0001\u0004ck\u001a4WM]\u000b\u0003\u0003O\u0001R!RA\u0015\u0003[I1!a\u000bG\u0005\u0015\t%O]1z!\r)\u0015qF\u0005\u0004\u0003c1%\u0001B\"iCJ\f!BY;gM\u0016\u0014x\fJ3r)\r\u0019\u0017q\u0007\u0005\tOJ\t\t\u00111\u0001\u0002(\u00059!-\u001e4gKJ\u0004\u0013\u0001\u00059pg&$\u0018n\u001c8J]\n+hMZ3s\u0003Q\u0001xn]5uS>t\u0017J\u001c\"vM\u001a,'o\u0018\u0013fcR\u00191-!\u0011\t\u0011\u001d,\u0012\u0011!a\u0001\u0003\u0003\t\u0011\u0003]8tSRLwN\\%o\u0005V4g-\u001a:!\u0003\r!X\u000e]\u0001\u0005i6\u0004\b\u0005F\u0001l\u0003\u001dawnY1u_J\fQA]3tKR$2aYA)\u0011\u0019\tYe\u0007a\u00017\u0006)1\r\\8tKR\t1-A\u0004qe>\u001cWm]:\u0015\u0007\r\fY\u0006C\u0003n;\u0001\u0007q.\u0001\u0003sK\u0006$GCAA\u0001)\u0011\t\t!a\u0019\t\u000f\u0005\u0015t\u00041\u0001\u0002\u0002\u0005)Ao\u001c;bY\u0006!\u0001/Z3l\u0003\u0011a\u0017m\u001d;\u0002\u0015Q,W\u000e\u001d\"vM\u001a,'/\u0001\u0006j]&$()\u001e4gKJ$2aYA9\u0011\u001d\t\u0019\b\na\u0001\u0003[\t\u0011aY\u0001\fC\u0012$Gk\u001c\"vM\u001a,'\u000fF\u0002d\u0003sBq!a\u001d&\u0001\u0004\ti\u0003F\u0002d\u0003{Bq!a '\u0001\u0004\t9#A\u0002ck\u001a$RaYAB\u0003\u000bCq!a (\u0001\u0004\t9\u0003C\u0004\u0002\b\u001e\u0002\r!!\u0001\u0002\u00071,g\u000eF\u0004d\u0003\u0017\u000bi)!%\t\u000f\u0005}\u0004\u00061\u0001\u0002(!9\u0011q\u0012\u0015A\u0002\u0005\u0005\u0011AB8gMN,G\u000fC\u0004\u0002\u0014\"\u0002\r!!\u0001\u0002\u0007\u0015tG\rF\u0002d\u0003/CQ!\\\u0015A\u0002=\f\u0011BZ5mYVsG/\u001b7\u0015\u000b\r\fi*!)\t\u000f\u0005}%\u00061\u0001\u0002.\u0005\u00111-\r\u0005\b\u0003GS\u0003\u0019AA\u0017\u0003\t\u0019'\u0007\u0006\u0006\u0002\u0002\u0005\u001d\u00161VAW\u0003_Cq!!+,\u0001\u0004\t9#\u0001\u0004uCJ<W\r\u001e\u0005\b\u0003\u001f[\u0003\u0019AA\u0001\u0011\u001d\tyj\u000ba\u0001\u0003[Aq!a),\u0001\u0004\ti#A\u0005gS2dGk\u001c;bYR91-!.\u00028\u0006e\u0006bBAUY\u0001\u0007\u0011q\u0005\u0005\b\u0003\u001fc\u0003\u0019AA\u0001\u0011\u001d\tY\f\fa\u0001\u0003\u0003\tQaY8v]R\faBY;gM\u0016\u0014\bk\\:ji&|g.A\u0007dkJ\u0014XM\u001c;Ck\u001a4WM]\u0001\u000fEV4g-\u001a:U_N#(/\u001b8h)\u0005y\u0017!\u00042vM\u001a,'\u000fV8WC2,X-\u0006\u0003\u0002J\u0006=G\u0003BAf\u0003C\u0004B!!4\u0002P2\u0001AaBAia\t\u0007\u00111\u001b\u0002\u0002)F!\u0011Q[An!\r)\u0015q[\u0005\u0004\u000334%a\u0002(pi\"Lgn\u001a\t\u0004\u000b\u0006u\u0017bAAp\r\n\u0019\u0011I\\=\t\u000f\u0005\r\b\u00071\u0001\u0002f\u0006I1m\u001c8wKJ$XM\u001d\t\f\u000b\u0006\u001d\u0018qEA\u0001\u0003\u0003\tY-C\u0002\u0002j\u001a\u0013\u0011BR;oGRLwN\\\u001a\u0002\u001b\t,hMZ3s\u001b\u0006$8\r[3t)\u0011\ty/!>\u0011\u0007\u0015\u000b\t0C\u0002\u0002t\u001a\u0013qAQ8pY\u0016\fg\u000e\u0003\u0004\u0002xF\u0002\ra\\\u0001\bG>l\u0007/\u0019:f\u0003)\u0011WO\u001a4fe\"\u000b7\u000f[\u0001\u000f!>\u001cHo\u001a:fgJ+\u0017\rZ3s!\tYEg\u0005\u00025\tR\u0011\u0011Q`\u0001\u0007GJ,\u0017\r^3\u0015\u0007-\u00149\u0001\u0003\u0004\u0002LY\u0002\u001daW\u0001\u0010M&tG-R:dCB,Gm\u00115beR!\u0011\u0011\u0001B\u0007\u0011\u0015iw\u00071\u0001p\u0003E\u0001\u0018M]:f\u0007>l\u0007o\\:ji\u0016,&+\u0013\u000b\u0006G\nM!q\u0003\u0005\u0007\u0005+A\u0004\u0019A8\u0002\u0007U\u0014\u0018\u000eC\u0004\u0003\u001aa\u0002\rAa\u0007\u0002\rI,7/\u001e7u!\u0011)\u0015\u0011F8")
public class PostgresReader
implements PostgresBuffer,
AutoCloseable {
    private Option<ServiceLocator> serviceLocator;
    private String input;
    private int length;
    private int positionInInput;
    private int lastChar;
    private char[] buffer;
    private int positionInBuffer;
    private final char[] tmp;

    public static void parseCompositeURI(String string, String[] stringArray) {
        PostgresReader$.MODULE$.parseCompositeURI(string, stringArray);
    }

    public static PostgresReader create(ServiceLocator serviceLocator) {
        return PostgresReader$.MODULE$.create(serviceLocator);
    }

    private Option<ServiceLocator> serviceLocator() {
        return this.serviceLocator;
    }

    private void serviceLocator_$eq(Option<ServiceLocator> x$1) {
        this.serviceLocator = x$1;
    }

    private String input() {
        return this.input;
    }

    private void input_$eq(String x$1) {
        this.input = x$1;
    }

    private int length() {
        return this.length;
    }

    private void length_$eq(int x$1) {
        this.length = x$1;
    }

    private int positionInInput() {
        return this.positionInInput;
    }

    private void positionInInput_$eq(int x$1) {
        this.positionInInput = x$1;
    }

    private int lastChar() {
        return this.lastChar;
    }

    private void lastChar_$eq(int x$1) {
        this.lastChar = x$1;
    }

    private char[] buffer() {
        return this.buffer;
    }

    private void buffer_$eq(char[] x$1) {
        this.buffer = x$1;
    }

    private int positionInBuffer() {
        return this.positionInBuffer;
    }

    private void positionInBuffer_$eq(int x$1) {
        this.positionInBuffer = x$1;
    }

    public char[] tmp() {
        return this.tmp;
    }

    public Option<ServiceLocator> locator() {
        return this.serviceLocator();
    }

    public void reset(ServiceLocator locator) {
        this.positionInBuffer_$eq(0);
        this.positionInInput_$eq(0);
        this.serviceLocator_$eq((Option<ServiceLocator>)Option$.MODULE$.apply((Object)locator));
    }

    @Override
    public void close() {
        this.length_$eq(0);
        this.positionInBuffer_$eq(0);
        this.positionInInput_$eq(0);
        this.lastChar_$eq(-1);
    }

    public void process(String input) {
        this.input_$eq(input);
        this.length_$eq(input.length());
        this.positionInInput_$eq(0);
        this.positionInBuffer_$eq(0);
        this.lastChar_$eq(0);
    }

    public int read() {
        if (this.positionInInput() >= this.length()) {
            this.lastChar_$eq(-1);
        } else {
            this.lastChar_$eq(this.input().charAt(this.positionInInput()));
            this.positionInInput_$eq(this.positionInInput() + 1);
        }
        return this.last();
    }

    public int read(int total) {
        int n;
        if (total == 0) {
            n = 0;
        } else {
            if (total > 1) {
                this.positionInInput_$eq(this.positionInInput() + (total - 1));
            }
            n = this.read();
        }
        return n;
    }

    public int peek() {
        return this.positionInInput() >= this.length() ? -1 : (int)this.input().charAt(this.positionInInput());
    }

    public int last() {
        return this.lastChar();
    }

    @Override
    public char[] tempBuffer() {
        return this.tmp();
    }

    @Override
    public void initBuffer() {
        this.positionInBuffer_$eq(0);
    }

    @Override
    public void initBuffer(char c) {
        this.positionInBuffer_$eq(1);
        this.buffer()[0] = c;
    }

    @Override
    public void addToBuffer(char c) {
        if (this.positionInBuffer() == this.buffer().length) {
            this.buffer_$eq(Arrays.copyOf(this.buffer(), this.buffer().length * 2));
        }
        this.buffer()[this.positionInBuffer()] = c;
        this.positionInBuffer_$eq(this.positionInBuffer() + 1);
    }

    @Override
    public void addToBuffer(char[] buf) {
        if (this.positionInBuffer() + buf.length >= this.buffer().length) {
            this.buffer_$eq(Arrays.copyOf(this.buffer(), this.buffer().length * 2 + buf.length));
        }
        for (int i = 0; i < buf.length; ++i) {
            this.buffer()[this.positionInBuffer() + i] = buf[i];
        }
        this.positionInBuffer_$eq(this.positionInBuffer() + buf.length);
    }

    @Override
    public void addToBuffer(char[] buf, int len) {
        if (this.positionInBuffer() + len >= this.buffer().length) {
            this.buffer_$eq(Arrays.copyOf(this.buffer(), this.buffer().length * 2 + len));
        }
        for (int i = 0; i < len; ++i) {
            this.buffer()[this.positionInBuffer() + i] = buf[i];
        }
        this.positionInBuffer_$eq(this.positionInBuffer() + len);
    }

    @Override
    public void addToBuffer(char[] buf, int offset, int end) {
        if (this.positionInBuffer() + end >= this.buffer().length) {
            this.buffer_$eq(Arrays.copyOf(this.buffer(), this.buffer().length * 2 + end));
        }
        for (int i = offset; i < end; ++i) {
            this.buffer()[this.positionInBuffer() + i - offset] = buf[i];
        }
        this.positionInBuffer_$eq(this.positionInBuffer() + (end - offset));
    }

    @Override
    public void addToBuffer(String input) {
        int len = input.length();
        if (this.positionInBuffer() + len >= this.buffer().length) {
            this.buffer_$eq(Arrays.copyOf(this.buffer(), this.buffer().length * 2 + len));
        }
        input.getChars(0, len, this.buffer(), this.positionInBuffer());
        this.positionInBuffer_$eq(this.positionInBuffer() + len);
    }

    public void fillUntil(char c1, char c2) {
        int i = 0;
        i = this.positionInInput();
        boolean isEnd = false;
        while (!isEnd && i < this.input().length()) {
            char c = this.input().charAt(i);
            isEnd = c == c1 || c == c2;
            if (isEnd) continue;
            this.addToBuffer(c);
            ++i;
        }
        this.positionInInput_$eq(i);
        if (this.positionInInput() == this.input().length()) {
            throw new IOException("End of input detected");
        }
    }

    public int fillUntil(char[] target, int offset, char c1, char c2) {
        int i = this.positionInInput();
        int cur = offset;
        boolean isEnd = false;
        while (!isEnd && i < this.input().length()) {
            char c = this.input().charAt(i);
            isEnd = c == c1 || c == c2;
            if (isEnd) continue;
            target[cur] = c;
            ++cur;
            ++i;
        }
        this.positionInInput_$eq(i);
        if (this.positionInInput() == this.input().length()) {
            throw new IOException("End of input detected");
        }
        return cur - offset;
    }

    public void fillTotal(char[] target, int offset, int count) {
        for (int i = 0; i < count; ++i) {
            target[i + offset] = this.input().charAt(this.positionInInput() + i);
        }
        this.positionInInput_$eq(this.positionInInput() + count);
    }

    public int bufferPosition() {
        return this.positionInBuffer();
    }

    public char[] currentBuffer() {
        return this.buffer();
    }

    @Override
    public String bufferToString() {
        int len = this.positionInBuffer();
        this.positionInBuffer_$eq(0);
        return len == 0 ? "" : new String(this.buffer(), 0, len);
    }

    public <T> T bufferToValue(Function3<char[], Object, Object, T> converter) {
        return (T)converter.apply((Object)this.buffer(), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)this.positionInBuffer()));
    }

    /*
     * WARNING - void declaration
     */
    public boolean bufferMatches(String compare) {
        boolean bl;
        if (compare.length() != this.positionInBuffer()) {
            bl = false;
        } else {
            void var3_3;
            boolean isSame = true;
            for (int i = 0; isSame && i < compare.length(); ++i) {
                isSame = this.buffer()[i] == compare.charAt(i);
            }
            bl = var3_3;
        }
        return bl;
    }

    public int bufferHash() {
        int len = this.positionInBuffer();
        long hash = 2166136261L;
        for (int i = 0; i < len && i < this.buffer().length; ++i) {
            hash = (hash ^ (long)this.buffer()[i]) * 16777619L;
        }
        return (int)hash;
    }

    public PostgresReader(Option<ServiceLocator> serviceLocator) {
        this.serviceLocator = serviceLocator;
        this.input = "";
        this.length = 0;
        this.positionInInput = 0;
        this.lastChar = 0;
        this.buffer = new char[48];
        this.positionInBuffer = 0;
        this.tmp = new char[64];
    }

    public PostgresReader() {
        this((Option<ServiceLocator>)None$.MODULE$);
    }
}

