/*
 * Decompiled with CFR 0.152.
 */
package net.revenj.database.postgres;

import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import javax.net.SocketFactory;
import org.postgresql.PGProperty;
import org.postgresql.core.PGStream;
import org.postgresql.core.QueryExecutor;
import org.postgresql.core.ServerVersion;
import org.postgresql.core.SetupQueryRunner;
import org.postgresql.core.SocketFactoryFactory;
import org.postgresql.core.Utils;
import org.postgresql.core.Version;
import org.postgresql.core.v3.QueryExecutorImpl;
import org.postgresql.gss.MakeGSS;
import org.postgresql.hostchooser.CandidateHost;
import org.postgresql.hostchooser.GlobalHostStatusTracker;
import org.postgresql.hostchooser.HostChooser;
import org.postgresql.hostchooser.HostChooserFactory;
import org.postgresql.hostchooser.HostRequirement;
import org.postgresql.hostchooser.HostStatus;
import org.postgresql.jre8.sasl.ScramAuthenticator;
import org.postgresql.ssl.MakeSSL;
import org.postgresql.sspi.ISSPIClient;
import org.postgresql.util.GT;
import org.postgresql.util.HostSpec;
import org.postgresql.util.MD5Digest;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.ServerErrorMessage;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ConnectionFactory$ {
    public static final ConnectionFactory$ MODULE$ = new ConnectionFactory$();
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_MD5 = 5;
    private static final int AUTH_REQ_GSS = 7;
    private static final int AUTH_REQ_GSS_CONTINUE = 8;
    private static final int AUTH_REQ_SSPI = 9;
    private static final int AUTH_REQ_SASL = 10;
    private static final int AUTH_REQ_SASL_CONTINUE = 11;
    private static final int AUTH_REQ_SASL_FINAL = 12;

    private int AUTH_REQ_OK() {
        return AUTH_REQ_OK;
    }

    private int AUTH_REQ_PASSWORD() {
        return AUTH_REQ_PASSWORD;
    }

    private int AUTH_REQ_MD5() {
        return AUTH_REQ_MD5;
    }

    private int AUTH_REQ_GSS() {
        return AUTH_REQ_GSS;
    }

    private int AUTH_REQ_GSS_CONTINUE() {
        return AUTH_REQ_GSS_CONTINUE;
    }

    private int AUTH_REQ_SSPI() {
        return AUTH_REQ_SSPI;
    }

    private int AUTH_REQ_SASL() {
        return AUTH_REQ_SASL;
    }

    private int AUTH_REQ_SASL_CONTINUE() {
        return AUTH_REQ_SASL_CONTINUE;
    }

    private int AUTH_REQ_SASL_FINAL() {
        return AUTH_REQ_SASL_FINAL;
    }

    private ISSPIClient createSSPI(PGStream pgStream, String spnServiceClass, boolean enableNegotiate) {
        ISSPIClient iSSPIClient;
        try {
            Class<?> c = Class.forName("org.postgresql.sspi.SSPIClient");
            Class[] cArg = (Class[])((Object[])new Class[]{PGStream.class, String.class, Boolean.TYPE});
            iSSPIClient = (ISSPIClient)c.getDeclaredConstructor(cArg).newInstance(pgStream, spnServiceClass, BoxesRunTime.boxToBoolean((boolean)enableNegotiate));
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to load org.postgresql.sspi.SSPIClient. Please check that SSPIClient is included in your pgjdbc distribution.", e);
        }
        return iSSPIClient;
    }

    public PGStream openConnection(HostSpec[] hostSpecs, String user, String password, String database, Option<String> applicationName, Properties info) {
        HostRequirement hostRequirement;
        if (hostSpecs.length == 0) {
            throw new PSQLException("No hosts detected in connection string", PSQLState.CONNECTION_DOES_NOT_EXIST);
        }
        boolean requireSSL = false;
        boolean trySSL = false;
        String sslmode = PGProperty.SSL_MODE.get(info);
        if (sslmode == null) {
            requireSSL = trySSL = PGProperty.SSL.getBoolean(info) || "".equals(PGProperty.SSL.get(info));
        } else if ("disable".equals(sslmode)) {
            requireSSL = trySSL = false;
        } else if ("require".equals(sslmode) || "verify-ca".equals(sslmode) || "verify-full".equals(sslmode)) {
            requireSSL = trySSL = true;
        } else {
            throw new PSQLException(GT.tr((String)"Invalid sslmode value: {0}", (Object[])new Object[]{sslmode}), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        boolean requireTCPKeepAlive = PGProperty.TCP_KEEP_ALIVE.getBoolean(info);
        int connectTimeout = PGProperty.CONNECT_TIMEOUT.getInt(info) * 1000;
        String targetServerTypeStr = PGProperty.TARGET_SERVER_TYPE.get(info);
        try {
            hostRequirement = HostRequirement.getTargetServerType((String)targetServerTypeStr);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new PSQLException(GT.tr((String)"Invalid targetServerType value: {0}", (Object[])new Object[]{targetServerTypeStr}), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        HostRequirement targetServerType = hostRequirement;
        SocketFactory socketFactory = SocketFactoryFactory.getSocketFactory((Properties)info);
        HostChooser hostChooser = HostChooserFactory.createHostChooser((HostSpec[])hostSpecs, (HostRequirement)targetServerType, (Properties)info);
        Iterator hostIter = hostChooser.iterator();
        HashMap<HostSpec, HostStatus> knownStates = new HashMap<HostSpec, HostStatus>();
        None$ result = None$.MODULE$;
        while (result.isEmpty() && hostIter.hasNext()) {
            CandidateHost candidateHost = (CandidateHost)hostIter.next();
            HostSpec hostSpec = candidateHost.hostSpec;
            HostStatus knownStatus = (HostStatus)knownStates.get(hostSpec);
            if (knownStatus != null && !candidateHost.targetServerType.allowConnectingTo(knownStatus)) continue;
            PGStream newStream = null;
            try {
                int sendBufferSize;
                int socketTimeout;
                newStream = new PGStream(socketFactory, hostSpec, connectTimeout);
                if (trySSL) {
                    newStream = this.enableSSL(newStream, requireSSL, info, connectTimeout);
                }
                if ((socketTimeout = PGProperty.SOCKET_TIMEOUT.getInt(info)) > 0) {
                    newStream.getSocket().setSoTimeout(socketTimeout * 1000);
                }
                newStream.getSocket().setKeepAlive(requireTCPKeepAlive);
                int receiveBufferSize = PGProperty.RECEIVE_BUFFER_SIZE.getInt(info);
                if (receiveBufferSize > -1 && receiveBufferSize > 0) {
                    newStream.getSocket().setReceiveBufferSize(receiveBufferSize);
                }
                if ((sendBufferSize = PGProperty.SEND_BUFFER_SIZE.getInt(info)) > -1 && sendBufferSize > 0) {
                    newStream.getSocket().setSendBufferSize(sendBufferSize);
                }
                ArrayList<String[]> paramList = this.getParametersForStartup(user, database, applicationName, info);
                this.sendStartupPacket(newStream, paramList);
                this.doAuthentication(newStream, hostSpec.getHost(), user, password, info);
                int cancelSignalTimeout = PGProperty.CANCEL_SIGNAL_TIMEOUT.getInt(info) * 1000;
                QueryExecutorImpl queryExecutor = new QueryExecutorImpl(newStream, user, database, cancelSignalTimeout, info);
                HostStatus hostStatus = HostStatus.ConnectOK;
                if (candidateHost.targetServerType != HostRequirement.any) {
                    hostStatus = this.isMaster((QueryExecutor)queryExecutor) ? HostStatus.Master : HostStatus.Secondary;
                }
                GlobalHostStatusTracker.reportHostStatus((HostSpec)hostSpec, (HostStatus)hostStatus);
                knownStates.put(hostSpec, hostStatus);
                if (!candidateHost.targetServerType.allowConnectingTo(hostStatus)) {
                    queryExecutor.close();
                    continue;
                }
                this.runInitialQueries((QueryExecutor)queryExecutor, applicationName, info);
                result = new Some((Object)newStream);
            }
            catch (ConnectException cex) {
                GlobalHostStatusTracker.reportHostStatus((HostSpec)hostSpec, (HostStatus)HostStatus.ConnectFail);
                knownStates.put(hostSpec, HostStatus.ConnectFail);
                if (hostIter.hasNext()) continue;
                throw new PSQLException(GT.tr((String)"Connection to {0} refused. Check that the hostname and port are correct and that the postmaster is accepting TCP/IP connections.", (Object[])new Object[]{hostSpec}), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)cex);
            }
            catch (IOException ioe) {
                this.closeStream(newStream);
                GlobalHostStatusTracker.reportHostStatus((HostSpec)hostSpec, (HostStatus)HostStatus.ConnectFail);
                knownStates.put(hostSpec, HostStatus.ConnectFail);
                if (hostIter.hasNext()) continue;
                throw new PSQLException(GT.tr((String)"The connection attempt failed.", (Object[])new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ioe);
            }
            catch (SQLException se) {
                this.closeStream(newStream);
                GlobalHostStatusTracker.reportHostStatus((HostSpec)hostSpec, (HostStatus)HostStatus.ConnectFail);
                knownStates.put(hostSpec, HostStatus.ConnectFail);
                if (hostIter.hasNext()) continue;
                throw se;
            }
        }
        if (result.isEmpty()) {
            throw new PSQLException(GT.tr((String)"Could not find a server with specified targetServerType: {0}", (Object[])new Object[]{targetServerType}), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        return (PGStream)result.get();
    }

    private ArrayList<String[]> getParametersForStartup(String user, String database, Option<String> applicationName, Properties info) {
        Boolean bl;
        ArrayList<String[]> paramList = new ArrayList<String[]>();
        paramList.add((String[])((Object[])new String[]{"user", user}));
        paramList.add((String[])((Object[])new String[]{"database", database}));
        paramList.add((String[])((Object[])new String[]{"client_encoding", "UTF8"}));
        paramList.add((String[])((Object[])new String[]{"DateStyle", "ISO"}));
        paramList.add((String[])((Object[])new String[]{"TimeZone", this.createPostgresTimeZone()}));
        Version assumeVersion = ServerVersion.from((String)PGProperty.ASSUME_MIN_SERVER_VERSION.get(info));
        if (assumeVersion.getVersionNum() >= ServerVersion.v9_0.getVersionNum()) {
            paramList.add((String[])((Object[])new String[]{"extra_float_digits", "3"}));
            Option appName = applicationName.orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)PGProperty.APPLICATION_NAME.get(info)));
            bl = appName.isDefined() ? BoxesRunTime.boxToBoolean((boolean)paramList.add((String[])((Object[])new String[]{"application_name", (String)appName.get()}))) : BoxedUnit.UNIT;
        } else {
            bl = BoxesRunTime.boxToBoolean((boolean)paramList.add((String[])((Object[])new String[]{"extra_float_digits", "2"})));
        }
        String replication = PGProperty.REPLICATION.get(info);
        Object object = replication != null && assumeVersion.getVersionNum() >= ServerVersion.v9_4.getVersionNum() ? BoxesRunTime.boxToBoolean((boolean)paramList.add((String[])((Object[])new String[]{"replication", replication}))) : BoxedUnit.UNIT;
        String currentSchema = PGProperty.CURRENT_SCHEMA.get(info);
        Object object2 = currentSchema != null ? BoxesRunTime.boxToBoolean((boolean)paramList.add((String[])((Object[])new String[]{"search_path", currentSchema}))) : BoxedUnit.UNIT;
        return paramList;
    }

    /*
     * WARNING - void declaration
     */
    private String createPostgresTimeZone() {
        Object object;
        String tz = TimeZone.getDefault().getID();
        if (tz.length() <= 3 || !tz.startsWith("GMT")) {
            object = tz;
        } else {
            void var1_1;
            None$ none$;
            char sign;
            char c = sign = tz.charAt(3);
            switch (c) {
                case '+': {
                    none$ = new Some((Object)"GMT-");
                    break;
                }
                case '-': {
                    none$ = new Some((Object)"GMT+");
                    break;
                }
                default: {
                    none$ = None$.MODULE$;
                    break;
                }
            }
            None$ start = none$;
            object = start.isDefined() ? new StringBuilder(0).append((String)start.get()).append(tz.substring(4)).toString() : var1_1;
        }
        return object;
    }

    private PGStream enableSSL(PGStream pgStream, boolean requireSSL, Properties info, int connectTimeout) {
        PGStream pGStream;
        int beresp;
        pgStream.sendInteger4(8);
        pgStream.sendInteger2(1234);
        pgStream.sendInteger2(5679);
        pgStream.flush();
        int n = beresp = pgStream.receiveChar();
        switch (n) {
            case 69: {
                if (requireSSL) {
                    throw new PSQLException(GT.tr((String)"The server does not support SSL.", (Object[])new Object[0]), PSQLState.CONNECTION_REJECTED);
                }
                pgStream.close();
                pGStream = new PGStream(pgStream.getSocketFactory(), pgStream.getHostSpec(), connectTimeout);
                break;
            }
            case 78: {
                if (requireSSL) {
                    throw new PSQLException(GT.tr((String)"The server does not support SSL.", (Object[])new Object[0]), PSQLState.CONNECTION_REJECTED);
                }
                pGStream = pgStream;
                break;
            }
            case 83: {
                MakeSSL.convert((PGStream)pgStream, (Properties)info);
                pGStream = pgStream;
                break;
            }
            default: {
                throw new PSQLException(GT.tr((String)"An error occurred while setting up the SSL connection.", (Object[])new Object[0]), PSQLState.PROTOCOL_VIOLATION);
            }
        }
        return pGStream;
    }

    private void sendStartupPacket(PGStream pgStream, List<String[]> params) {
        int length = 8;
        byte[][] encodedParams = new byte[params.size() * 2][];
        for (int i = 0; i < params.size(); ++i) {
            encodedParams[i * 2] = params.get(i)[0].getBytes("UTF-8");
            encodedParams[i * 2 + 1] = params.get(i)[1].getBytes("UTF-8");
            length += encodedParams[i * 2].length + 1 + encodedParams[i * 2 + 1].length + 1;
        }
        pgStream.sendInteger4(++length);
        pgStream.sendInteger2(3);
        pgStream.sendInteger2(0);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])encodedParams), (Function1 & Serializable)encodedParam -> {
            ConnectionFactory$.$anonfun$sendStartupPacket$1(pgStream, encodedParam);
            return BoxedUnit.UNIT;
        });
        pgStream.sendChar(0);
        pgStream.flush();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doAuthentication(PGStream pgStream, String host, String user, String password, Properties info) {
        block29: {
            sspiClient = null;
            scramAuthenticator = null;
            try {
                authenticating = true;
lbl5:
                // 10 sources

                while (authenticating) {
                    var11_11 = beresp = pgStream.receiveChar();
                    switch (var11_11) {
                        case 69: {
                            l_elen = pgStream.receiveInteger4();
                            errorMsg = new ServerErrorMessage(pgStream.receiveErrorString(l_elen - 4));
                            throw new PSQLException(errorMsg);
                        }
                        case 82: {
                            ** GOTO lbl-1000
                        }
                        default: {
                            throw new PSQLException(GT.tr((String)"Protocol error.  Session setup failed.", (Object[])new Object[0]), PSQLState.PROTOCOL_VIOLATION);
                        }
                    }
                }
                break block29;
            }
            catch (Throwable var25_25) {
                if (sspiClient == null) throw var25_25;
                try {
                    sspiClient.dispose();
                    throw var25_25;
                }
                catch (RuntimeException v0) {}
                throw var25_25;
            }
lbl-1000:
            // 1 sources

            {
                l_msgLen = pgStream.receiveInteger4();
                var16_14 = areq = pgStream.receiveInteger4();
                if (this.AUTH_REQ_MD5() != var16_14) ** GOTO lbl-1000
                md5Salt = pgStream.receive(4);
                if (password != null) ** GOTO lbl-1000
                throw new PSQLException(GT.tr((String)"The server requested password-based authentication, but no password was provided.", (Object[])new Object[0]), PSQLState.CONNECTION_REJECTED);
            }
lbl-1000:
            // 1 sources

            {
                digest = MD5Digest.encode((byte[])user.getBytes("UTF-8"), (byte[])password.getBytes("UTF-8"), (byte[])md5Salt);
                pgStream.sendChar(112);
                pgStream.sendInteger4(4 + digest.length + 1);
                pgStream.send(digest);
                pgStream.sendChar(0);
                pgStream.flush();
                var6_9 = BoxedUnit.UNIT;
                ** GOTO lbl5
            }
lbl-1000:
            // 1 sources

            {
                if (this.AUTH_REQ_PASSWORD() != var16_14) ** GOTO lbl-1000
                if (password != null) ** GOTO lbl-1000
                throw new PSQLException(GT.tr((String)"The server requested password-based authentication, but no password was provided.", (Object[])new Object[0]), PSQLState.CONNECTION_REJECTED);
            }
lbl-1000:
            // 1 sources

            {
                encodedPassword = password.getBytes("UTF-8");
                pgStream.sendChar(112);
                pgStream.sendInteger4(4 + encodedPassword.length + 1);
                pgStream.send(encodedPassword);
                pgStream.sendChar(0);
                pgStream.flush();
                var6_9 = BoxedUnit.UNIT;
                ** GOTO lbl5
            }
lbl-1000:
            // 1 sources

            {
                if (this.AUTH_REQ_GSS() != var16_14) ** GOTO lbl-1000
                var6_9 = BoxedUnit.UNIT;
                ** GOTO lbl5
            }
lbl-1000:
            // 1 sources

            {
                block31: {
                    block30: {
                        if (this.AUTH_REQ_SSPI() != var16_14) ** GOTO lbl-1000
                        gsslib = PGProperty.GSS_LIB.get(info);
                        usespnego = PGProperty.USE_SPNEGO.getBoolean(info);
                        useSSPI = false;
                        if (areq != this.AUTH_REQ_GSS()) break block30;
                        v1 = gsslib;
                        var23_21 = "gssapi";
                        if (!(v1 == null ? var23_21 != null : v1.equals(var23_21) == false)) ** GOTO lbl-1000
                    }
                    if (useSSPI = (sspiClient = this.createSSPI(pgStream, PGProperty.SSPI_SERVICE_CLASS.get(info), areq == this.AUTH_REQ_SSPI() || areq == this.AUTH_REQ_GSS() && usespnego != false)).isSSPISupported()) ** GOTO lbl-1000
                    sspiClient = null;
                    v2 = gsslib;
                    var24_22 = "sspi";
                    if (v2 != null) break block31;
                    if (var24_22 == null) throw new PSQLException("SSPI forced with gsslib=sspi, but SSPI not available; set loglevel=2 for details", PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                    ** GOTO lbl-1000
                }
                if (!v2.equals(var24_22)) ** GOTO lbl-1000
                throw new PSQLException("SSPI forced with gsslib=sspi, but SSPI not available; set loglevel=2 for details", PSQLState.CONNECTION_UNABLE_TO_CONNECT);
            }
lbl-1000:
            // 4 sources

            {
                if (useSSPI) {
                    sspiClient.startSSPI();
                } else {
                    MakeGSS.authenticate((PGStream)pgStream, (String)host, (String)user, (String)password, (String)PGProperty.JAAS_APPLICATION_NAME.get(info), (String)PGProperty.KERBEROS_SERVER_NAME.get(info), (boolean)usespnego, (boolean)PGProperty.JAAS_LOGIN.getBoolean(info));
                }
                authenticating = false;
                var6_9 = BoxedUnit.UNIT;
                ** GOTO lbl5
            }
lbl-1000:
            // 1 sources

            {
                if (this.AUTH_REQ_GSS_CONTINUE() != var16_14) ** GOTO lbl-1000
                sspiClient.continueSSPI(l_msgLen - 8);
                var6_9 = BoxedUnit.UNIT;
                ** GOTO lbl5
            }
lbl-1000:
            // 1 sources

            {
                if (this.AUTH_REQ_SASL() != var16_14) ** GOTO lbl-1000
                scramAuthenticator = new ScramAuthenticator(user, password, pgStream);
                scramAuthenticator.processServerMechanismsAndInit();
                scramAuthenticator.sendScramClientFirstMessage();
                var6_9 = BoxedUnit.UNIT;
                ** GOTO lbl5
            }
lbl-1000:
            // 1 sources

            {
                if (this.AUTH_REQ_SASL_CONTINUE() != var16_14) ** GOTO lbl-1000
                scramAuthenticator.processServerFirstMessage(l_msgLen - 4 - 4);
                var6_9 = BoxedUnit.UNIT;
                ** GOTO lbl5
            }
lbl-1000:
            // 1 sources

            {
                if (this.AUTH_REQ_SASL_FINAL() != var16_14) ** GOTO lbl-1000
                scramAuthenticator.verifyServerSignature(l_msgLen - 4 - 4);
                var6_9 = BoxedUnit.UNIT;
                ** GOTO lbl5
            }
lbl-1000:
            // 1 sources

            {
                if (this.AUTH_REQ_OK() != var16_14) ** GOTO lbl-1000
                authenticating = false;
                var6_9 = BoxedUnit.UNIT;
                ** GOTO lbl5
            }
lbl-1000:
            // 1 sources

            {
                throw new PSQLException(GT.tr((String)"The authentication type {0} is not supported. Check that you have configured the pg_hba.conf file to include the client''s IP address or subnet, and that it is using an authentication scheme supported by the driver.", (Object[])new Object[]{BoxesRunTime.boxToInteger((int)areq)}), PSQLState.CONNECTION_REJECTED);
            }
        }
        if (sspiClient == null) return;
        try {
            sspiClient.dispose();
            return;
        }
        catch (RuntimeException v3) {
            return;
        }
    }

    private void runInitialQueries(QueryExecutor queryExecutor, Option<String> applicationName, Properties info) {
        block1: {
            String assumeMinServerVersion = PGProperty.ASSUME_MIN_SERVER_VERSION.get(info);
            if (Utils.parseServerVersionStr((String)assumeMinServerVersion) >= ServerVersion.v9_0.getVersionNum()) break block1;
            int dbVersion = queryExecutor.getServerVersionNum();
            Object object = dbVersion >= ServerVersion.v9_0.getVersionNum() ? (Object)SetupQueryRunner.run((QueryExecutor)queryExecutor, (String)"SET extra_float_digits = 3", (boolean)false) : BoxedUnit.UNIT;
            Option appName = applicationName.orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)PGProperty.APPLICATION_NAME.get(info)));
            if (appName.isDefined() && dbVersion >= ServerVersion.v9_0.getVersionNum()) {
                StringBuilder sql = new StringBuilder();
                sql.append("SET application_name = '");
                Utils.escapeLiteral((StringBuilder)sql, (String)((String)appName.get()), (boolean)queryExecutor.getStandardConformingStrings());
                sql.append("'");
                SetupQueryRunner.run((QueryExecutor)queryExecutor, (String)sql.toString(), (boolean)false);
            }
        }
    }

    private boolean isMaster(QueryExecutor queryExecutor) {
        byte[][] results = SetupQueryRunner.run((QueryExecutor)queryExecutor, (String)"show transaction_read_only", (boolean)true);
        String value = queryExecutor.getEncoding().decode(results[0]);
        return value.equalsIgnoreCase("off");
    }

    public void closeStream(PGStream newStream) {
        block2: {
            if (newStream == null) break block2;
            try {
                newStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static final /* synthetic */ void $anonfun$sendStartupPacket$1(PGStream pgStream$1, byte[] encodedParam) {
        pgStream$1.send(encodedParam);
        pgStream$1.sendChar(0);
    }

    private ConnectionFactory$() {
    }
}

