/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.warbucks.maven.plugin;

import com.google.common.reflect.ClassPath;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.revelc.code.warbucks.maven.plugin.CheckMojo;
import net.revelc.code.warbucks.maven.plugin.Rule;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

class RuleProcessor {
    private final Rule rule;
    private final String logPrefix;
    private final Log log;
    private final CheckMojo mojo;

    RuleProcessor(CheckMojo mojo, Rule rule, int n) {
        this.mojo = mojo;
        this.rule = rule;
        this.log = mojo.getLog();
        this.logPrefix = "Rule " + n + ": ";
    }

    private void debug(String s) {
        this.log.debug((CharSequence)(this.logPrefix + s));
    }

    private void error(String s) {
        this.log.error((CharSequence)(this.logPrefix + s));
    }

    private void warn(String s) {
        this.log.warn((CharSequence)(this.logPrefix + s));
    }

    private void info(String s) {
        this.log.info((CharSequence)(this.logPrefix + s));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long process() throws MojoExecutionException {
        this.debug("Begin processing");
        try (URLClassLoader cl = new URLClassLoader(RuleProcessor.getURLs(this.mojo.project.getTestClasspathElements()));){
            long failures = ClassPath.from((ClassLoader)cl).getAllClasses().stream().filter(this.isProjectClass()).filter(this.matchesClassPattern()).filter(this.hasRequiredAnnotation().negate()).count();
            this.info("Class Failures: " + failures);
            long l = failures;
            return l;
        }
        catch (IOException | DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Problem loading classes", (Exception)e);
        }
    }

    private Predicate<ClassPath.ClassInfo> isProjectClass() {
        String mainDir = this.mojo.project.getBuild().getOutputDirectory();
        String testDir = this.mojo.project.getBuild().getTestOutputDirectory();
        return x -> {
            boolean foundTestClass;
            boolean foundMainClass = this.rule.getIncludeMainClasses() && new File(mainDir, x.getResourceName()).exists();
            boolean bl = foundTestClass = !foundMainClass && this.rule.getIncludeTestClasses() && new File(testDir, x.getResourceName()).exists();
            if (foundMainClass) {
                this.debug("Found '" + x.getName() + "' in " + mainDir);
            } else if (foundTestClass) {
                this.debug("Found '" + x.getName() + "' in " + testDir);
            }
            return foundMainClass || foundTestClass;
        };
    }

    private Predicate<ClassPath.ClassInfo> matchesClassPattern() {
        Pattern classPattern = Pattern.compile(this.rule.getClassPattern());
        return x -> classPattern.matcher(x.getName()).matches();
    }

    private Predicate<ClassPath.ClassInfo> hasRequiredAnnotation() {
        Pattern classAnnotationPattern = Pattern.compile(this.rule.getClassAnnotationPattern());
        return x -> {
            boolean foundMatch = false;
            for (Annotation s : x.load().getAnnotations()) {
                this.debug("Found annotation class '" + s.annotationType().getName() + "' on class '" + x.getName() + "'");
                if (!classAnnotationPattern.matcher(s.annotationType().getName()).matches()) continue;
                foundMatch = true;
                break;
            }
            if (!foundMatch) {
                String failMessage = String.format("Class '%s' did not have an annotation matching the pattern '%s'", x.getName(), this.rule.getClassAnnotationPattern());
                if (this.mojo.ignoreRuleFailures) {
                    this.warn(failMessage);
                } else {
                    this.error(failMessage);
                }
            }
            return foundMatch;
        };
    }

    private static URL[] getURLs(Collection<String> classPathElements) {
        return (URL[])classPathElements.stream().distinct().map(element -> {
            try {
                return new File((String)element).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new AssertionError("Could not convert class path element to URL", e);
            }
        }).toArray(URL[]::new);
    }
}

