/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.apilyzer.maven.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

class PatternSet {
    private final List<Pattern> patterns;

    PatternSet(List<String> regexs) {
        if (regexs.size() == 0) {
            this.patterns = Collections.emptyList();
        } else {
            this.patterns = new ArrayList<Pattern>();
            for (String regex : regexs) {
                this.patterns.add(Pattern.compile(regex));
            }
        }
    }

    boolean matchesAny(String input) {
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(input).matches()) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.patterns.size();
    }
}

