/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.apilyzer.maven.plugin;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.reflect.ClassPath;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import net.revelc.code.apilyzer.maven.plugin.PatternSet;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="analyze", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class AnalyzeMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(alias="includes")
    private List<String> includes = Collections.emptyList();
    private PatternSet includesPs;
    @Parameter(alias="excludes")
    private List<String> excludes = Collections.emptyList();
    private PatternSet excludesPs;
    @Parameter(alias="allows")
    private List<String> allows = Collections.emptyList();
    private PatternSet allowsPs;
    @Parameter(alias="skip", property="apilyzer.skip", defaultValue="false")
    private boolean skip;
    @Parameter(alias="ignoreDeprecated", property="apilyzer.ignoreDeprecated", defaultValue="true")
    private boolean ignoreDeprecated;
    @Parameter(alias="outputFile", property="apilyzer.outputFile", defaultValue="${project.build.directory}/apilyzer.txt")
    private String outputFile;
    @Parameter(alias="ignoreProblems", property="apilyzer.ignoreProblems", defaultValue="false")
    private boolean ignoreProblems;
    @Parameter(alias="includeAnnotations")
    private List<String> includeAnnotations = Collections.emptyList();
    private PatternSet includeAnnotationsPs;
    @Parameter(alias="excludeAnnotations")
    private List<String> excludeAnnotations = Collections.emptyList();
    private PatternSet excludeAnnotationsPs;
    private static final String FORMAT = "  %-20s %-60s %-35s %s\n";

    public void execute() throws MojoFailureException, MojoExecutionException {
        block23: {
            ClassPath classPath;
            this.includesPs = new PatternSet(this.includes);
            this.excludesPs = new PatternSet(this.excludes);
            this.includeAnnotationsPs = new PatternSet(this.includeAnnotations);
            this.excludeAnnotationsPs = new PatternSet(this.excludeAnnotations);
            this.allowsPs = new PatternSet(this.allows);
            AtomicLong counter = new AtomicLong(0L);
            if (this.skip) {
                this.getLog().info((CharSequence)"APILyzer execution skipped");
                return;
            }
            try {
                classPath = this.getClassPath();
            }
            catch (IOException | IllegalArgumentException | DependencyResolutionRequiredException e) {
                throw new MojoExecutionException("Error resolving project classpath", (Exception)e);
            }
            try (PrintStream out = new PrintStream(new File(this.outputFile));){
                out.println("Includes: " + this.includes);
                out.println("IncludeAnnotations: " + this.includeAnnotations);
                out.println("ExcludesAnnotations: " + this.excludeAnnotations);
                out.println("Excludes: " + this.excludes);
                out.println("Allowed: " + this.allows);
                ArrayList publicApiClasses = new ArrayList();
                TreeSet<String> publicSet = new TreeSet<String>();
                this.buildPublicSet(classPath, publicApiClasses, publicSet);
                if (publicSet.size() == 0) {
                    throw new MojoExecutionException("No public API types were matched");
                }
                out.println();
                out.println("Public API:");
                for (String string : publicSet) {
                    out.println("  " + string);
                }
                out.println();
                out.println("Problems : ");
                out.println();
                out.printf(FORMAT, "CONTEXT", "TYPE", "FIELD/METHOD", "NON-PUBLIC REFERENCE");
                out.println();
                for (Class clazz : publicApiClasses) {
                    this.checkClass(clazz, publicSet, out, counter);
                }
                out.println();
                out.println("Total : " + counter.get());
                String msg = "APILyzer found " + counter.get() + " problem" + (counter.get() == 1L ? "" : "s") + ".";
                msg = msg + " See " + this.outputFile + " for details.";
                if (counter.get() < 0L) {
                    throw new AssertionError((Object)"Inconceivable!");
                }
                if (counter.get() == 0L) {
                    this.getLog().info((CharSequence)msg);
                    break block23;
                }
                if (counter.get() > 0L && this.ignoreProblems) {
                    this.getLog().warn((CharSequence)msg);
                    break block23;
                }
                this.getLog().error((CharSequence)msg);
                throw new MojoFailureException(msg);
            }
            catch (FileNotFoundException e) {
                throw new MojoExecutionException("Bad configuration: cannot create specified outputFile", (Exception)e);
            }
        }
    }

    private ClassPath getClassPath() throws DependencyResolutionRequiredException, IOException {
        List urls = Lists.transform((List)this.project.getCompileClasspathElements(), (Function)new Function<String, URL>(){

            public URL apply(String input) {
                try {
                    return new File(input).toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Unable to convert string (" + input + ") to URL", e);
                }
            }
        });
        URLClassLoader cl = new URLClassLoader(urls.toArray(new URL[0]), null);
        return ClassPath.from((ClassLoader)cl);
    }

    private Annotation[] getAnnotations(ClassPath.ClassInfo classInfo) {
        if (classInfo.getName().startsWith("com.sun") || classInfo.getName().startsWith("java.")) {
            return new Annotation[0];
        }
        return this.getAnnotations(classInfo.load());
    }

    private Annotation[] getAnnotations(Class<?> clazz) {
        return clazz.getDeclaredAnnotations();
    }

    private void buildPublicSet(ClassPath classPath, List<Class<?>> publicApiClasses, TreeSet<String> publicSet) {
        block0: for (ClassPath.ClassInfo classInfo : classPath.getAllClasses()) {
            if (this.patternExcludes(classInfo)) continue;
            Annotation[] annotations = this.includeAnnotationsPs.size() > 0 || this.excludeAnnotationsPs.size() > 0 ? this.getAnnotations(classInfo) : new Annotation[]{};
            for (Annotation annotation : annotations) {
                if (!this.includeAnnotationsPs.matchesAny(annotation.toString())) continue;
                if (this.annotationExcludes(annotations)) continue block0;
                this.addPublicApiType(publicApiClasses, publicSet, classInfo);
                continue block0;
            }
            if (!this.includesPs.matchesAny(classInfo.getName()) || this.annotationExcludes(annotations)) continue;
            this.addPublicApiType(publicApiClasses, publicSet, classInfo);
        }
    }

    private void addPublicApiType(List<Class<?>> publicApiClasses, TreeSet<String> publicSet, ClassPath.ClassInfo classInfo) {
        Class clazz = classInfo.load();
        if (this.isPublicOrProtected(clazz) && !publicSet.contains(clazz.getName())) {
            publicApiClasses.add(clazz);
            publicSet.add(clazz.getName());
            this.addPublicInnerClasses(publicApiClasses, publicSet, clazz);
        }
    }

    private void addPublicInnerClasses(List<Class<?>> publicApiClasses, TreeSet<String> publicSet, Class<?> clazz) {
        Class<?>[] innerClasses;
        for (Class<?> ic : innerClasses = clazz.getDeclaredClasses()) {
            if (!this.isPublicOrProtected(ic) || publicSet.contains(ic.getName()) || this.annotationExcludes(ic) || this.patternExcludes(ic)) continue;
            publicApiClasses.add(ic);
            publicSet.add(ic.getName());
            this.addPublicInnerClasses(publicApiClasses, publicSet, ic);
        }
    }

    private boolean patternExcludes(ClassPath.ClassInfo classInfo) {
        return this.excludesPs.matchesAny(classInfo.getName());
    }

    private boolean patternExcludes(Class<?> clazz) {
        return this.excludesPs.matchesAny(clazz.getName());
    }

    private boolean annotationExcludes(Annotation[] annotations) {
        if (this.excludeAnnotationsPs.size() == 0) {
            return false;
        }
        for (Annotation annotation : annotations) {
            if (!this.excludeAnnotationsPs.matchesAny(annotation.toString())) continue;
            return true;
        }
        return false;
    }

    private boolean annotationExcludes(Class<?> clazz) {
        Annotation[] annotations;
        if (this.excludeAnnotationsPs.size() == 0) {
            return false;
        }
        for (Annotation annotation : annotations = this.getAnnotations(clazz)) {
            if (!this.excludeAnnotationsPs.matchesAny(annotation.toString())) continue;
            return true;
        }
        return false;
    }

    private boolean isOk(Set<String> publicSet, Class<?> clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if (clazz.isPrimitive()) {
            return true;
        }
        String fqName = clazz.getName();
        if (publicSet.contains(fqName)) {
            return true;
        }
        if (fqName.startsWith("java.")) {
            return true;
        }
        return this.allowsPs.matchesAny(fqName);
    }

    private List<Field> getFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(clazz.getFields()));
        for (Field f : clazz.getDeclaredFields()) {
            if ((f.getModifiers() & 4) == 0) continue;
            fields.add(f);
        }
        return fields;
    }

    private List<Method> getMethods(Class<?> clazz) {
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(clazz.getMethods()));
        for (Method m : clazz.getDeclaredMethods()) {
            if ((m.getModifiers() & 4) == 0) continue;
            methods.add(m);
        }
        return methods;
    }

    private List<Class<?>> getInnerClasses(Class<?> clazz) {
        ArrayList classes = new ArrayList(Arrays.asList(clazz.getClasses()));
        for (Class<?> c : clazz.getDeclaredClasses()) {
            if ((c.getModifiers() & 4) == 0) continue;
            classes.add(c);
        }
        return classes;
    }

    private boolean checkClass(Class<?> clazz, Set<String> publicSet, PrintStream out, AtomicLong counter) {
        return this.checkClass(clazz, publicSet, out, counter, new HashSet());
    }

    private boolean checkClass(Class<?> clazz, Set<String> publicSet, PrintStream out, AtomicLong counter, Set<Class<?>> innerChecked) {
        boolean ok = true;
        if (this.ignoreDeprecated && clazz.isAnnotationPresent(Deprecated.class)) {
            return true;
        }
        for (Field field : this.getFields(clazz)) {
            if (this.ignoreDeprecated && field.isAnnotationPresent(Deprecated.class) || !field.getDeclaringClass().getName().equals(clazz.getName()) && this.isOk(publicSet, field.getDeclaringClass()) || this.isOk(publicSet, field.getType())) continue;
            this.problem(out, counter, ProblemType.FIELD, clazz, field.getName(), field.getType().getName());
            ok = false;
        }
        Constructor<?>[] constructors = clazz.getConstructors();
        for (Constructor<?> constructor : constructors) {
            Class<?>[] params;
            if (constructor.isSynthetic() || this.ignoreDeprecated && constructor.isAnnotationPresent(Deprecated.class)) continue;
            for (Class<?> param : params = constructor.getParameterTypes()) {
                if (this.isOk(publicSet, param)) continue;
                this.problem(out, counter, ProblemType.CTOR_PARAM, clazz, "(...)", param.getName());
                ok = false;
            }
        }
        for (Method method : this.getMethods(clazz)) {
            Class<?>[] params;
            if (method.isSynthetic() || method.isBridge() || this.ignoreDeprecated && method.isAnnotationPresent(Deprecated.class) || !method.getDeclaringClass().getName().equals(clazz.getName()) && this.isOk(publicSet, method.getDeclaringClass())) continue;
            if (!this.isOk(publicSet, method.getReturnType())) {
                this.problem(out, counter, ProblemType.METHOD_RETURN, clazz, method.getName() + "(...)", method.getReturnType().getName());
                ok = false;
            }
            for (Class<?> param : params = method.getParameterTypes()) {
                if (this.isOk(publicSet, param)) continue;
                this.problem(out, counter, ProblemType.METHOD_PARAM, clazz, method.getName() + "(...)", param.getName());
                ok = false;
            }
        }
        for (Class clazz2 : this.getInnerClasses(clazz)) {
            if (innerChecked.contains(clazz2)) continue;
            innerChecked.add(clazz2);
            if (this.ignoreDeprecated && clazz2.isAnnotationPresent(Deprecated.class) || this.patternExcludes(clazz2) || this.annotationExcludes(clazz2) || this.isOk(publicSet, clazz2) || this.checkClass(clazz2, publicSet, out, counter, innerChecked)) continue;
            this.problem(out, counter, ProblemType.INNER_CLASS, clazz, "N/A", clazz2.getName());
            ok = false;
        }
        return ok;
    }

    private boolean isPublicOrProtected(Class<?> clazz) {
        return (clazz.getModifiers() & 5) != 0;
    }

    private void problem(PrintStream out, AtomicLong counter, ProblemType type, Class<?> clazz, String member, String problemRef) {
        counter.incrementAndGet();
        out.printf(FORMAT, new Object[]{type, clazz.getName(), member, problemRef});
    }

    private static enum ProblemType {
        INNER_CLASS,
        METHOD_PARAM,
        METHOD_RETURN,
        FIELD,
        CTOR_PARAM;

    }
}

