/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.dic;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.List;
import org.wltea.analyzer.cfg.Configuration;
import org.wltea.analyzer.dic.DictSegment;
import org.wltea.analyzer.dic.Hit;

public class Dictionary {
    public static final String PATH_DIC_MAIN = "dic/main.dic";
    public static final String PATH_DIC_SURNAME = "dic/surname.dic";
    public static final String PATH_DIC_QUANTIFIER = "dic/quantifier.dic";
    public static final String PATH_DIC_SUFFIX = "dic/suffix.dic";
    public static final String PATH_DIC_PREP = "dic/preposition.dic";
    public static final String PATH_DIC_STOP = "dic/stopword.dic";
    private static final Dictionary singleton = new Dictionary();
    private DictSegment _MainDict;
    private DictSegment _SurnameDict;
    private DictSegment _QuantifierDict;
    private DictSegment _SuffixDict;
    private DictSegment _PrepDict;
    private DictSegment _StopWords;

    private Dictionary() {
        this.loadMainDict();
        this.loadSurnameDict();
        this.loadQuantifierDict();
        this.loadSuffixDict();
        this.loadPrepDict();
        this.loadStopWordDict();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMainDict() {
        this._MainDict = new DictSegment(Character.valueOf('\u0000'));
        InputStream is = Dictionary.class.getClassLoader().getResourceAsStream(PATH_DIC_MAIN);
        if (is == null) {
            throw new RuntimeException("Main Dictionary not found!!!");
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"), 512);
            String theWord = null;
            do {
                if ((theWord = br.readLine()) == null || "".equals(theWord.trim())) continue;
                this._MainDict.fillSegment(theWord.trim().toCharArray());
            } while (theWord != null);
        }
        catch (IOException ioe) {
            System.err.println("Main Dictionary loading exception.");
            ioe.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                    is = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        List<String> extDictFiles = Configuration.getExtDictionarys();
        if (extDictFiles != null) {
            for (String extDictName : extDictFiles) {
                is = Dictionary.class.getClassLoader().getResourceAsStream(extDictName);
                if (is == null) continue;
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"), 512);
                    String theWord = null;
                    do {
                        if ((theWord = br.readLine()) == null || "".equals(theWord.trim())) continue;
                        this._MainDict.fillSegment(theWord.trim().toCharArray());
                    } while (theWord != null);
                }
                catch (IOException ioe) {
                    System.err.println("Extension Dictionary loading exception.");
                    ioe.printStackTrace();
                }
                finally {
                    try {
                        if (is == null) continue;
                        is.close();
                        is = null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSurnameDict() {
        this._SurnameDict = new DictSegment(Character.valueOf('\u0000'));
        InputStream is = Dictionary.class.getClassLoader().getResourceAsStream(PATH_DIC_SURNAME);
        if (is == null) {
            throw new RuntimeException("Surname Dictionary not found!!!");
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"), 512);
            String theWord = null;
            do {
                if ((theWord = br.readLine()) == null || "".equals(theWord.trim())) continue;
                this._SurnameDict.fillSegment(theWord.trim().toCharArray());
            } while (theWord != null);
        }
        catch (IOException ioe) {
            System.err.println("Surname Dictionary loading exception.");
            ioe.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                    is = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadQuantifierDict() {
        this._QuantifierDict = new DictSegment(Character.valueOf('\u0000'));
        InputStream is = Dictionary.class.getClassLoader().getResourceAsStream(PATH_DIC_QUANTIFIER);
        if (is == null) {
            throw new RuntimeException("Quantifier Dictionary not found!!!");
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"), 512);
            String theWord = null;
            do {
                if ((theWord = br.readLine()) == null || "".equals(theWord.trim())) continue;
                this._QuantifierDict.fillSegment(theWord.trim().toCharArray());
            } while (theWord != null);
        }
        catch (IOException ioe) {
            System.err.println("Quantifier Dictionary loading exception.");
            ioe.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                    is = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSuffixDict() {
        this._SuffixDict = new DictSegment(Character.valueOf('\u0000'));
        InputStream is = Dictionary.class.getClassLoader().getResourceAsStream(PATH_DIC_SUFFIX);
        if (is == null) {
            throw new RuntimeException("Suffix Dictionary not found!!!");
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"), 512);
            String theWord = null;
            do {
                if ((theWord = br.readLine()) == null || "".equals(theWord.trim())) continue;
                this._SuffixDict.fillSegment(theWord.trim().toCharArray());
            } while (theWord != null);
        }
        catch (IOException ioe) {
            System.err.println("Suffix Dictionary loading exception.");
            ioe.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                    is = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPrepDict() {
        this._PrepDict = new DictSegment(Character.valueOf('\u0000'));
        InputStream is = Dictionary.class.getClassLoader().getResourceAsStream(PATH_DIC_PREP);
        if (is == null) {
            throw new RuntimeException("Preposition Dictionary not found!!!");
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"), 512);
            String theWord = null;
            do {
                if ((theWord = br.readLine()) == null || "".equals(theWord.trim())) continue;
                this._PrepDict.fillSegment(theWord.trim().toCharArray());
            } while (theWord != null);
        }
        catch (IOException ioe) {
            System.err.println("Preposition Dictionary loading exception.");
            ioe.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                    is = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadStopWordDict() {
        this._StopWords = new DictSegment(Character.valueOf('\u0000'));
        InputStream is = Dictionary.class.getClassLoader().getResourceAsStream(PATH_DIC_STOP);
        if (is == null) {
            throw new RuntimeException("Stopword Dictionary not found!!!");
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"), 512);
            String theWord = null;
            do {
                if ((theWord = br.readLine()) == null || "".equals(theWord.trim())) continue;
                this._StopWords.fillSegment(theWord.trim().toCharArray());
            } while (theWord != null);
        }
        catch (IOException ioe) {
            System.err.println("Stopword Dictionary loading exception.");
            ioe.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                    is = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        List<String> extStopWordDictFiles = Configuration.getExtStopWordDictionarys();
        if (extStopWordDictFiles != null) {
            for (String extStopWordDictName : extStopWordDictFiles) {
                is = Dictionary.class.getClassLoader().getResourceAsStream(extStopWordDictName);
                if (is == null) continue;
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"), 512);
                    String theWord = null;
                    do {
                        if ((theWord = br.readLine()) == null || "".equals(theWord.trim())) continue;
                        this._StopWords.fillSegment(theWord.trim().toCharArray());
                    } while (theWord != null);
                }
                catch (IOException ioe) {
                    System.err.println("Extension Stop word Dictionary loading exception.");
                    ioe.printStackTrace();
                }
                finally {
                    try {
                        if (is == null) continue;
                        is.close();
                        is = null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static Dictionary getInstance() {
        return singleton;
    }

    public static void loadExtendWords(Collection<String> extWords) {
        if (extWords != null) {
            for (String extWord : extWords) {
                if (extWord == null) continue;
                Dictionary.singleton._MainDict.fillSegment(extWord.trim().toCharArray());
            }
        }
    }

    public static void loadExtendStopWords(Collection<String> extStopWords) {
        if (extStopWords != null) {
            for (String extStopWord : extStopWords) {
                if (extStopWord == null) continue;
                Dictionary.singleton._StopWords.fillSegment(extStopWord.trim().toCharArray());
            }
        }
    }

    public static Hit matchInMainDict(char[] charArray) {
        return Dictionary.singleton._MainDict.match(charArray);
    }

    public static Hit matchInMainDict(char[] charArray, int begin, int length) {
        return Dictionary.singleton._MainDict.match(charArray, begin, length);
    }

    public static Hit matchWithHit(char[] charArray, int currentIndex, Hit matchedHit) {
        DictSegment ds = matchedHit.getMatchedDictSegment();
        return ds.match(charArray, currentIndex, 1, matchedHit);
    }

    public static Hit matchInSurnameDict(char[] charArray, int begin, int length) {
        return Dictionary.singleton._SurnameDict.match(charArray, begin, length);
    }

    public static Hit matchInQuantifierDict(char[] charArray, int begin, int length) {
        return Dictionary.singleton._QuantifierDict.match(charArray, begin, length);
    }

    public static Hit matchInSuffixDict(char[] charArray, int begin, int length) {
        return Dictionary.singleton._SuffixDict.match(charArray, begin, length);
    }

    public static Hit matchInPrepDict(char[] charArray, int begin, int length) {
        return Dictionary.singleton._PrepDict.match(charArray, begin, length);
    }

    public static boolean isStopWord(char[] charArray, int begin, int length) {
        return Dictionary.singleton._StopWords.match(charArray, begin, length).isMatch();
    }
}

