/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.cfg;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Properties;
import org.wltea.analyzer.dic.Dictionary;
import org.wltea.analyzer.seg.CJKSegmenter;
import org.wltea.analyzer.seg.ISegmenter;
import org.wltea.analyzer.seg.LetterSegmenter;
import org.wltea.analyzer.seg.QuantifierSegmenter;

public class Configuration {
    private static final String FILE_NAME = "/IKAnalyzer.cfg.xml";
    private static final String EXT_DICT = "ext_dict";
    private static final String EXT_STOP = "ext_stopwords";
    private static final Configuration CFG = new Configuration();
    private Properties props = new Properties();

    private Configuration() {
        InputStream input = Configuration.class.getResourceAsStream(FILE_NAME);
        if (input != null) {
            try {
                this.props.loadFromXML(input);
            }
            catch (InvalidPropertiesFormatException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static List<String> getExtDictionarys() {
        String[] filePaths;
        ArrayList<String> extDictFiles = new ArrayList<String>(2);
        String extDictCfg = Configuration.CFG.props.getProperty(EXT_DICT);
        if (extDictCfg != null && (filePaths = extDictCfg.split(";")) != null) {
            for (String filePath : filePaths) {
                if (filePath == null || "".equals(filePath.trim())) continue;
                extDictFiles.add(filePath.trim());
            }
        }
        return extDictFiles;
    }

    public static List<String> getExtStopWordDictionarys() {
        String[] filePaths;
        ArrayList<String> extStopWordDictFiles = new ArrayList<String>(2);
        String extStopWordDictCfg = Configuration.CFG.props.getProperty(EXT_STOP);
        if (extStopWordDictCfg != null && (filePaths = extStopWordDictCfg.split(";")) != null) {
            for (String filePath : filePaths) {
                if (filePath == null || "".equals(filePath.trim())) continue;
                extStopWordDictFiles.add(filePath.trim());
            }
        }
        return extStopWordDictFiles;
    }

    public static List<ISegmenter> loadSegmenter() {
        Dictionary.getInstance();
        ArrayList<ISegmenter> segmenters = new ArrayList<ISegmenter>(4);
        segmenters.add(new QuantifierSegmenter());
        segmenters.add(new CJKSegmenter());
        segmenters.add(new LetterSegmenter());
        return segmenters;
    }
}

