/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.wltea.analyzer.Context;
import org.wltea.analyzer.Lexeme;
import org.wltea.analyzer.cfg.Configuration;
import org.wltea.analyzer.help.CharacterHelper;
import org.wltea.analyzer.seg.ISegmenter;

public final class IKSegmentation {
    private Reader input;
    private static final int BUFF_SIZE = 3072;
    private static final int BUFF_EXHAUST_CRITICAL = 48;
    private char[] segmentBuff;
    private Context context;
    private List<ISegmenter> segmenters;

    public IKSegmentation(Reader input) {
        this(input, false);
    }

    public IKSegmentation(Reader input, boolean isMaxWordLength) {
        this.input = input;
        this.segmentBuff = new char[3072];
        this.context = new Context(this.segmentBuff, isMaxWordLength);
        this.segmenters = Configuration.loadSegmenter();
    }

    public synchronized Lexeme next() throws IOException {
        if (this.context.getResultSize() == 0) {
            int available = this.fillBuffer(this.input);
            if (available <= 0) {
                this.context.resetContext();
                return null;
            }
            int analyzedLength = 0;
            for (int buffIndex = 0; buffIndex < available; ++buffIndex) {
                this.context.setCursor(buffIndex);
                this.segmentBuff[buffIndex] = CharacterHelper.regularize(this.segmentBuff[buffIndex]);
                for (ISegmenter segmenter : this.segmenters) {
                    segmenter.nextLexeme(this.segmentBuff, this.context);
                }
                ++analyzedLength;
                if (available == 3072 && buffIndex < available - 1 && buffIndex > available - 48 && !this.context.isBufferLocked()) break;
            }
            for (ISegmenter segmenter : this.segmenters) {
                segmenter.reset();
            }
            this.context.setLastAnalyzed(analyzedLength);
            this.context.setBuffOffset(this.context.getBuffOffset() + analyzedLength);
            if (this.context.isMaxWordLength()) {
                this.context.excludeOverlap();
            }
            return this.buildLexeme(this.context.firstLexeme());
        }
        return this.buildLexeme(this.context.firstLexeme());
    }

    private int fillBuffer(Reader reader) throws IOException {
        int readCount = 0;
        if (this.context.getBuffOffset() == 0) {
            readCount = reader.read(this.segmentBuff);
        } else {
            int offset = this.context.getAvailable() - this.context.getLastAnalyzed();
            if (offset > 0) {
                System.arraycopy(this.segmentBuff, this.context.getLastAnalyzed(), this.segmentBuff, 0, offset);
                readCount = offset;
            }
            readCount += reader.read(this.segmentBuff, offset, 3072 - offset);
        }
        this.context.setAvailable(readCount);
        return readCount;
    }

    private Lexeme buildLexeme(Lexeme lexeme) {
        if (lexeme != null) {
            lexeme.setLexemeText(String.valueOf(this.segmentBuff, lexeme.getBegin(), lexeme.getLength()));
            return lexeme;
        }
        return null;
    }

    public synchronized void reset(Reader input) {
        this.input = input;
        this.context.resetContext();
        for (ISegmenter segmenter : this.segmenters) {
            segmenter.reset();
        }
    }
}

