/*
 * Decompiled with CFR 0.152.
 */
package net.relaysoft.robot.jms.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;

public final class MessageContentUtils {
    private MessageContentUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Object> convertByteArrayToMap(byte[] serialisedMap) {
        ByteArrayInputStream bin = new ByteArrayInputStream(serialisedMap);
        try (ObjectInputStream in = new ObjectInputStream(bin);){
            Map map = (Map)in.readObject();
            return map;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Fatal error! Cannot find Map class from classpath. Reason: " + e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write byte message content into map. Reason: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] convertMapToByteArray(Map<String, Object> map) {
        HashMap<String, Object> tempMap = new HashMap<String, Object>();
        tempMap.putAll(map);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(bout);){
            out.writeObject(tempMap);
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write map message content into byte array. Reason: " + e.getMessage());
        }
    }
}

