/*
 * Decompiled with CFR 0.152.
 */
package net.relaysoft.robot.jms.keywords;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jms.JMSException;
import net.relaysoft.robot.jms.client.JMSClient;
import net.relaysoft.robot.jms.client.JMSClientFactory;
import net.relaysoft.robot.jms.utils.MessageTypeEnum;
import net.relaysoft.robot.jms.utils.PrintUtil;
import net.relaysoft.robot.jms.utils.StringUtils;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywordOverload;
import org.robotframework.javalib.annotation.RobotKeywords;

@RobotKeywords
public class JMSKeywords {
    protected static final long DEFAULT_TIMEOUT = 2000L;
    private static final String LATEST = "latest";
    private JMSClient client;

    @RobotKeyword(value="Clear all messages stored in client internal cache.\n\nExamples:\n| Clear Messages |")
    public void clearMessages() {
        this.client.clearMessages();
    }

    @RobotKeyword(value="Close connection to connected MQ-broker. If client is not connected then this keyword has no any affect.\n\nExamples:\n| Close Connection |")
    public void closeConnection() throws JMSException {
        this.client.closeConnection();
    }

    @RobotKeyword(value="Creates new temporary queue into remote broker. Return name of the temporary queue.\n\nExamples:\n| Create Temporary Queue |")
    public String createTemporaryQueue() throws JMSException {
        return this.client.createTemporaryQueue();
    }

    @RobotKeyword(value="Creates new temporary topic into remote broker. Return name of the temporary topic.\n\nExamples:\n| Create Temporary Topic |")
    public String createTemporaryTopic() throws JMSException {
        return this.client.createTemporaryTopic();
    }

    @RobotKeyword(value="Deletes existing temporary queue from remote broker.\n\nArguments:\n- _queueName_: Temporary queue's name\n\nExamples:\n| Delete Temporary Queue | ${QUEUE_NAME} |")
    @ArgumentNames(value={"queueName"})
    public void deleteTemporaryQueue(String queueName) throws JMSException {
        PrintUtil.printOut("Deleting temporary queue: " + queueName);
        this.client.deleteTemporaryQueue(queueName);
    }

    @RobotKeyword(value="Deletes existing temporary topic from remote broker.\n\nArguments:\n- _topicName_: Temporary topic's name\n\nExamples:\n| Delete Temporary Topic | ${TOPIC_NAME} |")
    @ArgumentNames(value={"topicName"})
    public void deleteTemporaryTopic(String topicName) throws JMSException {
        PrintUtil.printOut("Deleting temporary topic: " + topicName);
        this.client.deleteTemporaryTopic(topicName);
    }

    @RobotKeyword(value="Return byte content for the message read from queue/topic. If message ID is not given then keyword will return the content of the most recent message read from the queue/topic.\n\nArguments:\n- _messageID_: Message's ID\n- filePath: Optional path to file for saving message content\n\nExamples:\n| Get Message Byte Content | messageID=${MESSAGE_ID} | filePath=${FILE_PATH} |\n| Get Message Byte Content | ${MESSAGE_ID} |\n| Get Message Byte Content | filePath=${FILE_PATH} |")
    @ArgumentNames(value={"messageID=", "filePath="})
    public byte[] getMessageByteContent(String messageID, String filePath) throws JMSException {
        PrintUtil.printOut("Getting byte content from message: " + (messageID != null ? messageID : LATEST));
        byte[] content = this.client.getMessageByteContent(messageID);
        if (StringUtils.isNotBlank(filePath)) {
            this.writeToFile(filePath, content);
        }
        return content;
    }

    @RobotKeywordOverload
    public byte[] getMessageByteContent(String messageID) throws JMSException {
        return this.getMessageByteContent(messageID, null);
    }

    @RobotKeywordOverload
    public byte[] getMessageByteContent() throws JMSException {
        return this.getMessageByteContent(null, null);
    }

    @RobotKeyword(value="Return ID of the current JMS client initialized by this library.\n\nExamples:\n| Get Client ID |")
    public String getClientID() {
        return this.client.getClientID();
    }

    @RobotKeyword(value="Return map content for the message read from queue/topic. If message ID is not given then keyword will return the content of the most recent message read from the queue/topic.\n\nArguments:\n- _messageID_: Message's ID\n\nExamples:\n| Get Message Map Content | ${MESSAGE_ID} |")
    @ArgumentNames(value={"messageID="})
    public Map<String, Object> getMessageMapContent(String messageID) throws JMSException {
        PrintUtil.printOut("Getting map content from message: " + (messageID != null ? messageID : LATEST));
        return this.client.getMessageMapContent(messageID);
    }

    @RobotKeywordOverload
    public Map<String, Object> getMessageMapContent() throws JMSException {
        return this.getMessageMapContent(null);
    }

    @RobotKeyword(value="Return correlation ID for the message read from queue/topic. If message ID is not given then keyword will return the correlation ID of the most recent message read from the queue/topic.\n\nArguments:\n- _messageID_: Message's ID\n\nExamples:\n| Get Message Correlation ID | ${MESSAGE_ID} |")
    @ArgumentNames(value={"messageID="})
    public String getMessageCorrelationID(String messageID) throws JMSException {
        PrintUtil.printOut("Getting correlation ID from message: " + (messageID != null ? messageID : LATEST));
        return this.client.getMessageCorrelationID(messageID);
    }

    @RobotKeywordOverload
    public String getMessageCorrelationID() throws JMSException {
        return this.getMessageCorrelationID(null);
    }

    @RobotKeyword(value="Return destination name for the message read from queue/topic. If message ID is not given then keyword will return the destination name of the most recent message read from the queue/topic.\n\nArguments:\n- _messageID_: Message's ID\n\nExamples:\n| Get Message Destination Name | ${MESSAGE_ID} |")
    @ArgumentNames(value={"messageID="})
    public String getMessageDestinationName(String messageID) throws JMSException {
        PrintUtil.printOut("Getting destination name from message: " + (messageID != null ? messageID : LATEST));
        return this.client.getMessageDestinationName(messageID);
    }

    @RobotKeywordOverload
    public String getMessageDestinationName() throws JMSException {
        return this.getMessageDestinationName(null);
    }

    @RobotKeyword(value="Return expiration time for the message read from queue/topic. If message ID is not given then keyword will return the expiration time of the most recent message read from the queue/topic.\n\nArguments:\n- _messageID_: Message's ID\n\nExamples:\n| Get Message Expiration Time | ${MESSAGE_ID} |")
    @ArgumentNames(value={"messageID="})
    public long getMessageExpirationTime(String messageID) throws JMSException {
        PrintUtil.printOut("Getting expiration time from message: " + (messageID != null ? messageID : LATEST));
        return this.client.getMessageExpirationTime(messageID);
    }

    @RobotKeywordOverload
    public long getMessageExpirationTime() throws JMSException {
        return this.getMessageExpirationTime(null);
    }

    @RobotKeyword(value="Return ID for the most recent message read from queue/topic.\n\nExamples:\n| Get Message ID | |")
    @ArgumentNames(value={"messageID="})
    public String getMessageID() throws JMSException {
        return this.client.getMessageID(null);
    }

    @RobotKeyword(value="Return priority for the message read from queue/topic. If message ID is not given then keyword will return the priority of the most recent message read from the queue/topic.\n\nArguments:\n- _messageID_: Message's ID\n\nExamples:\n| Get Message Priority | ${MESSAGE_ID} |")
    @ArgumentNames(value={"messageID="})
    public int getMessagePriority(String messageID) throws JMSException {
        PrintUtil.printOut("Getting priority from message: " + (messageID != null ? messageID : LATEST));
        return this.client.getMessagePriority(messageID);
    }

    @RobotKeywordOverload
    public int getMessagePriority() throws JMSException {
        return this.getMessagePriority(null);
    }

    @RobotKeyword(value="Return property value for the message read from queue/topic. If message ID is not given then keyword will return the property value of the most recent message read from the queue/topic.\n\nArguments:\n- _propertyName_: Property name\n- _messageID_: Message's ID\n\nExamples:\n| Get Message Property | ${PROPERTY_NAME} | ${MESSAGE_ID} |\n| Get Message Property | ${PROPERTY_NAME} | |")
    @ArgumentNames(value={"propertyName", "messageID="})
    public Object getMessageProperty(String propertyName, String messageID) throws JMSException {
        PrintUtil.printOut("Getting message property '" + propertyName + "' value from message: " + (messageID != null ? messageID : LATEST));
        return this.client.getMessageProperty(propertyName, messageID);
    }

    @RobotKeywordOverload
    public Object getMessageProperty(String propertyName) throws JMSException {
        return this.getMessageProperty(propertyName, null);
    }

    @RobotKeyword(value="Return reply to destination name for the message read from queue/topic. If message ID is not given then keyword will return the reply to destination name of the most recent message read from the queue/topic.\n\nArguments:\n- _messageID_: Message's ID\n\nExamples:\n| Get Message Reply To Queue | ${MESSAGE_ID} |")
    @ArgumentNames(value={"messageID="})
    public String getMessageReplyToQueue(String messageID) throws JMSException {
        PrintUtil.printOut("Getting reply to queue from message: " + (messageID != null ? messageID : LATEST));
        return this.client.getMessageReplyToQueue(messageID);
    }

    @RobotKeywordOverload
    public String getMessageReplyToQueue() throws JMSException {
        return this.getMessageReplyToQueue(null);
    }

    @RobotKeyword(value="Return timestamp for the message read from queue/topic. If message ID is not given then keyword will return the timestamp of the most recent message read from the queue/topic.\n\nArguments:\n- _messageID_: Message's ID\n\nExamples:\n| Get Message Timestamp | ${MESSAGE_ID} |")
    @ArgumentNames(value={"messageID="})
    public long getMessageTimestamp(String messageID) throws JMSException {
        PrintUtil.printOut("Getting timestamp from message: " + (messageID != null ? messageID : LATEST));
        return this.client.getMessageTimestamp(messageID);
    }

    @RobotKeywordOverload
    public long getMessageTimestamp() throws JMSException {
        return this.getMessageTimestamp(null);
    }

    @RobotKeyword(value="Return JMS type for the message read from queue/topic. If message ID is not given then keyword will return the JMS type of the most recent message read from the queue/topic.\n\nArguments:\n- _messageID_: Message's ID\n\nExamples:\n| Get Message Type | ${MESSAGE_ID} |")
    @ArgumentNames(value={"messageID="})
    public String getMessageType(String messageID) throws JMSException {
        PrintUtil.printOut("Getting type from message: " + (messageID != null ? messageID : LATEST));
        return this.client.getMessageType(messageID);
    }

    @RobotKeywordOverload
    public String getMessageType() throws JMSException {
        return this.getMessageType(null);
    }

    @RobotKeyword(value="Return text content for the message read from queue/topic. If message ID is not given then keyword will return the content of the most recent message read from the queue/topic.\n\nArguments:\n- _messageID_: Message's ID\n\nExamples:\n| Get Message Text Content | ${MESSAGE_ID} |")
    @ArgumentNames(value={"messageID="})
    public String getMessageTextContent(String messageID) throws JMSException {
        PrintUtil.printOut("Getting text content from message: " + (messageID != null ? messageID : LATEST));
        return this.client.getMessageTextContent(messageID);
    }

    @RobotKeywordOverload
    public String getMessageTextContent() throws JMSException {
        return this.getMessageTextContent(null);
    }

    @RobotKeyword(value="Return amount of messages in queue.\n\nArguments:\n- _queueName_: Name of the queue to get the depth\n\nExamples:\n| Get Queue Depth | ${QUEUE_NAME} |")
    @ArgumentNames(value={"queueName"})
    public Integer getQueueDepth(String queueName) throws JMSException {
        PrintUtil.printOut("Depth for the queue: " + queueName);
        return this.client.getQueueDepth(queueName);
    }

    @RobotKeyword(value="Initialize JMS client. This keyword need to be executed before any others can be used. Calling this keyword more than once leads to override of previous client unless it is currently connected, in which case calling this keyword has no affect.\n\nConnection specific parameters are given in dictionary variable. In case of default JNDI provider dictionary must contain needed JNDI key value pairs.\nExample parameter dictionary content for default JNDI provider:\n| java.naming.factory.initial=org.apache.activemq.jndi.ActiveMQInitialContextFactory | java.naming.provider.url=tcp://localhost:61616 |\n\nIn case of Active MQ specific provider dictionary must contain needed Active MQ connection factory specific variables.\n\nSupported values are:\n- _brokerUrl_: Contains broker URL information. Check detailed information from [http://activemq.apache.org|Active MQ] website.\n\nExample parameter dictionary content for Active MQ provider:\n| brokerUrl=tcp://localhost:61616 |\n\nIn case of IBM MQ specific provider dictionary must contain needed IBM MQ connection factory specific variables.\n\nSupported values are:\n- _hostName_: Broker host name.\n- _channel_: Broker channel used for the client.\n- _port_: Port number.\n- _queueManager_: Queue manager name.\n- _transportType_: Transport type e.g. _CLIENT_ number (1) or _BINDINGS_ number (2).\n\nExample parameter dictionary content for IBM MQ provider:\n| hostName=localhost | channel=testChannel | port=${4444} | queueManager=testQueueManager | transportType=${1} |\n\nArguments:\n- _clientID_: Unique ID for the JMS client\n- _parameters_: Map (dictionary) of parameters used for client initialization.\n- _version_: Optional JMS API version. Valid values are number 1 (1.1) or 2 (2.x). By default value 1 is used.\n- _providerName_: Optional provider name if provider specific connection factory need to be used. Currently supported values are '_ACTIVEMQ_' and '_IBMMQ_'. If not given then default JNDI connection factory will be used.\n\nExamples:\n| Initialize Client | clientID=robotClient | parameters=${PARAMETERS} | providerName=ACTIVEMQ | version=${1} |\n| Initialize Client | clientID=robotClient | parameters=${PARAMETERS} | providerName=ACTIVEMQ | |\n| Initialize Client | clientID=robotClient | parameters=${PARAMETERS} | | |")
    @ArgumentNames(value={"clientID", "parameters", "providerName=", "version="})
    public void initializeClient(String clientID, Map<String, Object> parameters, String providerName, Integer version) throws Exception {
        PrintUtil.printOut("Initializing new JMS version: " + version + " client with name '" + clientID + "' for " + (providerName != null ? providerName : "default") + " provider with paramters: " + parameters.toString());
        this.client = JMSClientFactory.getJMSClient(clientID, version, providerName);
        this.client.initializeClient(parameters);
    }

    @RobotKeywordOverload
    public void initializeClient(String clientID, Map<String, Object> parameters, String providerName) throws Exception {
        this.initializeClient(clientID, parameters, providerName, 1);
    }

    @RobotKeywordOverload
    public void initializeClient(String clientID, Map<String, Object> parameters) throws Exception {
        this.initializeClient(clientID, parameters, null, 1);
    }

    @RobotKeyword(value="Initialize JMS client. This keyword need to be executed before any others can be used. Calling this keyword more than once leads to override of previous client unless it is currently connected, in which case calling this keyword has no affect.\n\nConnection specific parameters are given in external property file. In case of default JNDI provider property file must contain needed JNDI properties.\nExample property file content for default JNDI provider:\n| java.naming.factory.initial=org.apache.activemq.jndi.ActiveMQInitialContextFactory |\n| java.naming.provider.url=tcp://localhost:61616 |\n\nIn case of Active MQ specific provider property file must contain needed Active MQ connection factory specific variables.\n\nSupported values are:\n- _brokerUrl_: Contains broker URL information. Check detailed information from [http://activemq.apache.org|Active MQ] website.\n\nExample property file content for Active MQ provider:\n| brokerUrl=tcp://localhost:61616 |\n\nIn case of IBM MQ specific provider property file must contain needed IBM MQ connection factory specific variables.\n\nSupported values are:\n- _hostName_: Broker host name.\n- _channel_: Broker channel used for the client.\n- _port_: Port number.\n- _queueManager_: Queue manager name.\n- _transportType_: Transport type e.g. _CLIENT_ number (1) or _BINDINGS_ number (2).\n\nExample property file content for IBM MQ provider:\n| hostName=localhost |\n| channel=testChannel |\n| port=4444 |\n| queueManager=testQueueManager |\n| transportType=1 |\n\nArguments:\n- _clientID_: Unique ID for the JMS client\n- _propertiesFile_: Path to external properties file containing provider specific configuration.\n- _version_: Optional JMS API version. Valid values are number 1 (1.1) or 2 (2.x). By default value 1 is used.\n- _providerName_: Optional provider name if provider specific connection factory need to be used. Currently supported values are '_ACTIVEMQ_' and '_IBMMQ_'. If not given then default JNDI connection factory will be used.\n\nExamples:\n| Initialize Client From File | clientID=robotClient | propertiesFile=/path/to/file | providerName=ACTIVEMQ | version=${1} |\n| Initialize Client From File | clientID=robotClient | propertiesFile=/path/to/file | providerName=ACTIVEMQ | |\n| Initialize Client From File | clientID=robotClient | propertiesFile=/path/to/file | | |")
    @ArgumentNames(value={"clientID", "propertiesFile", "providerName=", "version="})
    public void initializeClientFromFile(String clientID, String propertiesFile, String providerName, Integer version) throws Exception {
        PrintUtil.printOut("Initializing new JMS version: " + version + " client with name '" + clientID + "' for " + (providerName != null ? providerName : "default") + " provider with paramters from file: " + propertiesFile);
        this.client = JMSClientFactory.getJMSClient(clientID, version, providerName);
        this.client.initializeClient(this.convertProperties2Map(this.loadProperties(propertiesFile)));
    }

    @RobotKeywordOverload
    public void initializeClientFromFile(String clientID, String propertiesFile, String providerName) throws Exception {
        this.initializeClientFromFile(clientID, propertiesFile, providerName, 1);
    }

    @RobotKeywordOverload
    public void initializeClientFromFile(String clientID, String propertiesFile) throws Exception {
        this.initializeClientFromFile(clientID, propertiesFile, null, 1);
    }

    @RobotKeyword(value="Open client connection to message broker. Client must be initialized with keyword `initializeClient` or `initializeClientFromFile` before connecting. After connecting all the other keywords can be used.\n\nArguments:\n- _userName_: Optional username for authentication if requirred by the broker\n- _password_: Optional password for authentication if requirred by the broker\n\nExamples:\n| Open Connection | userName=${USERNAME} | password=${PASSWORD} |\n| Open Connection | | |")
    @ArgumentNames(value={"userName=", "password="})
    public void openConnection(String userName, String password) throws JMSException {
        if (userName != null && password != null) {
            PrintUtil.printOut("Opening connection with username and password");
        }
        this.client.openConnection(userName, password);
    }

    @RobotKeywordOverload
    public void openConnection() throws JMSException {
        this.openConnection(null, null);
    }

    @RobotKeyword(value="Publishes new JMS message into topic.\n\nPublish keyword can use certain JMS parameters when publishing the message given in _parameters_ variable.\nFollowing parameters can be given:\n- _deliveryDelay_: Delay for the delivery in milliseconds\n- _deliveryMode_: Message delivery mode _PERSISTENT_ (1) or _NON PERSISTENT_ (0)\n- _correlationId_: Correlation ID for the message. E.g. when using _replyTo_ parameter\n- _replyTo_: Reply to destination name\n- _type_: JMS type\n- _priority_: Message's priority. Numeric value between 1-9\n- _timeToLive_: Time to live in milliseconds\nArguments:\n- _topicName_: Name of the topic to publish\n- _content_: JMS Message content. Can be String, dictionary, binary data\n- _parameters_: Optional dictionary of JMS parameter key value pairs used for publishing\n- _properties_: Optional dictionary of JMS message property key value pairs to be set for the published message\n\nExamples:\n| Publish Into Topic | topicName=testTopic | content=Test content | parameters=${PARAMETERS} | properties=${PROPERTIES} |\n| Publish Into Topic | topicName=testTopic | content=Test content | parameters=${PARAMETERS} | |\n| Publish Into Topic | topicName=testTopic | content=Test content | | |")
    @ArgumentNames(value={"topicName", "content=", "parameters=", "properties="})
    public void publishIntoTopic(String topicName, Object content, Map<String, Object> parameters, Map<String, Object> properties) throws JMSException {
        PrintUtil.printOut("Publish new message into topic '" + topicName + "' with content: " + content.toString());
        this.printOutMessageParamsAndProps(parameters, properties);
        if (content instanceof String) {
            this.client.publishIntoTopic(topicName, (String)content, parameters, properties);
        } else if (content instanceof Map) {
            this.client.publishIntoTopic(topicName, (Map)content, parameters, properties);
        } else if (content instanceof byte[]) {
            this.client.publishIntoTopic(topicName, (byte[])content, parameters, properties);
        } else {
            throw new JMSException("Unsupported JMS message content type: " + content.getClass().getName());
        }
    }

    @RobotKeywordOverload
    public void publishIntoTopic(String topicName, Object content, Map<String, Object> parameters) throws JMSException {
        this.publishIntoTopic(topicName, content, parameters, null);
    }

    @RobotKeywordOverload
    public void publishIntoTopic(String topicName, Object content) throws JMSException {
        this.publishIntoTopic(topicName, content, null, null);
    }

    @RobotKeyword(value="Publishes new JMS message into topic with content from external file.\n\nPublish keyword can use certain JMS parameters when publishing the message given in _parameters_ variable.\nFollowing parameters can be given:\n- _deliveryDelay_: Delay for the delivery in milliseconds\n- _deliveryMode_: Message delivery mode _PERSISTENT_ (1) or _NON PERSISTENT_ (0)\n- _correlationId_: Correlation ID for the message. E.g. when using _replyTo_ parameter\n- _replyTo_: Reply to destination name\n- _type_: JMS type\n- _priority_: Message's priority. Numeric value between 1-9\n- _timeToLive_: Time to live in milliseconds\nArguments:\n- _topicName_: Name of the topic to publish\n- _filePath_: Path to file which contains content for the JSM message\n- _type_: Content type for the JMS message: _TEXT_, _BYTE_ or _MAP_. _BYTE_ is default value\n- _parameters_: Optional dictionary of JMS parameter key value pairs used for publishing\n- _properties_: Optional dictionary of JMS message property key value pairs to be set for the published message\n\nExamples:\n| Publish Into Topic From File | topicName=testTopic | filePath=/path/to/file | type=BYTE | parameters=${PARAMETERS} | properties=${PROPERTIES} |\n| Publish Into Topic From File | topicName=testTopic | filePath=/path/to/file | type=BYTE | parameters=${PARAMETERS} | |\n| Publish Into Topic From File | topicName=testTopic | filePath=/path/to/file | type=BYTE | | |\n| Publish Into Topic From File | topicName=testTopic | filePath=/path/to/file | | | |")
    @ArgumentNames(value={"topicName", "filePath", "type=", "parameters=", "properties="})
    public void publishIntoTopicFromFile(String topicName, String filePath, String type, Map<String, Object> parameters, Map<String, Object> properties) throws IOException, JMSException {
        PrintUtil.printOut("Publish new message into topic '" + topicName + "' with content from file: " + filePath);
        this.printOutMessageParamsAndProps(parameters, properties);
        byte[] byteContent = Files.readAllBytes(Paths.get(filePath, new String[0]));
        if (StringUtils.isNotBlank(type) && type.equalsIgnoreCase(MessageTypeEnum.TEXT.toString())) {
            this.client.publishIntoTopic(topicName, new String(byteContent, StandardCharsets.UTF_8), parameters, properties);
        } else {
            this.client.publishIntoTopic(topicName, byteContent, parameters, properties);
        }
    }

    @RobotKeywordOverload
    public void publishIntoTopicFromFile(String topicName, String filePath, String type, Map<String, Object> parameters) throws IOException, JMSException {
        this.publishIntoTopicFromFile(topicName, filePath, type, parameters, null);
    }

    @RobotKeywordOverload
    public void publishIntoTopicFromFile(String topicName, String filePath, String type) throws IOException, JMSException {
        this.publishIntoTopicFromFile(topicName, filePath, type, null, null);
    }

    @RobotKeywordOverload
    public void publishIntoTopicFromFile(String topicName, String filePath) throws IOException, JMSException {
        this.publishIntoTopicFromFile(topicName, filePath, null, null, null);
    }

    @RobotKeyword(value="Delete all messages from queue.\n\n\nNOTE: Queue purification is made by JMS API so there may be a delay after successfull keyword execution before the queue is actually empty.\n\nArguments:\n- _queueName_: Name of the queue to purge\n\nExamples:\n| Purge Queue | testQueue |")
    @ArgumentNames(value={"queueName"})
    public void purgeQueue(String queueName) throws JMSException {
        PrintUtil.printOut("Purge all messages from queue: " + queueName);
        this.client.purgeQueue(queueName);
    }

    @RobotKeyword(value="Read single JMS message from queue. Returns message ID. If there are no messages awailable in queue return NULL.\n\nArguments:\n- _queueName_: Name of the queue from which message is read from\n- _timeout_: Optional timeout in milliseconds to wait for message to be awailable for reading. Default value is 2000 milliseconds\n- _messageSelector_: Optional message selector string\n\nExamples:\n| Read From Queue | queueName=testQueue | timeout=${2000} | messageSelector=${MESSAGE_SELECTOR} |\n| Read From Queue | queueName=testQueue | timeout=${2000} | |\n| Read From Queue | queueName=testQueue | | |")
    @ArgumentNames(value={"queueName", "timeout=", "messageSelector="})
    public String readFromQueue(String queueName, Long timeout, String messageSelector) throws JMSException {
        PrintUtil.printOut("Read message from queue '" + queueName + "' with timeout value of " + (timeout != null ? timeout : 2000L) + " milliseconds");
        if (messageSelector != null) {
            PrintUtil.printOut("Using message selector value: " + messageSelector);
        }
        return this.client.readFromQueue(queueName, timeout != null ? timeout : 2000L, messageSelector);
    }

    @RobotKeywordOverload
    public String readFromQueue(String queueName, Long timeout) throws JMSException {
        return this.readFromQueue(queueName, timeout, null);
    }

    @RobotKeywordOverload
    public String readFromQueue(String queueName) throws JMSException {
        return this.readFromQueue(queueName, 2000L, null);
    }

    @RobotKeyword(value="Read single JMS message from topic. Returns message ID. If there are no messages awailable in topic return NULL There must be active subscription made into topic with `Subscribe Topic` keyword before messages can be read or topic must be temporary type.\n\nArguments:\n- _queueName_: Name of the durable subscription or \n- _timeout_: Optional timeout in milliseconds to wait for message to be awailable for reading. Default value is 2000 milliseconds\n\n\nExamples:\n| Read From Topic | name=testSubscription | timeout=${2000} |\n| Read From Topic | name=testSubscription | |")
    @ArgumentNames(value={"name", "timeout="})
    public String readFromTopic(String name, Long timeout) throws JMSException {
        PrintUtil.printOut("Read message from topic/subscription '" + name + "' with timeout value of " + (timeout != null ? timeout : 2000L) + " milliseconds");
        return this.client.readFromTopic(name, timeout != null ? timeout : 2000L);
    }

    @RobotKeywordOverload
    public String readFromTopic(String name) throws JMSException {
        return this.readFromTopic(name, 2000L);
    }

    @RobotKeyword(value="Create durable subscription into topic.\n\nArguments:\n- _topicName_: Name of the topic to subscribe\n- _name_: Unique name for the subscription\n- _messageSelector_: Optional message selector string\n\nExamples:\n| Subscribe Topic | topicName=testQueue | name=testSubscription | messageSelector=${MESSAGE_SELECTOR} |\n| Subscribe Topic | topicName=testQueue | name=testSubscription | |")
    @ArgumentNames(value={"topicName", "name", "messageSelector="})
    public void subscribeTopic(String topicName, String name, String messageSelector) throws JMSException {
        PrintUtil.printOut("Creating subcription into topic '" + topicName + "' with name: " + name);
        if (messageSelector != null) {
            PrintUtil.printOut("Using message selector value: " + messageSelector);
        }
        this.client.subscribeTopic(topicName, name, messageSelector);
    }

    @RobotKeywordOverload
    public void subscribeTopic(String topicName, String name) throws JMSException {
        this.subscribeTopic(topicName, name, null);
    }

    @RobotKeyword(value="Cancel topic subscription.\n\nArguments:\n- _name_: Subscription name\n\n\nExamples:\n| Unsubscribe Topic | testSubscription |")
    @ArgumentNames(value={"name"})
    public void unsubscribeTopic(String name) throws JMSException {
        PrintUtil.printOut("Unsubscribe: " + name);
        this.client.unsubscribeTopic(name);
    }

    @RobotKeyword(value="Writes new JMS message into queue.\n\nWrite keyword can use certain JMS parameters when writing the message given in _parameters_ variable.\nFollowing parameters can be given:\n- _deliveryDelay_: Delay for the delivery in milliseconds\n- _deliveryMode_: Message delivery mode _PERSISTENT_ (1) or _NON PERSISTENT_ (0)\n- _correlationId_: Correlation ID for the message. E.g. when using _replyTo_ parameter\n- _replyTo_: Reply to destination name\n- _type_: JMS type\n- _priority_: Message's priority. Numeric value between 1-9\n- _timeToLive_: Time to live in milliseconds\nArguments:\n- _queueName_: Name of the queue to write into\n- _content_: JMS Message content. Can be String, dictionary, binary data\n- _parameters_: Optional dictionary of JMS parameter key value pairs used for writing\n- _properties_: Optional dictionary of JMS message property key value pairs to be set for the message\n\nExamples:\n| Write Into Queue | queueName=testQueue | content=Test content | parameters=${PARAMETERS} | properties=${PROPERTIES} |\n| Write Into Queue | queueName=testQueue | content=Test content | parameters=${PARAMETERS} | |\n| Write Into Queue | queueName=testQueue | content=Test content | | |")
    @ArgumentNames(value={"queueName", "content", "parameters=", "properties="})
    public void writeIntoQueue(String queueName, Object content, Map<String, Object> parameters, Map<String, Object> properties) throws JMSException {
        PrintUtil.printOut("Write new message into queue '" + queueName + "' with content: " + content.toString());
        this.printOutMessageParamsAndProps(parameters, properties);
        if (content instanceof String) {
            this.client.writeIntoQueue(queueName, (String)content, parameters, properties);
        } else if (content instanceof Map) {
            this.client.writeIntoQueue(queueName, (Map)content, parameters, properties);
        } else if (content instanceof byte[]) {
            this.client.writeIntoQueue(queueName, (byte[])content, parameters, properties);
        } else {
            throw new JMSException("Unsupported JMS message content type: " + content.getClass().getName());
        }
    }

    @RobotKeywordOverload
    public void writeIntoQueue(String queueName, Object content, Map<String, Object> parameters) throws JMSException {
        this.writeIntoQueue(queueName, content, parameters, null);
    }

    @RobotKeywordOverload
    public void writeIntoQueue(String queueName, Object content) throws JMSException {
        this.writeIntoQueue(queueName, content, null, null);
    }

    @RobotKeyword(value="Writes new JMS message into queue with content from external file.\n\nWrite keyword can use certain JMS parameters when writing the message given in _parameters_ variable.\nFollowing parameters can be given:\n- _deliveryDelay_: Delay for the delivery in milliseconds\n- _deliveryMode_: Message delivery mode _PERSISTENT_ (1) or _NON PERSISTENT_ (0)\n- _correlationId_: Correlation ID for the message. E.g. when using _replyTo_ parameter\n- _replyTo_: Reply to destination name\n- _type_: JMS type\n- _priority_: Message's priority. Numeric value between 1-9\n- _timeToLive_: Time to live in milliseconds\nArguments:\n- _queueName_: Name of the topic to write into\n- _filePath_: Path to file which contains content for the JSM message\n- _type_: Content type for the JMS message: _TEXT_, _BYTE_ or _MAP_. _BYTE_ is default value\n- _parameters_: Optional dictionary of JMS parameter key value pairs used for writing\n- _properties_: Optional dictionary of JMS message property key value pairs to be set for the message\n\nExamples:\n| Write Into Queue From File | queueName=testQueue | filePath=/path/to/file | type=BYTE | parameters=${PARAMETERS} | properties=${PROPERTIES} |\n| Write Into Queue From File | queueName=testQueue | filePath=/path/to/file | type=BYTE | parameters=${PARAMETERS} | |\n| Write Into Queue From File | queueName=testQueue | filePath=/path/to/file | type=BYTE | | |\n| Write Into Queue From File | queueName=testQueue | filePath=/path/to/file | | | |")
    @ArgumentNames(value={"queueName", "filePath", "type=", "parameters=", "properties="})
    public void writeIntoQueueFromFile(String queueName, String filePath, String type, Map<String, Object> parameters, Map<String, Object> properties) throws IOException, JMSException {
        PrintUtil.printOut("Write new message into queue '" + queueName + "' with content from file: " + filePath);
        this.printOutMessageParamsAndProps(parameters, properties);
        byte[] byteContent = Files.readAllBytes(Paths.get(filePath, new String[0]));
        if (StringUtils.isNotBlank(type) && type.equalsIgnoreCase(MessageTypeEnum.TEXT.toString())) {
            this.client.writeIntoQueue(queueName, new String(byteContent, StandardCharsets.UTF_8), parameters, properties);
        } else {
            this.client.writeIntoQueue(queueName, byteContent, parameters, properties);
        }
    }

    @RobotKeywordOverload
    public void writeIntoQueueFromFile(String queueName, String filePath, String type, Map<String, Object> parameters) throws IOException, JMSException {
        this.writeIntoQueueFromFile(queueName, filePath, type, parameters, null);
    }

    @RobotKeywordOverload
    public void writeIntoQueueFromFile(String queueName, String filePath, String type) throws IOException, JMSException {
        this.writeIntoQueueFromFile(queueName, filePath, type, null, null);
    }

    @RobotKeywordOverload
    public void writeIntoQueueFromFile(String queueName, String filePath) throws IOException, JMSException {
        this.writeIntoQueueFromFile(queueName, filePath, null, null, null);
    }

    private Map<String, Object> convertProperties2Map(Properties properties) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String name : properties.stringPropertyNames()) {
            map.put(name, properties.get(name));
        }
        return map;
    }

    private Properties loadProperties(String filePath) throws IOException {
        Properties properties = new Properties();
        try (FileInputStream is = new FileInputStream(filePath);){
            properties.load(is);
        }
        return properties;
    }

    private void printOutMessageParamsAndProps(Map<String, Object> parameters, Map<String, Object> properties) {
        if (parameters != null && !parameters.isEmpty()) {
            PrintUtil.printOut("Using parameters: " + parameters.toString());
        }
        if (properties != null && !properties.isEmpty()) {
            PrintUtil.printOut("Adding message properties: " + properties.toString());
        }
    }

    private void writeToFile(String filePath, Object content) {
        try {
            Path file = Paths.get(filePath, new String[0]);
            if (content instanceof String) {
                Files.write(file, ((String)content).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            } else {
                Files.write(file, (byte[])content, new OpenOption[0]);
            }
        }
        catch (IOException e) {
            PrintUtil.printOut("Failed to write message content into file: " + filePath + ". Reason: " + e.getMessage());
        }
    }
}

