/*
 * Decompiled with CFR 0.152.
 */
package net.relaysoft.robot.jms.client;

import net.relaysoft.robot.jms.client.AbstractJMSClient;
import net.relaysoft.robot.jms.client.ActiveMQ11Client;
import net.relaysoft.robot.jms.client.DefaultJMS11Client;
import net.relaysoft.robot.jms.client.DefaultJMS20Client;
import net.relaysoft.robot.jms.client.IBMMQ11Client;
import net.relaysoft.robot.jms.client.IBMMQ20Client;
import net.relaysoft.robot.jms.client.JMSClient;
import net.relaysoft.robot.jms.utils.StringUtils;

public final class JMSClientFactory {
    public static final int JMS_VERSION_1 = 1;
    public static final int JMS_VERSION_2 = 2;
    public static final String PROVIDER_JNDI = "JNDI";
    public static final String PROVIDER_ACTIVEMQ = "ACTIVEMQ";
    public static final String PROVIDER_IBMMQ = "IBMMQ";

    private JMSClientFactory() {
    }

    public static JMSClient getJMSClient(String clientID) {
        return JMSClientFactory.getJMSClient(clientID, 1);
    }

    public static JMSClient getJMSClient(String clientID, int version) {
        return JMSClientFactory.getJMSClient(clientID, version, PROVIDER_JNDI);
    }

    public static JMSClient getJMSClient(String clientID, int version, String providerName) {
        AbstractJMSClient client = null;
        if (JMSClientFactory.isJMSVersion2(version)) {
            if (JMSClientFactory.isDefaultClient(providerName)) {
                client = new DefaultJMS20Client(clientID);
            } else if (providerName.equalsIgnoreCase(PROVIDER_IBMMQ)) {
                client = new IBMMQ20Client(clientID);
            }
        } else if (JMSClientFactory.isDefaultClient(providerName)) {
            client = new DefaultJMS11Client(clientID);
        } else if (providerName.equalsIgnoreCase(PROVIDER_ACTIVEMQ)) {
            client = new ActiveMQ11Client(clientID);
        } else if (providerName.equalsIgnoreCase(PROVIDER_IBMMQ)) {
            client = new IBMMQ11Client(clientID);
        }
        if (client == null) {
            throw new NullPointerException(JMSClientFactory.getErrorMessage(providerName, version));
        }
        return client;
    }

    private static String getErrorMessage(String providerName, int version) {
        String provider = StringUtils.isNotBlank(providerName) ? providerName : "default";
        return "JMS version " + version + " implementation is not available for the " + provider + " provider.";
    }

    private static boolean isDefaultClient(String providerName) {
        return StringUtils.isBlank(providerName) || providerName.equals(PROVIDER_JNDI);
    }

    private static boolean isJMSVersion2(int version) {
        return version == 2;
    }
}

