/*
 * Decompiled with CFR 0.152.
 */
package net.relaysoft.robot.jms.client;

import java.util.HashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.TextMessage;
import net.relaysoft.robot.jms.client.JMSClient;
import net.relaysoft.robot.jms.utils.MessageTypeEnum;
import net.relaysoft.robot.jms.utils.StringUtils;

public abstract class AbstractJMSClient
implements JMSClient {
    protected static final String CONNECTION_FACTORY_NAME = "ConnectionFactory";
    protected static final String INVALID_MESSAGE_EXCEPTION = "Invalid JMS message type ";
    protected ConnectionFactory factory = null;
    protected Map<String, Destination> temporaryDestinations = null;
    private String clientID = null;
    private boolean connected = false;
    private Message latestMessage = null;
    private Map<String, Message> readMessages = null;

    public AbstractJMSClient(String clientID) {
        this.clientID = clientID;
        this.temporaryDestinations = new HashMap<String, Destination>();
        this.readMessages = new HashMap<String, Message>();
    }

    protected abstract ConnectionFactory createConnectionFactory(Map<String, Object> var1) throws Exception;

    @Override
    public void clearMessages() {
        this.readMessages.clear();
        this.latestMessage = null;
    }

    @Override
    public void closeConnection() throws JMSException {
        this.temporaryDestinations.clear();
        this.connected = false;
    }

    @Override
    public String getClientID() {
        return this.clientID;
    }

    @Override
    public void openConnection() throws JMSException {
        this.connected = true;
    }

    @Override
    public MessageTypeEnum resolveMessageType(String messageID) {
        return this.resolveMessageType(this.getMessage(messageID));
    }

    protected String addMessage(Message message) throws JMSException {
        if (message != null) {
            this.latestMessage = message;
            this.readMessages.put(message.getJMSMessageID(), message);
            return message.getJMSMessageID();
        }
        return null;
    }

    protected Message getMessage(String messageID) {
        if (StringUtils.isNotBlank(messageID)) {
            return this.readMessages.get(messageID);
        }
        return this.latestMessage;
    }

    protected boolean isConnected() {
        return this.connected;
    }

    protected MessageTypeEnum resolveMessageType(Message message) {
        if (message != null) {
            if (message instanceof TextMessage) {
                return MessageTypeEnum.TEXT;
            }
            if (message instanceof BytesMessage) {
                return MessageTypeEnum.BYTE;
            }
            if (message instanceof MapMessage) {
                return MessageTypeEnum.MAP;
            }
        }
        return null;
    }
}

