/*
 * Decompiled with CFR 0.152.
 */
package net.relaysoft.robot.jms.client;

import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.jms.Destination;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import net.relaysoft.robot.jms.client.AbstractJMSClient;
import net.relaysoft.robot.jms.client.JMSClient;
import net.relaysoft.robot.jms.exceptions.ConversionException;
import net.relaysoft.robot.jms.utils.MessageContentUtils;
import net.relaysoft.robot.jms.utils.MessageTypeEnum;
import net.relaysoft.robot.jms.utils.StringUtils;

public abstract class AbstractJMS20Client
extends AbstractJMSClient
implements JMSClient {
    private JMSContext context = null;
    private Map<String, JMSConsumer> subscriptions = new HashMap<String, JMSConsumer>();
    protected Map<String, JMSConsumer> temporaryConsumers = new HashMap<String, JMSConsumer>();

    public AbstractJMS20Client(String clientID) {
        super(clientID);
    }

    @Override
    public synchronized void closeConnection() throws JMSException {
        if (this.isConnected()) {
            this.unsubscribeAllTopics();
            this.context.close();
            this.temporaryConsumers.clear();
            super.closeConnection();
        }
    }

    @Override
    public String createTemporaryQueue() throws JMSException {
        TemporaryQueue queue = this.context.createTemporaryQueue();
        this.temporaryDestinations.put(queue.getQueueName(), queue);
        return queue.getQueueName();
    }

    @Override
    public String createTemporaryTopic() throws JMSException {
        TemporaryTopic topic = this.context.createTemporaryTopic();
        this.temporaryConsumers.put(topic.getTopicName(), this.context.createConsumer((Destination)topic));
        this.temporaryDestinations.put(topic.getTopicName(), topic);
        return topic.getTopicName();
    }

    @Override
    public void deleteTemporaryQueue(String queueName) throws JMSException {
        if (this.temporaryDestinations.containsKey(queueName)) {
            TemporaryQueue queue = (TemporaryQueue)this.temporaryDestinations.remove(queueName);
            if (this.temporaryConsumers.containsKey(queueName)) {
                this.temporaryConsumers.remove(queueName).close();
            }
            queue.delete();
        }
    }

    @Override
    public void deleteTemporaryTopic(String queueName) throws JMSException {
        if (this.temporaryDestinations.containsKey(queueName)) {
            TemporaryTopic topic = (TemporaryTopic)this.temporaryDestinations.remove(queueName);
            if (this.temporaryConsumers.containsKey(queueName)) {
                this.temporaryConsumers.remove(queueName).close();
            }
            topic.delete();
        }
    }

    @Override
    public byte[] getMessageByteContent(String messageID) throws JMSException {
        Message message = this.getMessage(messageID);
        MessageTypeEnum type = this.resolveMessageType(message);
        if (type.equals((Object)MessageTypeEnum.BYTE)) {
            return (byte[])message.getBody(byte[].class);
        }
        if (type.equals((Object)MessageTypeEnum.TEXT)) {
            return ((String)message.getBody(String.class)).getBytes(StandardCharsets.UTF_8);
        }
        if (type.equals((Object)MessageTypeEnum.MAP)) {
            MessageContentUtils.convertMapToByteArray((Map)message.getBody(Map.class));
        }
        throw new IllegalArgumentException("Invalid JMS message type ".concat(message.getClass().getName()));
    }

    @Override
    public Map<String, Object> getMessageMapContent(String messageID) throws JMSException {
        Message message = this.getMessage(messageID);
        MessageTypeEnum type = this.resolveMessageType(message);
        if (type.equals((Object)MessageTypeEnum.MAP)) {
            return (Map)message.getBody(Map.class);
        }
        if (type.equals((Object)MessageTypeEnum.BYTE)) {
            return MessageContentUtils.convertByteArrayToMap((byte[])message.getBody(byte[].class));
        }
        if (type.equals((Object)MessageTypeEnum.TEXT)) {
            throw new ConversionException("Cannot convert JMS text message content into map.");
        }
        throw new IllegalArgumentException("Invalid JMS message type ".concat(message.getClass().getName()));
    }

    @Override
    public String getMessageCorrelationID(String messageID) throws JMSException {
        return this.getMessage(messageID).getJMSCorrelationID();
    }

    @Override
    public String getMessageDestinationName(String messageID) throws JMSException {
        Destination destination = this.getMessage(messageID).getJMSDestination();
        if (destination instanceof Queue) {
            return ((Queue)destination).getQueueName();
        }
        return ((Topic)destination).getTopicName();
    }

    @Override
    public long getMessageExpirationTime(String messageID) throws JMSException {
        return this.getMessage(messageID).getJMSExpiration();
    }

    @Override
    public String getMessageID(String messageID) throws JMSException {
        return this.getMessage(messageID).getJMSMessageID();
    }

    @Override
    public int getMessagePriority(String messageID) throws JMSException {
        return this.getMessage(messageID).getJMSPriority();
    }

    @Override
    public Object getMessageProperty(String propertyName, String messageID) throws JMSException {
        return this.getMessage(messageID).getObjectProperty(propertyName);
    }

    @Override
    public String getMessageReplyToQueue(String messageID) throws JMSException {
        Destination destination = this.getMessage(messageID).getJMSReplyTo();
        if (destination instanceof Queue) {
            return ((Queue)destination).getQueueName();
        }
        return ((Topic)destination).getTopicName();
    }

    @Override
    public String getMessageTextContent(String messageID) throws JMSException {
        Message message = this.getMessage(messageID);
        MessageTypeEnum type = this.resolveMessageType(message);
        if (type.equals((Object)MessageTypeEnum.TEXT)) {
            return (String)message.getBody(String.class);
        }
        if (type.equals((Object)MessageTypeEnum.BYTE)) {
            return new String((byte[])message.getBody(byte[].class), StandardCharsets.UTF_8);
        }
        if (type.equals((Object)MessageTypeEnum.MAP)) {
            ((Map)message.getBody(Map.class)).toString();
        }
        throw new IllegalArgumentException("Invalid JMS message type ".concat(message.getClass().getName()));
    }

    @Override
    public long getMessageTimestamp(String messageID) throws JMSException {
        return this.getMessage(messageID).getJMSTimestamp();
    }

    @Override
    public String getMessageType(String messageID) throws JMSException {
        return this.getMessage(messageID).getJMSType();
    }

    @Override
    public int getQueueDepth(String queueName) throws JMSException {
        int depth = 0;
        try (QueueBrowser browser = this.context.createBrowser(this.createQueue(queueName));){
            Enumeration e = browser.getEnumeration();
            while (e.hasMoreElements()) {
                e.nextElement();
                ++depth;
            }
        }
        return depth;
    }

    @Override
    public void initializeClient(Map<String, Object> parameters) throws Exception {
        this.factory = this.createConnectionFactory(parameters);
    }

    @Override
    public synchronized void openConnection() throws JMSException {
        this.openConnection(null, null);
    }

    @Override
    public synchronized void openConnection(String userName, String password) throws JMSException {
        if (!this.isConnected()) {
            this.context = this.createContext(this.getClientID(), userName, password);
            this.context.start();
            super.openConnection();
        }
    }

    @Override
    public String peekFromQueue(String queueName, String messageSelector) throws JMSException {
        try (QueueBrowser browser = this.context.createBrowser(this.createQueue(queueName), messageSelector);){
            Enumeration e = browser.getEnumeration();
            if (e.hasMoreElements()) {
                Message message = (Message)e.nextElement();
                this.addMessage(message);
                String string = message.getJMSMessageID();
                return string;
            }
        }
        return null;
    }

    @Override
    public void publishIntoTopic(String topicName, String content, Map<String, Object> parameters, Map<String, Object> properties) {
        JMSProducer producer = this.createProducer(parameters, properties);
        producer.send((Destination)this.createTopic(topicName), content);
    }

    @Override
    public void publishIntoTopic(String topicName, byte[] content, Map<String, Object> parameters, Map<String, Object> properties) {
        JMSProducer producer = this.createProducer(parameters, properties);
        producer.send((Destination)this.createTopic(topicName), content);
    }

    @Override
    public void publishIntoTopic(String topicName, Map<String, Object> content, Map<String, Object> parameters, Map<String, Object> properties) {
        JMSProducer producer = this.createProducer(parameters, properties);
        producer.send((Destination)this.createTopic(topicName), content);
    }

    @Override
    public void purgeQueue(String queueName) throws JMSException {
        int queueDepth = this.getQueueDepth(queueName);
        for (int i = 0; i < queueDepth; ++i) {
            try (JMSConsumer consumer = this.context.createConsumer((Destination)this.createQueue(queueName));){
                consumer.receive(1000L);
                continue;
            }
        }
    }

    @Override
    public String readFromQueue(String queueName, long timeout, String messageSelector) throws JMSException {
        if (this.temporaryDestinations.containsKey(queueName)) {
            return this.addMessage(this.readFromQueue((Queue)this.temporaryDestinations.get(queueName), timeout, messageSelector));
        }
        return this.addMessage(this.readFromQueue(this.createQueue(queueName), timeout, messageSelector));
    }

    @Override
    public String readFromTopic(String name, long timeout) throws JMSException {
        if (this.subscriptions.containsKey(name)) {
            return this.addMessage(this.subscriptions.get(name).receive(timeout));
        }
        if (this.temporaryDestinations.containsKey(name)) {
            return this.addMessage(this.temporaryConsumers.get(name).receive(timeout));
        }
        throw new JMSException("No active subscription or temporary topic with name " + name);
    }

    @Override
    public void subscribeTopic(String topicName, String name, String messageSelector) throws JMSException {
        this.subscriptions.put(name, this.context.createDurableConsumer(this.createTopic(topicName), name, messageSelector, false));
    }

    @Override
    public void unsubscribeTopic(String name) {
        if (this.subscriptions.containsKey(name)) {
            JMSConsumer consumer = this.subscriptions.remove(name);
            consumer.close();
            this.context.unsubscribe(name);
        }
    }

    @Override
    public void writeIntoQueue(String queueName, String content, Map<String, Object> parameters, Map<String, Object> properties) {
        JMSProducer producer = this.createProducer(parameters, properties);
        producer.send((Destination)this.createQueue(queueName), content);
    }

    @Override
    public void writeIntoQueue(String queueName, byte[] content, Map<String, Object> parameters, Map<String, Object> properties) {
        JMSProducer producer = this.createProducer(parameters, properties);
        producer.send((Destination)this.createQueue(queueName), content);
    }

    @Override
    public void writeIntoQueue(String queueName, Map<String, Object> content, Map<String, Object> parameters, Map<String, Object> properties) {
        JMSProducer producer = this.createProducer(parameters, properties);
        producer.send((Destination)this.createQueue(queueName), content);
    }

    private JMSContext createContext(String clientID, String userName, String password) {
        JMSContext newContext = this.factory.createContext(userName, password);
        newContext.setClientID(clientID);
        return newContext;
    }

    private Queue createQueue(String queueName) {
        return this.context.createQueue(queueName);
    }

    private JMSProducer createProducer(Map<String, Object> headers, Map<String, Object> properties) {
        JMSProducer producer = this.context.createProducer();
        this.setProducerParameters(producer, headers);
        this.setProperties(producer, properties);
        return producer;
    }

    private Topic createTopic(String topicName) {
        return this.context.createTopic(topicName);
    }

    private Message readFromQueue(Queue queue, long timeout, String messageSelector) {
        try (JMSConsumer consumer = this.context.createConsumer((Destination)queue, messageSelector);){
            Message message = consumer.receive(timeout);
            return message;
        }
    }

    private void setProducerParameter(JMSProducer producer, String type, Object value) {
        if (StringUtils.isNotBlank(type) && value != null) {
            if (type.equals("priority")) {
                producer.setPriority(((Integer)value).intValue());
            } else if (type.equals("timeToLive")) {
                producer.setTimeToLive(((Long)value).longValue());
            } else if (type.equals("deliveryDelay")) {
                producer.setDeliveryDelay(((Long)value).longValue());
            } else if (type.equals("deliveryMode")) {
                producer.setDeliveryMode(((Integer)value).intValue());
            } else if (type.equals("correlationId")) {
                producer.setJMSCorrelationID((String)value);
            } else if (type.equals("replyTo")) {
                producer.setJMSReplyTo((Destination)this.createQueue((String)value));
            } else if (type.equals("type")) {
                producer.setJMSType((String)value);
            }
        }
    }

    private void setProducerParameters(JMSProducer producer, Map<String, Object> parameters) {
        if (parameters != null) {
            parameters.entrySet().stream().forEach(e -> this.setProducerParameter(producer, (String)e.getKey(), e.getValue()));
        }
    }

    private void setProperty(JMSProducer producer, String name, Object value) {
        if (StringUtils.isNotBlank(name) && value != null) {
            producer.setProperty(name, value);
        }
    }

    private void setProperties(JMSProducer producer, Map<String, Object> properties) {
        if (properties != null) {
            properties.entrySet().stream().forEach(e -> this.setProperty(producer, (String)e.getKey(), e.getValue()));
        }
    }

    private void unsubscribeAllTopics() {
        this.subscriptions.keySet().stream().collect(Collectors.toList()).forEach(this::unsubscribeTopic);
    }
}

