/*
 * Decompiled with CFR 0.152.
 */
package net.relaysoft.robot.jms.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import net.relaysoft.robot.jms.client.AbstractJMSClient;
import net.relaysoft.robot.jms.client.JMSClient;
import net.relaysoft.robot.jms.exceptions.ConversionException;
import net.relaysoft.robot.jms.exceptions.JMSClientException;
import net.relaysoft.robot.jms.utils.MessageContentUtils;
import net.relaysoft.robot.jms.utils.MessageTypeEnum;
import net.relaysoft.robot.jms.utils.PrintUtil;
import net.relaysoft.robot.jms.utils.StringUtils;

public abstract class AbstractJMS11Client
extends AbstractJMSClient
implements JMSClient {
    private static final int DEFAULT_BUFFER = 1024;
    private Connection connection = null;
    private Session session = null;
    private Map<String, TopicSubscriber> subscriptions = new HashMap<String, TopicSubscriber>();
    private Map<String, MessageConsumer> temporaryConsumers = new HashMap<String, MessageConsumer>();

    public AbstractJMS11Client(String clientID) {
        super(clientID);
    }

    @Override
    public synchronized void closeConnection() throws JMSException {
        if (this.isConnected()) {
            this.unsubscribeAllTopics();
            this.connection.close();
            this.temporaryConsumers.clear();
            super.closeConnection();
        }
    }

    @Override
    public String createTemporaryQueue() throws JMSException {
        TemporaryQueue queue = this.session.createTemporaryQueue();
        this.temporaryDestinations.put(queue.getQueueName(), queue);
        return queue.getQueueName();
    }

    @Override
    public String createTemporaryTopic() throws JMSException {
        TemporaryTopic topic = this.session.createTemporaryTopic();
        this.temporaryConsumers.put(topic.getTopicName(), this.createMessageConsumer((Destination)topic, null));
        this.temporaryDestinations.put(topic.getTopicName(), topic);
        return topic.getTopicName();
    }

    @Override
    public void deleteTemporaryQueue(String queueName) throws JMSException {
        if (this.temporaryDestinations.containsKey(queueName)) {
            TemporaryQueue queue = (TemporaryQueue)this.temporaryDestinations.remove(queueName);
            if (this.temporaryConsumers.containsKey(queueName)) {
                this.temporaryConsumers.remove(queueName).close();
            }
            queue.delete();
        }
    }

    @Override
    public void deleteTemporaryTopic(String queueName) throws JMSException {
        if (this.temporaryDestinations.containsKey(queueName)) {
            TemporaryTopic topic = (TemporaryTopic)this.temporaryDestinations.remove(queueName);
            if (this.temporaryConsumers.containsKey(queueName)) {
                this.temporaryConsumers.remove(queueName).close();
            }
            topic.delete();
        }
    }

    @Override
    public byte[] getMessageByteContent(String messageID) throws JMSException {
        Message message = this.getMessage(messageID);
        MessageTypeEnum type = this.resolveMessageType(message);
        if (type.equals((Object)MessageTypeEnum.BYTE)) {
            return this.readBytes(message);
        }
        if (type.equals((Object)MessageTypeEnum.TEXT)) {
            return this.readText(message).getBytes(StandardCharsets.UTF_8);
        }
        if (type.equals((Object)MessageTypeEnum.MAP)) {
            return MessageContentUtils.convertMapToByteArray(this.readMap(message));
        }
        throw new IllegalArgumentException("Invalid JMS message type ".concat(message.getClass().getName()));
    }

    @Override
    public Map<String, Object> getMessageMapContent(String messageID) throws JMSException {
        Message message = this.getMessage(messageID);
        MessageTypeEnum type = this.resolveMessageType(message);
        if (type.equals((Object)MessageTypeEnum.MAP)) {
            return this.readMap(message);
        }
        if (type.equals((Object)MessageTypeEnum.BYTE)) {
            return MessageContentUtils.convertByteArrayToMap(this.readBytes(message));
        }
        if (type.equals((Object)MessageTypeEnum.TEXT)) {
            throw new ConversionException("Cannot convert JMS text message content into map.");
        }
        throw new IllegalArgumentException("Invalid JMS message type ".concat(message.getClass().getName()));
    }

    @Override
    public String getMessageCorrelationID(String messageID) throws JMSException {
        return this.getMessage(messageID).getJMSCorrelationID();
    }

    @Override
    public String getMessageDestinationName(String messageID) throws JMSException {
        Destination destination = this.getMessage(messageID).getJMSDestination();
        if (destination instanceof Queue) {
            return ((Queue)destination).getQueueName();
        }
        return ((Topic)destination).getTopicName();
    }

    @Override
    public long getMessageExpirationTime(String messageID) throws JMSException {
        return this.getMessage(messageID).getJMSExpiration();
    }

    @Override
    public String getMessageID(String messageID) throws JMSException {
        return this.getMessage(messageID).getJMSMessageID();
    }

    @Override
    public int getMessagePriority(String messageID) throws JMSException {
        return this.getMessage(messageID).getJMSPriority();
    }

    @Override
    public Object getMessageProperty(String propertyName, String messageID) throws JMSException {
        return this.getMessage(messageID).getObjectProperty(propertyName);
    }

    @Override
    public String getMessageReplyToQueue(String messageID) throws JMSException {
        Destination destination = this.getMessage(messageID).getJMSReplyTo();
        if (destination instanceof Queue) {
            return ((Queue)destination).getQueueName();
        }
        return ((Topic)destination).getTopicName();
    }

    @Override
    public String getMessageTextContent(String messageID) throws JMSException {
        Message message = this.getMessage(messageID);
        MessageTypeEnum type = this.resolveMessageType(message);
        if (type.equals((Object)MessageTypeEnum.TEXT)) {
            return this.readText(message);
        }
        if (type.equals((Object)MessageTypeEnum.BYTE)) {
            return new String(this.readBytes(message), StandardCharsets.UTF_8);
        }
        if (type.equals((Object)MessageTypeEnum.MAP)) {
            return this.readMap(message).toString();
        }
        throw new IllegalArgumentException("Invalid JMS message type ".concat(message.getClass().getName()));
    }

    @Override
    public long getMessageTimestamp(String messageID) throws JMSException {
        return this.getMessage(messageID).getJMSTimestamp();
    }

    @Override
    public String getMessageType(String messageID) throws JMSException {
        return this.getMessage(messageID).getJMSType();
    }

    @Override
    public int getQueueDepth(String queueName) throws JMSException {
        int depth = 0;
        try (QueueBrowser browser = this.createBrowser(queueName, null);){
            Enumeration e = browser.getEnumeration();
            while (e.hasMoreElements()) {
                e.nextElement();
                ++depth;
            }
        }
        return depth;
    }

    @Override
    public void initializeClient(Map<String, Object> parameters) throws Exception {
        this.factory = this.createConnectionFactory(parameters);
    }

    @Override
    public synchronized void openConnection() throws JMSException {
        this.openConnection(null, null);
    }

    @Override
    public synchronized void openConnection(String userName, String password) throws JMSException {
        if (!this.isConnected()) {
            this.connection = this.createConnection(this.getClientID(), userName, password);
            this.session = this.connection.createSession(false, 1);
            this.connection.start();
            super.openConnection();
        }
    }

    @Override
    public String peekFromQueue(String queueName, String messageSelector) throws JMSException {
        try (QueueBrowser browser = this.createBrowser(queueName, messageSelector);){
            Enumeration e = browser.getEnumeration();
            if (e.hasMoreElements()) {
                Message message = (Message)e.nextElement();
                this.addMessage(message);
                String string = message.getJMSMessageID();
                return string;
            }
        }
        return null;
    }

    @Override
    public void publishIntoTopic(String topicName, String content, Map<String, Object> parameters, Map<String, Object> properties) throws JMSException {
        this.publishIntoTopic(topicName, this.createMessage(content, parameters, properties), parameters);
    }

    @Override
    public void publishIntoTopic(String topicName, byte[] content, Map<String, Object> parameters, Map<String, Object> properties) throws JMSException {
        this.publishIntoTopic(topicName, this.createMessage(content, parameters, properties), parameters);
    }

    @Override
    public void publishIntoTopic(String topicName, Map<String, Object> content, Map<String, Object> parameters, Map<String, Object> properties) throws JMSException {
        this.publishIntoTopic(topicName, this.createMessage(content, parameters, properties), parameters);
    }

    @Override
    public void purgeQueue(String queueName) throws JMSException {
        int queueDepth = this.getQueueDepth(queueName);
        for (int i = 0; i < queueDepth; ++i) {
            try (MessageConsumer consumer = this.session.createConsumer((Destination)this.createQueue(queueName));){
                consumer.receive(1000L);
                continue;
            }
        }
    }

    @Override
    public String readFromQueue(String queueName, long timeout, String messageSelector) throws JMSException {
        if (this.temporaryDestinations.containsKey(queueName)) {
            try (MessageConsumer consumer = this.createMessageConsumer((Destination)((Queue)this.temporaryDestinations.get(queueName)), messageSelector);){
                String string = this.addMessage(consumer.receive(timeout));
                return string;
            }
        }
        try (MessageConsumer consumer = this.createMessageConsumer((Destination)this.createQueue(queueName), messageSelector);){
            String string = this.addMessage(consumer.receive(timeout));
            return string;
        }
    }

    @Override
    public String readFromTopic(String name, long timeout) throws JMSException {
        if (this.subscriptions.containsKey(name)) {
            return this.addMessage(this.subscriptions.get(name).receive(timeout));
        }
        if (this.temporaryDestinations.containsKey(name)) {
            return this.addMessage(this.temporaryConsumers.get(name).receive(timeout));
        }
        throw new JMSException("No active subscription or temporary topic with name " + name);
    }

    @Override
    public void subscribeTopic(String topicName, String name, String messageSelector) throws JMSException {
        this.subscriptions.put(name, this.session.createDurableSubscriber(this.createTopic(topicName), name, messageSelector, false));
    }

    @Override
    public void unsubscribeTopic(String name) throws JMSException {
        if (this.subscriptions.containsKey(name)) {
            TopicSubscriber subscriber = this.subscriptions.remove(name);
            subscriber.close();
            this.session.unsubscribe(name);
        }
    }

    @Override
    public void writeIntoQueue(String queueName, String content, Map<String, Object> parameters, Map<String, Object> properties) throws JMSException {
        this.writeIntoQueue(queueName, this.createMessage(content, parameters, properties), parameters);
    }

    @Override
    public void writeIntoQueue(String queueName, byte[] content, Map<String, Object> parameters, Map<String, Object> properties) throws JMSException {
        this.writeIntoQueue(queueName, this.createMessage(content, parameters, properties), parameters);
    }

    @Override
    public void writeIntoQueue(String queueName, Map<String, Object> content, Map<String, Object> parameters, Map<String, Object> properties) throws JMSException {
        this.writeIntoQueue(queueName, this.createMessage(content, parameters, properties), parameters);
    }

    private long convertValueToLong(Object value) {
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        return (Long)value;
    }

    private QueueBrowser createBrowser(String queueName, String messageSelector) throws JMSException {
        return this.session.createBrowser(this.createQueue(queueName), messageSelector);
    }

    private Message createBytesMessage(InputStream is) throws JMSException {
        byte[] buffer = new byte[1024];
        BytesMessage message = this.session.createBytesMessage();
        int bytes = 0;
        try {
            while ((bytes = is.read(buffer)) > -1) {
                message.writeBytes(buffer, 0, bytes);
            }
        }
        catch (IOException e) {
            PrintUtil.printOut("Failed to read bytes from inputstream. " + e.getMessage());
            throw new JMSException("Failed to create JMS bytes message.");
        }
        return message;
    }

    private Connection createConnection(String clientID, String userName, String password) throws JMSException {
        Connection newConnection = this.factory.createConnection(userName, password);
        newConnection.setClientID(clientID);
        return newConnection;
    }

    private MessageConsumer createMessageConsumer(Destination destination, String messageSelector) throws JMSException {
        return this.session.createConsumer(destination, messageSelector);
    }

    private MapMessage createMapMessage(Map<String, Object> map) throws JMSException {
        MapMessage message = this.session.createMapMessage();
        map.entrySet().stream().forEach(entry -> {
            try {
                message.setObject((String)entry.getKey(), entry.getValue());
            }
            catch (JMSException e) {
                PrintUtil.printOut("Failed to set new object " + (String)entry.getKey() + " into JMS map message. " + e.getMessage());
                throw new JMSClientException("Failed to create JMS map message.", e);
            }
        });
        return message;
    }

    private Message createMessage(Object content, Map<String, Object> parameters, Map<String, Object> properties) throws JMSException {
        Message message = this.createMessage(content);
        this.setProperties(message, properties);
        this.setMessageParameters(message, parameters);
        return message;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Message createMessage(Object content) throws JMSException {
        if (content instanceof String) {
            return this.session.createTextMessage((String)content);
        }
        if (!(content instanceof byte[])) {
            if (!(content instanceof Map)) return this.session.createTextMessage(null);
            return this.createMapMessage((Map)content);
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream((byte[])content);){
            Message message = this.createBytesMessage(is);
            return message;
        }
        catch (IOException e) {
            PrintUtil.printOut("Failed to automatically close inputstream after reading. " + e.getMessage());
            return this.session.createTextMessage(null);
        }
    }

    private MessageProducer createProducer(Destination destination) throws JMSException {
        return this.session.createProducer(destination);
    }

    private Queue createQueue(String queueName) throws JMSException {
        return this.session.createQueue(queueName);
    }

    private Topic createTopic(String topicName) throws JMSException {
        return this.session.createTopic(topicName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishIntoTopic(String topicName, Message message, Map<String, Object> parameters) throws JMSException {
        try (MessageProducer producer = null;){
            producer = this.createProducer((Destination)this.createTopic(topicName));
            this.setProducerParameters(producer, parameters);
            producer.send(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readBytes(Message message) throws JMSException {
        BytesMessage bytesMessage = (BytesMessage)message;
        byte[] bytes = new byte[1024];
        byte[] content = null;
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            int c = 0;
            while ((c = bytesMessage.readBytes(bytes, 1024)) > 0) {
                os.write(bytes, 0, c);
            }
            content = os.toByteArray();
        }
        catch (IOException e) {
            PrintUtil.printOut("Failed to close output stream. " + e.getMessage());
        }
        finally {
            bytesMessage.reset();
        }
        return content;
    }

    private Map<String, Object> readMap(Message message) throws JMSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        MapMessage mapMessage = (MapMessage)message;
        Enumeration names = mapMessage.getMapNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object value = mapMessage.getObject(name);
            map.put(name, value);
        }
        return map;
    }

    private String readText(Message message) throws JMSException {
        MessageTypeEnum type = this.resolveMessageType(message);
        if (type.equals((Object)MessageTypeEnum.BYTE)) {
            return new String(this.readBytes(message), StandardCharsets.UTF_8);
        }
        if (type.equals((Object)MessageTypeEnum.MAP)) {
            return this.readMap(message).toString();
        }
        return ((TextMessage)message).getText();
    }

    private void setMessageParameter(Message message, String type, Object value) throws JMSException {
        if (StringUtils.isNotBlank(type) && value != null) {
            if (type.equals("replyTo")) {
                message.setJMSReplyTo((Destination)this.createQueue((String)value));
            } else if (type.equals("correlationId")) {
                message.setJMSCorrelationID((String)value);
            } else if (type.equals("type")) {
                message.setJMSType((String)value);
            }
        }
    }

    private void setMessageParameters(Message message, Map<String, Object> parameters) {
        if (parameters != null) {
            parameters.entrySet().stream().forEach(e -> {
                try {
                    this.setMessageParameter(message, (String)e.getKey(), e.getValue());
                }
                catch (JMSException e1) {
                    PrintUtil.printOut("Failed to set parameter " + (String)e.getKey() + " into JMS message. " + e1.getMessage());
                    throw new JMSClientException("Failed to set message parameters", e1);
                }
            });
        }
    }

    private void setProducerParameter(MessageProducer producer, String type, Object value) throws JMSException {
        if (StringUtils.isNotBlank(type) && value != null) {
            if (type.equals("priority")) {
                producer.setPriority(((Integer)value).intValue());
            } else if (type.equals("timeToLive")) {
                producer.setTimeToLive(this.convertValueToLong(value));
            } else if (type.equals("deliveryDelay")) {
                producer.setDeliveryDelay(this.convertValueToLong(value));
            } else if (type.equals("deliveryMode")) {
                producer.setDeliveryMode(((Integer)value).intValue());
            }
        }
    }

    private void setProducerParameters(MessageProducer producer, Map<String, Object> parameters) {
        if (parameters != null) {
            parameters.entrySet().stream().forEach(e -> {
                try {
                    this.setProducerParameter(producer, (String)e.getKey(), e.getValue());
                }
                catch (JMSException e1) {
                    PrintUtil.printOut("Failed to set parameter " + (String)e.getKey() + " into JMS producer. " + e1.getMessage());
                    throw new JMSClientException("Failed to set producer parameters.", e1);
                }
            });
        }
    }

    private void setProperty(Message message, String name, Object value) throws JMSException {
        if (StringUtils.isNotBlank(name) && value != null) {
            message.setObjectProperty(name, value);
        }
    }

    private void setProperties(Message message, Map<String, Object> properties) {
        if (properties != null) {
            properties.entrySet().stream().forEach(e -> {
                try {
                    this.setProperty(message, (String)e.getKey(), e.getValue());
                }
                catch (JMSException e1) {
                    PrintUtil.printOut("Failed to set property " + (String)e.getKey() + " into JMS message. " + e1.getMessage());
                    throw new JMSClientException("Failed to set message properties.", e1);
                }
            });
        }
    }

    private void unsubscribeAllTopics() {
        List<String> names = this.subscriptions.keySet().stream().collect(Collectors.toList());
        names.forEach(n -> {
            try {
                this.unsubscribeTopic((String)n);
            }
            catch (JMSException e) {
                PrintUtil.printOut("Failed to unsubscribe topic subscription " + n);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIntoQueue(String queueName, Message message, Map<String, Object> parameters) throws JMSException {
        try (MessageProducer producer = null;){
            producer = this.createProducer((Destination)this.createQueue(queueName));
            this.setProducerParameters(producer, parameters);
            producer.send(message);
        }
    }
}

