/*
 * Decompiled with CFR 0.152.
 */
package net.relaysoft.robot.http.server.utils;

public final class StringUtils {
    private StringUtils() {
    }

    public static boolean isBlank(String string) {
        return string == null || string.trim().isEmpty();
    }

    public static boolean isNotBlank(String string) {
        return string != null && !string.trim().isEmpty();
    }

    public static boolean isNumeric(String string) {
        return string.matches("-?\\d+(\\.\\d+)?");
    }

    public static String substringAfter(String str, String after) {
        if (StringUtils.isBlank(str)) {
            return str;
        }
        if (after == null) {
            return "";
        }
        int position = str.indexOf(after);
        if (position == -1) {
            return "";
        }
        return str.substring(position + after.length());
    }

    public static String substringBetween(String str, String after, String before) {
        if (StringUtils.isBlank(str)) {
            return str;
        }
        if (after == null || before == null) {
            return "";
        }
        int afterPosition = str.indexOf(after);
        int beforePosition = str.indexOf(before, afterPosition + 1);
        if (afterPosition == -1 || beforePosition == -1) {
            return "";
        }
        return str.substring(afterPosition + 1, beforePosition);
    }
}

