/*
 * Decompiled with CFR 0.152.
 */
package net.relaysoft.robot.http.server.utils;

import java.util.HashMap;
import java.util.Map;
import net.relaysoft.robot.http.server.utils.StringUtils;

public final class RobotUtils {
    private RobotUtils() {
    }

    public static <T> T getParameterValue(String[] params, int index, T defaultValue) {
        Object resultValue = null;
        String value = null;
        if (params.length > index) {
            value = params[index];
        }
        if (StringUtils.isNotBlank(value) && !"None".equals(value)) {
            if (RobotUtils.isDictionary(value)) {
                resultValue = RobotUtils.parseDictionary(value);
            } else if (StringUtils.isNumeric(value)) {
                resultValue = new Integer(value);
            } else if (defaultValue == null || defaultValue instanceof String) {
                resultValue = value;
            }
        }
        return (T)(resultValue != null ? resultValue : (Object)defaultValue);
    }

    public static boolean isDictionary(String string) {
        boolean result = false;
        if (string != null && !string.isEmpty() && string.trim().startsWith("{") && string.trim().endsWith("}")) {
            String[] pairs;
            String subString = StringUtils.substringBetween(string, "{", "}");
            for (String pair : pairs = subString.split(",")) {
                String[] values = pair.split(":");
                if (!(values.length == 2 && values[0].trim().startsWith("u'") && values[0].trim().endsWith("'") && values[1].trim().startsWith("u'") && values[1].trim().endsWith("'"))) {
                    return false;
                }
                result = true;
            }
        }
        return result;
    }

    public static Map<String, String> parseDictionary(String string) {
        String[] pairs;
        HashMap<String, String> map = new HashMap<String, String>();
        String subString = StringUtils.substringBetween(string, "{", "}");
        for (String pair : pairs = subString.split(",")) {
            String[] values = pair.split(":");
            map.put(StringUtils.substringBetween(values[0].trim(), "'", "'"), StringUtils.substringBetween(values[1].trim(), "'", "'"));
        }
        return map;
    }
}

