/*
 * Decompiled with CFR 0.152.
 */
package net.relaysoft.robot.http.server.utils;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import net.relaysoft.robot.http.server.utils.StringUtils;

public final class HTTPUtils {
    protected static final String HEADER_AUTHORIZATION = "Authorization";

    private HTTPUtils() {
    }

    public static Map<String, String> convertQueryStringIntoMap(String queryString) {
        Map<String, String> result = new HashMap<String, String>();
        if (StringUtils.isNotBlank(queryString)) {
            result = Arrays.asList(queryString.split("&")).stream().map(s -> s.split("=")).collect(Collectors.toMap(e -> e[0], e -> e[1]));
        }
        return result;
    }

    public static String getAuthType(HttpServletRequest httpServletRequest) {
        String authType = httpServletRequest.getAuthType();
        if (authType == null) {
            String header = httpServletRequest.getHeader(HEADER_AUTHORIZATION);
            authType = header != null ? header.split(" ")[0] : null;
        }
        return authType;
    }

    public static String getCharsetFromContentType(String contentType) {
        return contentType != null && contentType.contains("charset=") ? StringUtils.substringAfter(contentType, "charset=") : StandardCharsets.UTF_8.toString();
    }
}

