/*
 * Decompiled with CFR 0.152.
 */
package net.relaysoft.robot.http.server.keywords;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.relaysoft.robot.http.server.MockServer;
import net.relaysoft.robot.http.server.MockServerFactory;
import net.relaysoft.robot.http.server.RequestDataHolder;
import net.relaysoft.robot.http.server.utils.PrintUtil;
import net.relaysoft.robot.http.server.utils.RobotUtils;
import net.relaysoft.robot.http.server.utils.StringUtils;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywordOverload;
import org.robotframework.javalib.annotation.RobotKeywords;

@RobotKeywords
public class HTTPServerKeywords {
    private static final String DEFAULT_REST_METHOD = "GET";
    private static final String DEFAULT_SOAP_CONTENT_TYPE = "application/soap+xml";
    private static final int DEFAULT_STATUS_CODE = 200;
    private static final String NONE = "None";
    private static final String PARAM_CODE = "statusCode";
    private static final String PARAM_CONTENT = "content";
    private static final String PARAM_FILE = "filePath";
    private static final String PARAM_HEADERS = "headers";
    private static final String PARAM_PATH = "path";
    private static final String PARAM_TYPE = "contentType";
    private MockServer server;

    @RobotKeyword(value="Return request data holder from request made against HTTP server. Request data holder contain all recorded request information from single request. Following values can be retrieved from request data holder.\n_authType_, _body_, _encoding_, _contentType_, _method_, _path_, and _queryString_.\n\nArguments:\n- _requestNumber_: Sequence number of the request from which request body should be returned.If sequence number is not given then value is retrieved from latest request made against server.\n\nExamples:\n| Get HTTP Request | |\n| Get HTTP Request | ${2} |")
    @ArgumentNames(value={"requestNumber="})
    public RequestDataHolder getHTTPRequest(int requestNumber) {
        return this.server.getRequest(requestNumber);
    }

    @RobotKeywordOverload
    public RequestDataHolder getHTTPRequest() {
        return this.server.getRequest();
    }

    @RobotKeyword(value="Return request body from request made against HTTP server.\n\nArguments:\n- _requestNumber_: Sequence number of the request from which request body should be returned.If sequence number is not given then value is retrieved from latest request made against server.\n\nExamples:\n| Get HTTP Request Content | |\n| Get HTTP Request Content | ${2} |")
    @ArgumentNames(value={"requestNumber="})
    public String getHTTPRequestContent(int requestNumber) {
        return this.server.getRequestBody(requestNumber);
    }

    @RobotKeywordOverload
    public String getHTTPRequestContent() {
        return this.server.getRequestBody();
    }

    @RobotKeyword(value="Return single request header value from request made against HTTP server.\n\nArguments:\n- _name_: Header name which value should be returned.\n- _requestNumber_: Sequence number of the request from which header should be returned.If sequence number is not given then value is retrieved from latest request made against server.\n\nExamples:\n| Get HTTP Request Header | Content-Type |\n| Get HTTP Request Header | Content-Type | ${2} |")
    @ArgumentNames(value={"name", "requestNumber="})
    public String getHTTPRequestHeader(String name, int requestNumber) {
        return this.server.getRequestHeaders(requestNumber).get(name);
    }

    @RobotKeywordOverload
    public String getHTTPRequestHeader(String name) {
        return this.server.getRequestHeaders().get(name);
    }

    @RobotKeyword(value="Return all request headers as a dictionary from request made against HTTP server.\n\nArguments:\n- _requestNumber_: Sequence number of the request from which headers should be returned.If sequence number is not given then value is retrieved from latest request made against server.\n\nExamples:\n| Get HTTP Request Headers | |\n| Get HTTP Request Headers | ${2} |")
    @ArgumentNames(value={"requestNumber="})
    public Map<String, String> getHTTPRequestHeaders(int requestNumber) {
        return this.server.getRequestHeaders(requestNumber);
    }

    @RobotKeywordOverload
    public Map<String, String> getHTTPRequestHeaders() {
        return this.server.getRequestHeaders();
    }

    @RobotKeyword(value="Return request method from request made against HTTP server.\n\nArguments:\n- _requestNumber_: Sequence number of the request from which request method should be returned.If sequence number is not given then value is retrieved from latest request made against server.\n\nExamples:\n| Get HTTP Request Method | |\n| Get HTTP Request Method | ${2} |")
    @ArgumentNames(value={"requestNumber="})
    public String getHTTPRequestMethod(int requestNumber) {
        return this.server.getRequestMethod(requestNumber);
    }

    @RobotKeywordOverload
    public String getHTTPRequestMethod() {
        return this.server.getRequestMethod();
    }

    @RobotKeyword(value="Return request query string from request made against HTTP server.\n\nArguments:\n- _requestNumber_: Sequence number of the request from which request method should be returned.If sequence number is not given then value is retrieved from latest request made against server.\n\nExamples:\n| Get HTTP Request Query String | |\n| Get HTTP Request Query String | ${2} |")
    @ArgumentNames(value={"requestNumber="})
    public String getHTTPRequestQueryString(int requestNumber) {
        return this.server.getRequestQueryString(requestNumber);
    }

    @RobotKeywordOverload
    public String getHTTPRequestQueryString() {
        return this.server.getRequestQueryString();
    }

    @RobotKeyword(value="Return port number which HTTP server is listening.")
    public int getHTTPServerPort() {
        return this.server.getPort();
    }

    @RobotKeyword(value="Initializes HTTP server. This keyword must be executed before any others can be used.\n\nArguments:\n- _port_: Listening port number. If port value is not given then the first free port is dynamically selected. Dynamically selected port can be queried with `Get HTTP Server Port` keyword.\n\nExamples:\n| Initialize HTTP Server | || Initialize HTTP Server | ${8888} |")
    @ArgumentNames(value={"port"})
    public void initializeHTTPServer(int port) throws IOException {
        this.server = MockServerFactory.getMockServer();
        this.server.initializeServer(port);
    }

    @RobotKeywordOverload
    public void initializeHTTPServer() throws IOException {
        this.initializeHTTPServer(0);
    }

    @RobotKeyword(value="Reset all recorded requests from HTTP server.")
    public void resetHTTPRequestContents() {
        this.server.resetRequestData();
    }

    @RobotKeyword(value="Reset all configured responses from HTTP server.")
    public void resetHTTPResponseContents() {
        this.server.resetResponseData();
    }

    @RobotKeyword(value="Set default HTTP response to return for the requests. This response default for all requests which does not have matching response defined by specified paths, methods, query strings, or SOAP actions.\n\nArguments:\n- _content_: Optional response body to return.\n- _statusCode_: HTTP response status code. Default value is 200.\n- _contentType_: Optional response content type. Default matches content type from the request.\n- _headers_: Optional custom HTTP headers to return with response. Given as dictionary.\n\nExamples:\n| Set Default Response | content=Hello | | | |\n| Set Default Response | content=Hello | statusCode=${201} | contentType=text/plain | |\n| Set Default Response | content=Hello | statusCode=${201} | contentType=text/plain | headers=&{header_dict} |")
    @ArgumentNames(value={"content=None", "statusCode=200", "contentType=None", "headers={}"})
    public void setDefaultResponse(String ... params) {
        String content = RobotUtils.getParameterValue(params, 0, null);
        int statusCode = RobotUtils.getParameterValue(params, 1, 200);
        String contentType = RobotUtils.getParameterValue(params, 2, null);
        Map headers = RobotUtils.getParameterValue(params, 3, new HashMap());
        PrintUtil.printOut("content=" + content + ", " + PARAM_CODE + "=" + statusCode + ", " + PARAM_TYPE + "=" + contentType + ", " + PARAM_HEADERS + "=" + headers);
        this.server.setDefaultResponse(content, contentType, statusCode, headers);
    }

    @RobotKeyword(value="Set default HTTP response to return for the requests. This response default for all requests which does not have matching response defined by specified paths, methods, query strings, or SOAP actions. Response content is taken fromfile content.\n\nArguments:\n- _filePath_: File path to response body content file.\n- _statusCode_: HTTP response status code. Default value is 200.\n- _contentType_: Optional response content type. Default matches content type from the request.\n- _headers_: Optional custom HTTP headers to return with response. Given as dictionary.\n\nExamples:\n| Set Default Response From File | /path/to/file | | | |\n| Set Default Response From File | filePath=/path/to/file | statusCode=${201} | contentType=text/plain | |\n| Set Default Response From File | filePath=/path/to/file | statusCode=${201} | contentType=text/plain | headers=&{header_dict} |")
    @ArgumentNames(value={"filePath", "statusCode=200", "contentType=None", "headers={}"})
    public void setDefaultResponseFromFile(String filePath, String ... params) {
        int statusCode = RobotUtils.getParameterValue(params, 0, 200);
        String contentType = RobotUtils.getParameterValue(params, 1, null);
        Map headers = RobotUtils.getParameterValue(params, 2, new HashMap());
        PrintUtil.printOut("filePath=" + filePath + ", " + PARAM_CODE + "=" + statusCode + ", " + PARAM_TYPE + "=" + contentType + ", " + PARAM_HEADERS + "=" + headers);
        this.server.setDefaultResponseFromFile(filePath, contentType, statusCode, headers);
    }

    @RobotKeyword(value="Set new response data to return for the REST requests. It is possible to set multiple different responses for different request paths, query parameters and SOAP actions.\n\nArguments:\n- _path_: Request path used to match for this response.\n- _method_: Request method used to match for this response. GET, POST, PUT, DELETE\n- _queryParameters_: Optional query paramters used to match for this response. Given as dictionary.\n- _content_: Optional response body to return.\n- _statusCode_: HTTP response status code. Default value is 200.\n- _contentType_: Optional response content type. Default matches content type from the request.\n- _headers_: Optional custom HTTP headers to return with response. Given as dictionary.\n\nExamples:\n| Set REST Response | path=/test | method=GET | content=Hello | | | | |\n| Set REST Response | path=/test | method=GET | queryParameters=&{param_dict} | content=Hello | | | |\n| Set REST Response | path=/test | method=GET | queryParameters=&{param_dict} | content=Hello | statusCode=${201} | contentType=text/plain | headers=&{header_dict} |")
    @ArgumentNames(value={"path", "method", "queryParameters={}", "content=None", "statusCode=200", "contentType=None", "headers={}"})
    public void setRESTResponse(String path, String method, String ... params) {
        Map queryParameters = RobotUtils.getParameterValue(params, 0, new HashMap());
        String content = RobotUtils.getParameterValue(params, 1, null);
        int statusCode = RobotUtils.getParameterValue(params, 2, 200);
        String contentType = RobotUtils.getParameterValue(params, 3, null);
        Map headers = RobotUtils.getParameterValue(params, 4, new HashMap());
        PrintUtil.printOut("path=" + this.resolvePath(path) + ", method=" + this.resolveMethod(method) + ", queryParameters=" + queryParameters + ", " + PARAM_CONTENT + "=" + content + ", " + PARAM_CODE + "=" + statusCode + ", " + PARAM_TYPE + "=" + contentType + ", " + PARAM_HEADERS + "=" + headers);
        this.server.setRestResponseData(this.resolvePath(path), this.resolveMethod(method), queryParameters, content, contentType, statusCode, headers);
    }

    @RobotKeyword(value="Set new response data to return for the REST requests. It is possible to set multiple different responses for different request paths, methods and query parameters. Response content is taken from file content.\n\nArguments:\n- _path_: Request path used to match for this response.\n- _method_: Request method used to match for this response. GET, POST, PUT, DELETE\n- _queryParameters_: Optional query paramters used to match for this response. Given as dictionary.\n- _filePath_: File path to response body content file.\n- _statusCode_: HTTP response status code. Default value is 200.\n- _contentType_: Optional response content type. Default matches content type from the request.\n- _headers_: Optional custom HTTP headers to return with response. Given as dictionary.\n\nExamples:\n| Set REST Response From File | path=/test | method=GET | filePath=/path/to/file | | | | |\n| Set REST Response From File | path=/test | method=GET | filePath=/path/to/file | queryParameters=&{param_dict} | | | |\n| Set REST Response From File | path=/test | method=GET | filePath=/path/to/file | queryParameters=&{param_dict} | statusCode=${201} | contentType=text/plain | headers=&{header_dict} |")
    @ArgumentNames(value={"path", "method", "filePath", "queryParameters={}", "statusCode=200", "contentType=None", "headers={}"})
    public void setRESTResponseFromFile(String path, String method, String filePath, String ... params) {
        Map queryParameters = RobotUtils.getParameterValue(params, 0, new HashMap());
        int statusCode = RobotUtils.getParameterValue(params, 1, 200);
        String contentType = RobotUtils.getParameterValue(params, 2, null);
        Map headers = RobotUtils.getParameterValue(params, 3, new HashMap());
        PrintUtil.printOut("path=" + this.resolvePath(path) + ", method=" + this.resolveMethod(method) + ", queryParameters=" + queryParameters + ", " + PARAM_FILE + "=" + filePath + ", " + PARAM_CODE + "=" + statusCode + ", " + PARAM_TYPE + "=" + contentType + ", " + PARAM_HEADERS + "=" + headers);
        this.server.setRestResponseDataFromFile(this.resolvePath(path), this.resolveMethod(method), queryParameters, filePath, contentType, statusCode, headers);
    }

    @RobotKeyword(value="Set new response data to return for the SOAP requests. It is possible to set multiple different responses for different request service paths and SOAP actions.\n\nArguments:\n- _path_: Request path used to match for this response.\n- _soapAction_: SOAP action used to match for this response.\n- _content_: Optional response body to return.\n- _statusCode_: HTTP response status code. Default value is 200.\n- _contentType_: Optional response content type. Default matches content type from the request.\n- _headers_: Optional custom HTTP headers to return with response. Given as dictionary.\n\nExamples:\n| Set SOAP Response | path=/testService | soapAction=testAction | content=${soap_xml} |\n| Set SOAP Response | path=/testService | soapAction=testAction | content=${soap_xml} | statusCode=${200} | contentType=text/plain | headers=&{header_dict} |")
    @ArgumentNames(value={"path", "soapAction", "content", "statusCode=200", "contentType=application/soap+xml", "headers={}"})
    public void setSOAPResponse(String path, String soapAction, String content, String ... params) {
        int statusCode = RobotUtils.getParameterValue(params, 0, 200);
        String contentType = RobotUtils.getParameterValue(params, 1, DEFAULT_SOAP_CONTENT_TYPE);
        Map headers = RobotUtils.getParameterValue(params, 2, new HashMap());
        PrintUtil.printOut("path=" + path + ", soapAction=" + soapAction + ", " + PARAM_CONTENT + "=" + content + ", " + PARAM_CODE + "=" + statusCode + ", " + PARAM_TYPE + "=" + contentType + ", " + PARAM_HEADERS + "=" + headers);
        this.server.setSoapResponseData(path, soapAction, content, contentType, statusCode, headers);
    }

    @RobotKeyword(value="Set new response data to return for the SOAP requests from file content. It is possible to set multiple different responses with different service paths and SOAP actions. Response content is taken from file content.Arguments:\n- _path_: Request path used to match for this response.\n- _soapAction_: SOAP action used to match for this response.\n- _filePath_: File path to response content data\n- _statusCode_: HTTP response status code. Default value is 200.\n- _contentType_: Optional response content type. Default matches content type from the request.\n- _headers_: Optional custom HTTP headers to return with response. Given as dictionary.\n\nExamples:\n| Set SOAP Response From File | path=/testService | soapAction=testAction | filePath=/path/to/file |\n| Set SOAP Response From File | path=/testService | soapAction=testAction | filePath=/path/to/file | statusCode=${200} | contentType=text/plain | headers=&{header_dict} |")
    @ArgumentNames(value={"path", "soapAction", "filePath", "statusCode=200", "contentType=application/soap+xml", "headers={}"})
    public void setSOAPResponseFromFile(String path, String soapAction, String filePath, String ... params) {
        int statusCode = RobotUtils.getParameterValue(params, 0, 200);
        String contentType = RobotUtils.getParameterValue(params, 1, DEFAULT_SOAP_CONTENT_TYPE);
        Map headers = RobotUtils.getParameterValue(params, 2, new HashMap());
        PrintUtil.printOut("path=" + path + ", soapAction=" + soapAction + ", " + PARAM_FILE + "=" + filePath + ", " + PARAM_CODE + "=" + statusCode + ", " + PARAM_TYPE + "=" + contentType + ", " + PARAM_HEADERS + "=" + headers);
        this.server.setSoapResponseDataFromFile(path, soapAction, filePath, contentType, statusCode, headers);
    }

    @RobotKeyword(value="Start initialized HTTP mock server")
    public void startHTTPServer() throws Exception {
        this.server.start();
    }

    @RobotKeyword(value="Stops running HTTP mock server")
    public void stopHTTPServer() throws Exception {
        this.server.stop();
    }

    private String resolveMethod(String originalMethod) {
        return StringUtils.isNotBlank(originalMethod) && !NONE.equals(originalMethod) ? originalMethod : DEFAULT_REST_METHOD;
    }

    private String resolvePath(String originalPath) {
        return StringUtils.isNotBlank(originalPath) && !NONE.equals(originalPath) ? originalPath : "/";
    }
}

