/*
 * Decompiled with CFR 0.152.
 */
package net.relaysoft.robot.http.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import net.relaysoft.robot.http.server.utils.HTTPUtils;
import net.relaysoft.robot.http.server.utils.StringUtils;

public class RequestDataHolder {
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private String authType;
    private String body;
    private String contentType;
    private String encoding;
    private String method;
    private String queryString;
    private String path;
    private Map<String, String> headers;

    public RequestDataHolder(HttpServletRequest httpServletRequest) throws IOException {
        this.authType = HTTPUtils.getAuthType(httpServletRequest);
        this.body = this.convertRequestBodyToString(httpServletRequest);
        this.contentType = httpServletRequest.getContentType();
        this.encoding = httpServletRequest.getCharacterEncoding();
        this.method = httpServletRequest.getMethod();
        this.queryString = httpServletRequest.getQueryString();
        this.path = httpServletRequest.getPathInfo();
        this.headers = this.convertRequestHeadersToMap(httpServletRequest);
    }

    public String toString() {
        return "RequestDataHolder [authType=" + this.authType + ", body=" + this.body + ", contentType=" + this.contentType + ", encoding=" + this.encoding + ", method=" + this.method + ", queryString=" + this.queryString + ", path=" + this.path + ", headers=" + this.headers + "]";
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getBody() {
        return this.body;
    }

    public String getContentType() {
        return StringUtils.isBlank(this.contentType) && this.headers.containsKey(HEADER_CONTENT_TYPE) ? this.headers.get(HEADER_CONTENT_TYPE) : this.contentType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getMethod() {
        return this.method;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    private String convertRequestBodyToString(HttpServletRequest httpServletRequest) throws IOException {
        String charset = httpServletRequest.getCharacterEncoding() != null ? httpServletRequest.getCharacterEncoding() : HTTPUtils.getCharsetFromContentType(httpServletRequest.getContentType());
        try (ServletInputStream is = httpServletRequest.getInputStream();){
            int length;
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            String string = result.toString(charset);
            return string;
        }
    }

    private Map<String, String> convertRequestHeadersToMap(HttpServletRequest httpServletRequest) {
        HashMap<String, String> convertedHeaders = new HashMap<String, String>();
        Enumeration headerNames = httpServletRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            String value = "";
            Enumeration requestHeaders = httpServletRequest.getHeaders(name);
            while (requestHeaders.hasMoreElements()) {
                value = value.isEmpty() ? (String)requestHeaders.nextElement() : value.concat(" ").concat((String)requestHeaders.nextElement());
            }
            convertedHeaders.put(name, value);
        }
        return convertedHeaders;
    }
}

