/*
 * Decompiled with CFR 0.152.
 */
package net.relaysoft.robot.http.server;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.relaysoft.robot.http.server.RequestDataHolder;
import net.relaysoft.robot.http.server.ResponseDataHolder;
import net.relaysoft.robot.http.server.utils.HTTPUtils;
import net.relaysoft.robot.http.server.utils.StringUtils;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class MockServer {
    private static final String DEFAULT = "DEFAULT";
    private static final String DEFAULT_CONTENT_TYPE = "text/plain";
    private static final String HEADER_SOAP_ACTION = "SOAPAction";
    private static final String REQUEST_METHOD_POST = "POST";
    private static final MultiKey DEFAULT_RESPONSE_KEY = new MultiKey((Object)"DEFAULT", (Object)"DEFAULT", (Object)"DEFAULT", (Object)"DEFAULT");
    private Server server;
    private int port = 0;
    private List<RequestDataHolder> requests = new ArrayList<RequestDataHolder>();
    private Map<MultiKey, ResponseDataHolder> responses = new HashMap<MultiKey, ResponseDataHolder>();

    MockServer() {
    }

    public void initializeServer(int port) throws IOException {
        this.port = port > 0 ? port : this.getAvailablePort();
        this.server = new Server(this.port);
        this.server.setHandler(this.createMockHandler());
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public int getPort() {
        return this.port;
    }

    public RequestDataHolder getRequest() {
        return this.getRequest(this.requests.size());
    }

    public RequestDataHolder getRequest(int requestNumber) {
        if (!this.requests.isEmpty()) {
            try {
                return this.requests.get(requestNumber - 1);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getRequestAuthType() {
        return this.getRequestAuthType(this.requests.size());
    }

    public String getRequestAuthType(int requestNumber) {
        if (!this.requests.isEmpty()) {
            try {
                return this.requests.get(requestNumber - 1).getAuthType();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getRequestBody() {
        return this.getRequestBody(this.requests.size());
    }

    public String getRequestBody(int requestNumber) {
        if (!this.requests.isEmpty()) {
            try {
                return this.requests.get(requestNumber - 1).getBody();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return null;
    }

    public int getRequestCount() {
        return this.requests.size();
    }

    public Map<String, String> getRequestHeaders() {
        return this.getRequestHeaders(this.requests.size());
    }

    public Map<String, String> getRequestHeaders(int requestNumber) {
        if (!this.requests.isEmpty()) {
            try {
                return this.requests.get(requestNumber - 1).getHeaders();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getRequestMethod() {
        return this.getRequestMethod(this.requests.size());
    }

    public String getRequestMethod(int requestNumber) {
        if (!this.requests.isEmpty()) {
            try {
                return this.requests.get(requestNumber - 1).getMethod();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getRequestQueryString() {
        return this.getRequestQueryString(this.requests.size());
    }

    public String getRequestQueryString(int requestNumber) {
        if (!this.requests.isEmpty()) {
            try {
                return this.requests.get(requestNumber - 1).getQueryString();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return null;
    }

    public void resetRequestData() {
        this.requests.clear();
    }

    public void resetResponseData() {
        this.responses.clear();
    }

    public void setDefaultResponse(String body, String contentType, Integer code, Map<String, String> headers) {
        ResponseDataHolder response = new ResponseDataHolder(body, contentType, code, headers);
        this.responses.put(DEFAULT_RESPONSE_KEY, response);
    }

    public void setDefaultResponseFromFile(String filePath, String contentType, Integer code, Map<String, String> headers) {
        ResponseDataHolder response = new ResponseDataHolder(Paths.get(filePath, new String[0]), contentType, code, headers);
        this.responses.put(DEFAULT_RESPONSE_KEY, response);
    }

    public void setRestResponseData(String path, String method, Map<String, String> queryParameters, String body, String contentType, Integer code, Map<String, String> headers) {
        ResponseDataHolder response = new ResponseDataHolder(body, contentType, code, headers);
        MultiKey responseKey = this.createMultiKey(path, method, queryParameters, null);
        this.responses.put(responseKey, response);
    }

    public void setRestResponseDataFromFile(String path, String method, Map<String, String> queryParameters, String filePath, String contentType, Integer code, Map<String, String> headers) {
        ResponseDataHolder response = new ResponseDataHolder(Paths.get(filePath, new String[0]), contentType, code, headers);
        MultiKey responseKey = this.createMultiKey(path, method, queryParameters, null);
        this.responses.put(responseKey, response);
    }

    public void setSoapResponseData(String path, String soapAction, String body, String contentType, Integer code, Map<String, String> headers) {
        ResponseDataHolder response = new ResponseDataHolder(body, contentType, code, headers);
        MultiKey responseKey = this.createMultiKey(path, REQUEST_METHOD_POST, null, soapAction);
        this.responses.put(responseKey, response);
    }

    public void setSoapResponseDataFromFile(String path, String soapAction, String filePath, String contentType, Integer code, Map<String, String> headers) {
        ResponseDataHolder response = new ResponseDataHolder(Paths.get(filePath, new String[0]), contentType, code, headers);
        MultiKey responseKey = this.createMultiKey(path, REQUEST_METHOD_POST, null, soapAction);
        this.responses.put(responseKey, response);
    }

    private Handler createMockHandler() {
        return new AbstractHandler(){

            public void handle(String target, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
                RequestDataHolder requestData = MockServer.this.createRequestDataHolder(httpServletRequest);
                MockServer.this.requests.add(requestData);
                ResponseDataHolder responseData = MockServer.this.getResponseForRequest(requestData);
                MockServer.this.initializeResponse(httpServletResponse, responseData, requestData);
                request.setHandled(true);
            }
        };
    }

    private int getAvailablePort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }

    private void initializeResponse(HttpServletResponse httpServletResponse, ResponseDataHolder responseData, RequestDataHolder requestData) throws IOException {
        String contentType = responseData.getContentType() != null ? responseData.getContentType() : requestData.getHeaders().get("Accept");
        httpServletResponse.setContentType(contentType != null ? contentType : DEFAULT_CONTENT_TYPE);
        httpServletResponse.setStatus(responseData.getCode() != null ? responseData.getCode() : 200);
        responseData.getHeaders().entrySet().stream().forEach(e -> httpServletResponse.setHeader((String)e.getKey(), (String)e.getValue()));
        this.writeResponseBody(httpServletResponse, responseData);
    }

    private RequestDataHolder createRequestDataHolder(HttpServletRequest httpServletRequest) throws IOException {
        return new RequestDataHolder(httpServletRequest);
    }

    private ResponseDataHolder getResponseForRequest(RequestDataHolder requestData) {
        MultiKey responseKey = this.createMultiKey(requestData);
        ResponseDataHolder response = this.responses.get(responseKey);
        if (response == null) {
            response = this.responses.get(DEFAULT_RESPONSE_KEY);
        }
        if (response == null) {
            response = this.generateDefaultResponse();
        }
        return response;
    }

    private ResponseDataHolder generateDefaultResponse() {
        return new ResponseDataHolder((String)null, (String)null, (Integer)404, new HashMap<String, String>());
    }

    private MultiKey createMultiKey(RequestDataHolder requestData) {
        String path = requestData.getPath();
        String method = requestData.getMethod();
        Map<String, String> queryParams = HTTPUtils.convertQueryStringIntoMap(requestData.getQueryString());
        String soapAction = requestData.getHeaders().get(HEADER_SOAP_ACTION);
        return this.createMultiKey(path, method, queryParams, soapAction);
    }

    private MultiKey createMultiKey(String path, String method, Map<String, String> queryParams, String soapAction) {
        return new MultiKey((Object)(StringUtils.isNotBlank(path) ? this.populatePath(path) : DEFAULT), (Object)(StringUtils.isNotBlank(method) ? method : DEFAULT), queryParams != null ? queryParams : new HashMap(), (Object)(StringUtils.isNotBlank(soapAction) ? soapAction : DEFAULT));
    }

    private String populatePath(String path) {
        return path.startsWith("/") ? path : "/".concat(path);
    }

    private void writeResponseBody(HttpServletResponse httpServletResponse, ResponseDataHolder responseData) throws IOException {
        String body = responseData.getBody();
        if (StringUtils.isNotBlank(body)) {
            String charset = HTTPUtils.getCharsetFromContentType(httpServletResponse.getContentType());
            byte[] data = body.getBytes(charset);
            try (ServletOutputStream os = httpServletResponse.getOutputStream();){
                os.write(data);
            }
        } else if (responseData.getFilePath() != null) {
            Files.copy(responseData.getFilePath(), (OutputStream)httpServletResponse.getOutputStream());
        }
    }
}

