/*
 * Decompiled with CFR 0.152.
 */
package net.reini.print;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.print.MultiDocPrintService;
import javax.print.PrintService;
import net.reini.print.VirtualPrintService;
import net.reini.print.VirtualPrinterRegistryMXBean;

final class VirtualPrinterRegistry
implements VirtualPrinterRegistryMXBean {
    private static final Logger LOG = Logger.getLogger(VirtualPrinterRegistry.class.getName());
    private final MBeanServer mbeanServer;
    private final List<PrintService> printServices;
    private final List<MultiDocPrintService> multiDocPrintServices;
    private String defaultPrinterName;

    VirtualPrinterRegistry(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
        this.printServices = new ArrayList<PrintService>();
        this.multiDocPrintServices = new ArrayList<MultiDocPrintService>();
        this.registerInJmx();
        this.initiallizePrinters();
    }

    private void registerInJmx() {
        try {
            this.mbeanServer.registerMBean(this, ObjectName.getInstance("net.reini", "type", "VirtualPrinters"));
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Unable to register management bean", e);
        }
    }

    private VirtualPrintService registerInJmx(VirtualPrintService virtualPrintService) {
        try {
            this.mbeanServer.registerMBean(virtualPrintService, ObjectName.getInstance("net.reini", this.table(virtualPrintService)));
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Unable to register management bean", e);
        }
        return virtualPrintService;
    }

    private Hashtable<String, String> table(PrintService virtualPrintService) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("type", "virtual-printers");
        table.put("name", virtualPrintService.getName());
        return table;
    }

    private boolean unregisterFromJmxIfMatches(PrintService printService, String name) {
        if (printService.getName().equals(name)) {
            try {
                this.mbeanServer.unregisterMBean(ObjectName.getInstance("net.reini", this.table(printService)));
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Unable to unregister management bean", e);
            }
            return true;
        }
        return false;
    }

    private void initiallizePrinters() {
        try (Stream<URL> resources = Thread.currentThread().getContextClassLoader().resources("virtual-printer-names");){
            if (resources.filter(this::addPrintersFromDefinition).count() == 0L) {
                this.addPrinter("VirtualPrinter");
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to locate virtual printer definitions", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean addPrintersFromDefinition(URL url) {
        try (InputStream in = url.openStream();){
            boolean bl;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                br.lines().map(String::trim).filter(l -> !l.isEmpty()).filter(l -> !l.startsWith("#")).forEach(this::addPrinter);
                bl = true;
            }
            return bl;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e, () -> "Failed to initialize printers from " + url);
            return false;
        }
    }

    @Override
    public String getDefaultPrinterName() {
        return this.defaultPrinterName;
    }

    @Override
    public void setDefaultPrinterName(String printerName) {
        if (this.printServices.stream().anyMatch(ps -> ps.getName().equals(printerName))) {
            this.defaultPrinterName = printerName;
        }
    }

    @Override
    public void addPrinter(String printerName) {
        Objects.requireNonNull(printerName, "printerName must not be null");
        if (this.printServices.stream().map(PrintService::getName).noneMatch(printerName::equals)) {
            LOG.log(Level.INFO, () -> "Adding printer: " + printerName);
            this.printServices.add(this.registerInJmx(new VirtualPrintService(printerName, () -> this.removePrinter(printerName))));
        }
    }

    @Override
    public void removePrinter(String printerName) {
        Objects.requireNonNull(printerName, "printerName must not be null");
        if (printerName.equals(this.defaultPrinterName)) {
            this.defaultPrinterName = null;
        }
        this.printServices.removeIf(ps -> this.unregisterFromJmxIfMatches((PrintService)ps, printerName));
    }

    Stream<PrintService> printServices() {
        return this.printServices.stream();
    }

    Stream<MultiDocPrintService> multiDocPrintServices() {
        return this.multiDocPrintServices.stream();
    }

    PrintService defaultPrintService() {
        if (this.defaultPrinterName == null) {
            return null;
        }
        return this.printServices.stream().filter(ps -> ps.getName().endsWith(this.defaultPrinterName)).findFirst().orElse(null);
    }
}

