/*
 * Decompiled with CFR 0.152.
 */
package net.reini.print;

import java.lang.management.ManagementFactory;
import javax.print.DocFlavor;
import javax.print.MultiDocPrintService;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.standard.PrinterName;
import net.reini.print.VirtualPrinterRegistry;

public final class VirtualPrintServiceLookup
extends PrintServiceLookup {
    private static VirtualPrinterRegistry printerRegistry;

    static VirtualPrinterRegistry getPrinterRegistry() {
        if (printerRegistry == null) {
            printerRegistry = new VirtualPrinterRegistry(ManagementFactory.getPlatformMBeanServer());
        }
        return printerRegistry;
    }

    private boolean serviceMatches(PrintService ps, AttributeSet attributes) {
        if (attributes == null) {
            return true;
        }
        PrinterName attribute = (PrinterName)attributes.get(PrinterName.class);
        if (attribute == null) {
            return false;
        }
        return ps.getName().equals(attribute.getValue());
    }

    private boolean flavorMatches(PrintService ps, DocFlavor[] flavors) {
        if (flavors == null) {
            return true;
        }
        for (DocFlavor flavor : flavors) {
            if (ps.isDocFlavorSupported(flavor)) continue;
            return false;
        }
        return true;
    }

    @Override
    public PrintService[] getPrintServices(DocFlavor flavor, AttributeSet attributes) {
        return (PrintService[])VirtualPrintServiceLookup.getPrinterRegistry().printServices().filter(ps -> flavor == null || ps.isDocFlavorSupported(flavor)).filter(ps -> this.serviceMatches((PrintService)ps, attributes)).toArray(PrintService[]::new);
    }

    @Override
    public PrintService[] getPrintServices() {
        return (PrintService[])VirtualPrintServiceLookup.getPrinterRegistry().printServices().toArray(PrintService[]::new);
    }

    @Override
    public MultiDocPrintService[] getMultiDocPrintServices(DocFlavor[] flavors, AttributeSet attributes) {
        return (MultiDocPrintService[])VirtualPrintServiceLookup.getPrinterRegistry().multiDocPrintServices().filter(ps -> this.flavorMatches((PrintService)ps, flavors)).filter(ps -> this.serviceMatches((PrintService)ps, attributes)).toArray(MultiDocPrintService[]::new);
    }

    @Override
    public PrintService getDefaultPrintService() {
        return VirtualPrintServiceLookup.getPrinterRegistry().defaultPrintService();
    }
}

