/*
 * Decompiled with CFR 0.152.
 */
package net.reini.print;

import java.io.ByteArrayOutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.ServiceUIFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterName;
import javax.print.attribute.standard.PrinterState;
import javax.print.event.PrintJobAdapter;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintServiceAttributeListener;
import net.reini.print.VirtualDocPrintJob;
import net.reini.print.VirtualPrintServiceMXBean;

class VirtualPrintService
implements PrintService,
VirtualPrintServiceMXBean {
    private static final Class<?>[] supportedAttributeCategories = new Class[0];
    private static final DocFlavor[] emptyDocFlavors = new DocFlavor[0];
    private final String name;
    private final Runnable removeAction;
    private final Set<DocFlavor> supportedFlavors;
    private final StatisticsListener statisticsListener;
    private final PrintServiceAttributeSet printServiceAttributeSet;
    private PrinterState printerState;
    private PrinterIsAcceptingJobs acceptingJobs;

    public VirtualPrintService(String name, Runnable removeAction) {
        this.name = name;
        this.removeAction = removeAction;
        this.supportedFlavors = new HashSet<DocFlavor>();
        this.supportedFlavors.add(DocFlavor.SERVICE_FORMATTED.PAGEABLE);
        this.supportedFlavors.add(DocFlavor.SERVICE_FORMATTED.PRINTABLE);
        this.printServiceAttributeSet = new HashPrintServiceAttributeSet();
        this.statisticsListener = new StatisticsListener();
        this.printerState = PrinterState.IDLE;
        this.activate();
    }

    @Override
    public long getCanceled() {
        return this.statisticsListener.canceled.longValue();
    }

    @Override
    public long getCompleted() {
        return this.statisticsListener.completed.longValue();
    }

    @Override
    public long getFailed() {
        return this.statisticsListener.failed.longValue();
    }

    @Override
    public int getRunning() {
        return 0;
    }

    @Override
    public void activate() {
        this.acceptingJobs = PrinterIsAcceptingJobs.ACCEPTING_JOBS;
    }

    @Override
    public void suspend() {
        this.acceptingJobs = PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS;
    }

    @Override
    public void remove() {
        this.removeAction.run();
    }

    @Override
    public String getPrinterState() {
        return this.printerState.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DocPrintJob createPrintJob() {
        return this.statisticsListener.startJob(new VirtualDocPrintJob(this, ByteArrayOutputStream::new));
    }

    @Override
    public boolean isDocFlavorSupported(DocFlavor flavor) {
        return this.supportedFlavors.contains(flavor);
    }

    @Override
    public <T extends PrintServiceAttribute> T getAttribute(Class<T> category) {
        PrintServiceAttribute result = category == PrinterName.class ? new PrinterName(this.name, null) : (category == PrinterIsAcceptingJobs.class ? this.acceptingJobs : (category == PrinterState.class ? this.printerState : (PrintServiceAttribute)category.cast(this.printServiceAttributeSet.get(category))));
        return (T)result;
    }

    @Override
    public PrintServiceAttributeSet getAttributes() {
        HashPrintServiceAttributeSet attrs = new HashPrintServiceAttributeSet();
        attrs.addAll(this.printServiceAttributeSet);
        attrs.add(this.getAttribute(PrinterName.class));
        attrs.add(this.getAttribute(PrinterState.class));
        attrs.add(this.getAttribute(PrinterIsAcceptingJobs.class));
        return AttributeSetUtilities.unmodifiableView(attrs);
    }

    @Override
    public DocFlavor[] getSupportedDocFlavors() {
        return this.supportedFlavors.toArray(emptyDocFlavors);
    }

    @Override
    public Object getDefaultAttributeValue(Class<? extends Attribute> category) {
        return null;
    }

    @Override
    public ServiceUIFactory getServiceUIFactory() {
        return null;
    }

    @Override
    public Class<?>[] getSupportedAttributeCategories() {
        return supportedAttributeCategories;
    }

    @Override
    public Object getSupportedAttributeValues(Class<? extends Attribute> category, DocFlavor flavor, AttributeSet attributes) {
        return null;
    }

    @Override
    public AttributeSet getUnsupportedAttributes(DocFlavor flavor, AttributeSet attributes) {
        return null;
    }

    @Override
    public boolean isAttributeCategorySupported(Class<? extends Attribute> category) {
        return false;
    }

    @Override
    public boolean isAttributeValueSupported(Attribute attrval, DocFlavor flavor, AttributeSet attributes) {
        return false;
    }

    @Override
    public void addPrintServiceAttributeListener(PrintServiceAttributeListener listener) {
    }

    @Override
    public void removePrintServiceAttributeListener(PrintServiceAttributeListener listener) {
    }

    public String toString() {
        return "Virtual Printer : " + this.name;
    }

    static class StatisticsListener
    extends PrintJobAdapter {
        final LongAdder canceled = new LongAdder();
        final LongAdder completed = new LongAdder();
        final LongAdder failed = new LongAdder();
        final AtomicLong running = new AtomicLong();

        StatisticsListener() {
        }

        DocPrintJob startJob(VirtualDocPrintJob virtualDocPrintJob) {
            virtualDocPrintJob.addPrintJobListener(this);
            this.running.incrementAndGet();
            return virtualDocPrintJob;
        }

        @Override
        public void printJobCanceled(PrintJobEvent pje) {
            this.canceled.increment();
        }

        @Override
        public void printJobCompleted(PrintJobEvent pje) {
            this.completed.increment();
        }

        @Override
        public void printJobFailed(PrintJobEvent pje) {
            this.failed.increment();
        }

        @Override
        public void printJobNoMoreEvents(PrintJobEvent pje) {
            this.running.decrementAndGet();
        }
    }
}

