/*
 * Decompiled with CFR 0.152.
 */
package net.reini.print;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashPrintJobAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintJobAttribute;
import javax.print.attribute.PrintJobAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.DocumentName;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobOriginatingUserName;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.event.PrintJobAttributeListener;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;

class VirtualDocPrintJob
implements DocPrintJob {
    private static final Logger LOG = Logger.getLogger(VirtualDocPrintJob.class.getName());
    private final AtomicBoolean printing = new AtomicBoolean();
    private final PrintService service;
    private final Supplier<OutputStream> outputStreamSupplier;
    private PrintJobAttributeSet jobAttrSet;
    private List<PrintJobListener> jobListeners;
    private List<PrintJobAttributeListener> attrListeners;
    private List<PrintJobAttributeSet> listenedAttributeSets;

    VirtualDocPrintJob(PrintService service, Supplier<OutputStream> outputStreamSupplier) {
        this.service = service;
        this.outputStreamSupplier = outputStreamSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEvent(int reason) {
        VirtualDocPrintJob virtualDocPrintJob = this;
        synchronized (virtualDocPrintJob) {
            if (this.jobListeners != null) {
                PrintJobEvent event = new PrintJobEvent(this, reason);
                for (PrintJobListener listener : this.jobListeners) {
                    switch (event.getPrintEventType()) {
                        case 101: {
                            listener.printJobCanceled(event);
                            break;
                        }
                        case 103: {
                            listener.printJobFailed(event);
                            break;
                        }
                        case 106: {
                            listener.printDataTransferCompleted(event);
                            break;
                        }
                        case 105: {
                            listener.printJobNoMoreEvents(event);
                            break;
                        }
                        case 102: {
                            listener.printJobCompleted(event);
                            break;
                        }
                    }
                }
            }
        }
    }

    private synchronized PrintRequestAttributeSet initializeAttributeSets(Doc doc, PrintRequestAttributeSet reqSet) {
        DocAttributeSet docSet;
        HashPrintRequestAttributeSet reqAttr = new HashPrintRequestAttributeSet();
        HashPrintJobAttributeSet jobAttr = new HashPrintJobAttributeSet();
        if (reqSet != null) {
            reqAttr.addAll(reqSet);
            for (Attribute attribute : reqSet.toArray()) {
                if (!(attribute instanceof PrintJobAttribute)) continue;
                jobAttr.add(attribute);
            }
        }
        if ((docSet = doc.getAttributes()) != null) {
            for (Attribute attribute : docSet.toArray()) {
                if (attribute instanceof PrintJobAttribute) {
                    jobAttr.add(attribute);
                }
                if (!(attribute instanceof PrintRequestAttribute)) continue;
                reqAttr.add(attribute);
            }
        }
        VirtualDocPrintJob.updateUserName(reqAttr, jobAttr);
        VirtualDocPrintJob.updateJobName(doc, docSet, jobAttr);
        this.jobAttrSet = AttributeSetUtilities.unmodifiableView(jobAttr);
        return reqAttr;
    }

    private static void updateJobName(Doc doc, DocAttributeSet docSet, PrintJobAttributeSet jobAttr) {
        if (jobAttr.get(JobName.class) == null) {
            if (docSet != null && docSet.get(DocumentName.class) != null) {
                DocumentName docName = (DocumentName)docSet.get(DocumentName.class);
                jobAttr.add(new JobName(docName.getValue(), docName.getLocale()));
            } else {
                Object str = "VPS Job:" + doc;
                try {
                    Object printData = doc.getPrintData();
                    if (printData instanceof URL) {
                        str = ((URL)doc.getPrintData()).toString();
                    }
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "Failed to get print data", e);
                }
                jobAttr.add(new JobName((String)str, null));
            }
        }
    }

    private static void updateUserName(PrintRequestAttributeSet reqSet, PrintJobAttributeSet jobAttr) {
        String userName = "";
        try {
            userName = System.getProperty("user.name");
        }
        catch (SecurityException se) {
            LOG.log(Level.WARNING, "Failed to get user name", se);
        }
        if (userName == null || userName.equals("")) {
            RequestingUserName ruName = (RequestingUserName)reqSet.get(RequestingUserName.class);
            if (ruName != null) {
                jobAttr.add(new JobOriginatingUserName(ruName.getValue(), ruName.getLocale()));
            } else {
                jobAttr.add(new JobOriginatingUserName("", null));
            }
        } else {
            jobAttr.add(new JobOriginatingUserName(userName, null));
        }
    }

    @Override
    public PrintService getPrintService() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrintJobAttributeSet getAttributes() {
        VirtualDocPrintJob virtualDocPrintJob = this;
        synchronized (virtualDocPrintJob) {
            if (this.jobAttrSet == null) {
                HashPrintJobAttributeSet jobSet = new HashPrintJobAttributeSet();
                return AttributeSetUtilities.unmodifiableView(jobSet);
            }
            return this.jobAttrSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPrintJobAttributeListener(PrintJobAttributeListener listener, PrintJobAttributeSet attributes) {
        VirtualDocPrintJob virtualDocPrintJob = this;
        synchronized (virtualDocPrintJob) {
            if (listener == null) {
                return;
            }
            if (this.attrListeners == null) {
                this.attrListeners = new ArrayList<PrintJobAttributeListener>();
                this.listenedAttributeSets = new ArrayList<PrintJobAttributeSet>();
            }
            this.attrListeners.add(listener);
            if (attributes == null) {
                attributes = new HashPrintJobAttributeSet();
            }
            this.listenedAttributeSets.add(attributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePrintJobAttributeListener(PrintJobAttributeListener listener) {
        VirtualDocPrintJob virtualDocPrintJob = this;
        synchronized (virtualDocPrintJob) {
            if (listener == null || this.attrListeners == null) {
                return;
            }
            int index = this.attrListeners.indexOf(listener);
            if (index >= 0) {
                this.attrListeners.remove(index);
                this.listenedAttributeSets.remove(index);
                if (this.attrListeners.isEmpty()) {
                    this.attrListeners = null;
                    this.listenedAttributeSets = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPrintJobListener(PrintJobListener listener) {
        VirtualDocPrintJob virtualDocPrintJob = this;
        synchronized (virtualDocPrintJob) {
            if (listener == null) {
                return;
            }
            if (this.jobListeners == null) {
                this.jobListeners = new ArrayList<PrintJobListener>();
            }
            this.jobListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePrintJobListener(PrintJobListener listener) {
        VirtualDocPrintJob virtualDocPrintJob = this;
        synchronized (virtualDocPrintJob) {
            if (listener == null || this.jobListeners == null) {
                return;
            }
            this.jobListeners.remove(listener);
            if (this.jobListeners.isEmpty()) {
                this.jobListeners = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(Doc doc, PrintRequestAttributeSet attributes) throws PrintException {
        block13: {
            if (!this.printing.compareAndSet(false, true)) {
                throw new PrintException("already printing");
            }
            try {
                DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
                String psMimeType = DocFlavor.BYTE_ARRAY.POSTSCRIPT.getMimeType();
                StreamPrintServiceFactory[] factories = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(flavor, psMimeType);
                if (factories.length == 0) {
                    LOG.log(Level.WARNING, "No suitable stream print service factories found");
                    this.notifyEvent(103);
                    break block13;
                }
                try (OutputStream fos = this.outputStreamSupplier.get();){
                    StreamPrintService sps = factories[0].getPrintService(fos);
                    DocPrintJob pj = sps.createPrintJob();
                    pj.print(doc, this.initializeAttributeSets(doc, attributes));
                    this.notifyEvent(102);
                }
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Printing failed", e);
                this.notifyEvent(103);
            }
            finally {
                this.notifyEvent(105);
            }
        }
    }
}

