/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import java.util.HashMap;
import java.util.Map;
import net.reini.rabbitmq.cdi.Declaration;

public final class QueueDeclaration
implements Declaration {
    private final Map<String, Object> arguments = new HashMap<String, Object>();
    private boolean durable;
    private boolean autoDelete;
    private boolean exclusive;
    private String queueName;

    QueueDeclaration(String queueName) {
        this.queueName = queueName;
    }

    public QueueDeclaration withDurable(boolean durable) {
        this.durable = durable;
        return this;
    }

    public QueueDeclaration withAutoDelete(boolean autoDelete) {
        this.autoDelete = autoDelete;
        return this;
    }

    public QueueDeclaration withArgument(String key, Object argument) {
        this.arguments.put(key, argument);
        return this;
    }

    public QueueDeclaration withExclusiveAccess(boolean exclusive) {
        this.exclusive = exclusive;
        return this;
    }

    public String toString() {
        return "queue declaration for queueName='" + this.queueName + '\'' + ", durable=" + this.durable + ", autoDelete=" + this.autoDelete + ", arguments=" + this.arguments + ", exclusive=" + this.exclusive;
    }

    boolean isExclusive() {
        return this.exclusive;
    }

    String getQueueName() {
        return this.queueName;
    }

    boolean isDurable() {
        return this.durable;
    }

    boolean isAutoDelete() {
        return this.autoDelete;
    }

    Map<String, Object> getArguments() {
        return this.arguments;
    }
}

