/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import net.reini.rabbitmq.cdi.ConnectionRepository;
import net.reini.rabbitmq.cdi.Declaration;
import net.reini.rabbitmq.cdi.DeclarerRepository;
import net.reini.rabbitmq.cdi.EncodeException;
import net.reini.rabbitmq.cdi.MessagePublisher;
import net.reini.rabbitmq.cdi.PublishException;
import net.reini.rabbitmq.cdi.PublisherConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericPublisher
implements MessagePublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericPublisher.class);
    public static final int DEFAULT_RETRY_ATTEMPTS = 3;
    public static final int DEFAULT_RETRY_INTERVAL = 1000;
    private final DeclarerRepository declarerRepository;
    private final ConnectionRepository connectionRepository;

    public GenericPublisher(ConnectionRepository connectionRepository) {
        this.connectionRepository = connectionRepository;
        this.declarerRepository = new DeclarerRepository();
    }

    protected void handleIoException(int attempt, Throwable cause) throws PublishException {
        if (attempt == 3) {
            throw new PublishException("Unable to send message after " + attempt + " attempts", cause);
        }
        this.sleepBeforeRetry();
    }

    protected void sleepBeforeRetry() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Sending message interrupted while waiting for retry attempt", (Throwable)e);
        }
    }

    @Override
    public void publish(Object event, PublisherConfiguration<?> publisherConfiguration) throws PublishException {
        for (int attempt = 1; attempt <= 3; ++attempt) {
            if (attempt > 1) {
                LOGGER.debug("Attempt {} to send message", (Object)attempt);
            }
            try (Channel channel = this.connectionRepository.getConnection(publisherConfiguration.getConfig()).createChannel();){
                List<Declaration> declarations = publisherConfiguration.getDeclarations();
                this.declarerRepository.declare(channel, declarations);
                publisherConfiguration.publish(channel, event);
                return;
            }
            catch (EncodeException e) {
                throw new PublishException("Unable to serialize event", e);
            }
            catch (IOException | TimeoutException e) {
                this.handleIoException(attempt, e);
                continue;
            }
        }
    }

    @Override
    public void close() {
    }
}

