/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import com.rabbitmq.client.BuiltinExchangeType;
import java.util.HashMap;
import java.util.Map;
import net.reini.rabbitmq.cdi.Declaration;

public final class ExchangeDeclaration
implements Declaration {
    private final Map<String, Object> arguments = new HashMap<String, Object>();
    private boolean durable;
    private boolean autoDelete = true;
    private String exchangeName;
    private String exchangeType = BuiltinExchangeType.DIRECT.getType();

    public ExchangeDeclaration(String exchangeName) {
        this.exchangeName = exchangeName;
    }

    public ExchangeDeclaration withDurable(boolean durable) {
        this.durable = durable;
        return this;
    }

    public ExchangeDeclaration withAutoDelete(boolean autoDelete) {
        this.autoDelete = autoDelete;
        return this;
    }

    public ExchangeDeclaration withType(String exchangeType) {
        this.exchangeType = exchangeType;
        return this;
    }

    public ExchangeDeclaration withType(BuiltinExchangeType exchangeType) {
        this.exchangeType = exchangeType.getType();
        return this;
    }

    public ExchangeDeclaration withArgument(String key, Object argument) {
        this.arguments.put(key, argument);
        return this;
    }

    String getExchangeName() {
        return this.exchangeName;
    }

    String getExchangeType() {
        return this.exchangeType;
    }

    boolean isDurable() {
        return this.durable;
    }

    boolean isAutoDelete() {
        return this.autoDelete;
    }

    Map<String, Object> getArguments() {
        return this.arguments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExchangeDeclaration)) {
            return false;
        }
        ExchangeDeclaration that = (ExchangeDeclaration)o;
        if (this.durable != that.durable) {
            return false;
        }
        if (this.autoDelete != that.autoDelete) {
            return false;
        }
        if (!this.exchangeName.equals(that.exchangeName)) {
            return false;
        }
        if (!this.exchangeType.equals(that.exchangeType)) {
            return false;
        }
        return this.arguments.equals(that.arguments);
    }

    public int hashCode() {
        int result = this.exchangeName.hashCode();
        result = 31 * result + this.exchangeType.hashCode();
        result = 31 * result + (this.durable ? 1 : 0);
        result = 31 * result + (this.autoDelete ? 1 : 0);
        result = 31 * result + this.arguments.hashCode();
        return result;
    }

    public String toString() {
        return "exchange declaration for exchangeName='" + this.exchangeName + '\'' + ", exchangeType='" + this.exchangeType + '\'' + ", durable=" + this.durable + ", autoDelete=" + this.autoDelete + ", arguments=" + this.arguments;
    }
}

