/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.enterprise.event.Observes;
import javax.enterprise.event.TransactionPhase;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.reini.rabbitmq.cdi.ConnectionRepository;
import net.reini.rabbitmq.cdi.EventKey;
import net.reini.rabbitmq.cdi.GenericPublisher;
import net.reini.rabbitmq.cdi.MessagePublisher;
import net.reini.rabbitmq.cdi.PublishException;
import net.reini.rabbitmq.cdi.PublisherConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EventPublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventPublisher.class);
    private final ConnectionRepository connectionRepository;
    private final Map<EventKey<?>, PublisherConfiguration<?>> publisherConfigurations;
    private final ThreadLocal<Map<EventKey<?>, MessagePublisher>> publishers;

    @Inject
    public EventPublisher(ConnectionRepository connectionRepository) {
        this.connectionRepository = connectionRepository;
        this.publisherConfigurations = new HashMap();
        this.publishers = ThreadLocal.withInitial(HashMap::new);
    }

    public <T> void addEvent(EventKey<T> eventKey, PublisherConfiguration<T> configuration) {
        this.publisherConfigurations.put(eventKey, configuration);
    }

    public void onEventInProgress(@Observes(during=TransactionPhase.IN_PROGRESS) Object event) {
        this.publishEvent(event, TransactionPhase.IN_PROGRESS);
    }

    public void onEventBeforeCompletion(@Observes(during=TransactionPhase.BEFORE_COMPLETION) Object event) {
        this.publishEvent(event, TransactionPhase.BEFORE_COMPLETION);
    }

    public void onEventAfterCompletion(@Observes(during=TransactionPhase.AFTER_COMPLETION) Object event) {
        this.publishEvent(event, TransactionPhase.AFTER_COMPLETION);
    }

    public void onEventAfterFailure(@Observes(during=TransactionPhase.AFTER_FAILURE) Object event) {
        this.publishEvent(event, TransactionPhase.AFTER_FAILURE);
    }

    public void onEventAfterSuccess(@Observes(during=TransactionPhase.AFTER_SUCCESS) Object event) {
        this.publishEvent(event, TransactionPhase.AFTER_SUCCESS);
    }

    void publishEvent(Object event, TransactionPhase transactionPhase) {
        EventKey<?> eventKey = EventKey.of(event.getClass(), transactionPhase);
        PublisherConfiguration<?> configuration = this.publisherConfigurations.get(eventKey);
        if (configuration == null) {
            LOGGER.trace("No publisher configured for event {}", event);
        } else {
            this.doPublish(event, this.providePublisher(eventKey, transactionPhase), configuration);
        }
    }

    @PreDestroy
    public void cleanUp() {
        this.publishers.get().values().forEach(MessagePublisher::close);
    }

    <T> void doPublish(T event, MessagePublisher publisher, PublisherConfiguration<T> configuration) {
        try {
            LOGGER.debug("Start publishing event {} ({})...", event, configuration);
            publisher.publish(event, configuration);
            LOGGER.debug("Published event successfully");
        }
        catch (PublishException e) {
            LOGGER.debug("Published event failed");
            configuration.accept(event, e);
        }
    }

    MessagePublisher providePublisher(EventKey<?> eventKey, TransactionPhase transactionPhase) {
        Map<EventKey<?>, MessagePublisher> localPublishers = this.publishers.get();
        return localPublishers.computeIfAbsent(eventKey, key -> new GenericPublisher(this.connectionRepository));
    }
}

