/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.reini.rabbitmq.cdi.BindingDeclaration;
import net.reini.rabbitmq.cdi.BindingDeclarer;
import net.reini.rabbitmq.cdi.Declaration;
import net.reini.rabbitmq.cdi.Declarer;
import net.reini.rabbitmq.cdi.ExchangeDeclaration;
import net.reini.rabbitmq.cdi.ExchangeDeclarer;
import net.reini.rabbitmq.cdi.QueueDeclaration;
import net.reini.rabbitmq.cdi.QueueDeclarer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeclarerRepository {
    private final Map<Class, Declarer> declarerMap = new HashMap<Class, Declarer>();
    private static final Logger LOGGER = LoggerFactory.getLogger(DeclarerRepository.class);

    DeclarerRepository() {
        this.declarerMap.put(ExchangeDeclaration.class, new ExchangeDeclarer());
        this.declarerMap.put(QueueDeclaration.class, new QueueDeclarer());
        this.declarerMap.put(BindingDeclaration.class, new BindingDeclarer());
    }

    void declare(Channel channel, List<Declaration> declarations) throws IOException {
        for (Declaration declaration : declarations) {
            Declarer declarer = this.declarerMap.get(declaration.getClass());
            LOGGER.info("declaring: {}", (Object)declaration);
            declarer.declare(channel, declaration);
        }
    }
}

