/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import net.reini.rabbitmq.cdi.EnvelopeConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConsumerImpl
implements Consumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerImpl.class);
    private final EnvelopeConsumer envelopeConsumer;

    static Consumer createAcknowledged(EnvelopeConsumer consumer, Channel channel) {
        return ConsumerImpl.create((consumerTag, envelope, properties, body) -> ConsumerImpl.acknowledgedConsume(consumer, channel, consumerTag, envelope, properties, body));
    }

    static Consumer create(EnvelopeConsumer consumer) {
        return new ConsumerImpl(consumer);
    }

    static boolean acknowledgedConsume(EnvelopeConsumer consumer, Channel channel, String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        long deliveryTag = envelope.getDeliveryTag();
        try {
            if (consumer.consume(consumerTag, envelope, properties, body)) {
                channel.basicAck(deliveryTag, false);
                LOGGER.debug("Acknowledged {}", (Object)envelope);
                return true;
            }
            channel.basicNack(deliveryTag, false, false);
            LOGGER.debug("Not acknowledged {}", (Object)envelope);
        }
        catch (IOException e) {
            LOGGER.warn("Consume failed for {}", (Object)envelope, (Object)e);
            channel.basicNack(deliveryTag, false, true);
            LOGGER.debug("Not acknowledged {} (re-queue)", (Object)envelope);
        }
        return false;
    }

    private ConsumerImpl(EnvelopeConsumer envelopeConsumer) {
        this.envelopeConsumer = envelopeConsumer;
    }

    public void handleConsumeOk(String consumerTag) {
    }

    public void handleCancelOk(String consumerTag) {
    }

    public void handleCancel(String consumerTag) throws IOException {
    }

    public void handleShutdownSignal(String consumerTag, ShutdownSignalException sig) {
    }

    public void handleRecoverOk(String consumerTag) {
    }

    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        this.envelopeConsumer.consume(consumerTag, envelope, properties, body);
    }
}

