/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import net.reini.rabbitmq.cdi.ConsumerHolder;
import net.reini.rabbitmq.cdi.UnrecoverableErrorDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConsumerHolderChannelShutdownListener
implements ShutdownListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerHolderChannelShutdownListener.class);
    private final UnrecoverableErrorDetector unrecoverableErrorDetector;
    private ConsumerHolder consumerHolder;

    ConsumerHolderChannelShutdownListener(ConsumerHolder consumerHolder) {
        this.consumerHolder = consumerHolder;
        this.unrecoverableErrorDetector = new UnrecoverableErrorDetector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownCompleted(ShutdownSignalException cause) {
        ConsumerHolder consumerHolder = this.consumerHolder;
        synchronized (consumerHolder) {
            LOGGER.warn("channel shutdown detected", (Throwable)cause);
            if (this.unrecoverableErrorDetector.isUnrecoverableError(cause)) {
                this.consumerHolder.ensureCompleteShutdown();
            }
        }
    }
}

