/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ShutdownListener;
import java.io.IOException;
import java.util.List;
import net.reini.rabbitmq.cdi.ConsumerChannelFactory;
import net.reini.rabbitmq.cdi.ConsumerFactory;
import net.reini.rabbitmq.cdi.ConsumerHolderChannelShutdownListener;
import net.reini.rabbitmq.cdi.Declaration;
import net.reini.rabbitmq.cdi.DeclarerRepository;
import net.reini.rabbitmq.cdi.EventConsumer;
import net.reini.rabbitmq.cdi.ResourceCloser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConsumerHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerHolder.class);
    private final boolean autoAck;
    private final String queueName;
    private final Object activeLock;
    private final EventConsumer consumer;
    private final ShutdownListener shutdownListener;
    private final ConsumerChannelFactory consumerChannelFactory;
    private final ResourceCloser resourceCloser;
    private final ConsumerFactory consumerFactory;
    private final DeclarerRepository declarerRepository;
    private final List<Declaration> declarations;
    private final int prefetchCount;
    private Channel channel;
    private volatile boolean active;

    ConsumerHolder(EventConsumer consumer, String queueName, boolean autoAck, int prefetchCount, ConsumerChannelFactory consumerChannelFactory, ConsumerFactory consumerFactory, List<Declaration> declarations, DeclarerRepository declarerRepository) {
        this.consumer = consumer;
        this.queueName = queueName;
        this.autoAck = autoAck;
        this.prefetchCount = prefetchCount;
        this.consumerChannelFactory = consumerChannelFactory;
        this.declarations = declarations;
        this.declarerRepository = declarerRepository;
        this.activeLock = new Object();
        this.resourceCloser = new ResourceCloser();
        this.shutdownListener = new ConsumerHolderChannelShutdownListener(this);
        this.consumerFactory = consumerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deactivate() {
        Object object = this.activeLock;
        synchronized (object) {
            if (this.active) {
                LOGGER.debug("Deactivating consumer of class {}", this.consumer.getClass());
                LOGGER.debug("Closing channel for consumer of class {}", this.consumer.getClass());
                this.ensureCompleteShutdown();
            }
            LOGGER.info("Deactivated consumer of class {}", this.consumer.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activate() throws IOException {
        Object object = this.activeLock;
        synchronized (object) {
            if (!this.active) {
                LOGGER.debug("Activating consumer of class {}", this.consumer.getClass());
                try {
                    this.channel = this.consumerChannelFactory.createChannel();
                    this.channel.addShutdownListener(this.shutdownListener);
                    this.declarerRepository.declare(this.channel, this.declarations);
                    this.channel.basicQos(this.prefetchCount);
                    this.channel.basicConsume(this.queueName, this.autoAck, this.autoAck ? this.consumerFactory.create(this.consumer) : this.consumerFactory.createAcknowledged(this.consumer, this.channel));
                    LOGGER.info("Activated consumer of class {}", this.consumer.getClass());
                    this.active = true;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to activate consumer of class {}", this.consumer.getClass(), (Object)e);
                    this.ensureCompleteShutdown();
                    throw e;
                }
            }
        }
    }

    void ensureCompleteShutdown() {
        if (this.channel != null) {
            this.channel.removeShutdownListener(this.shutdownListener);
        }
        this.resourceCloser.closeResource((AutoCloseable)this.channel, "closing channel for consumer " + this.consumer.getClass());
        this.channel = null;
        this.active = false;
    }

    boolean isAutoAck() {
        return this.autoAck;
    }

    String getQueueName() {
        return this.queueName;
    }
}

