/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import net.reini.rabbitmq.cdi.ConsumerContainer;
import net.reini.rabbitmq.cdi.StoppableThread;
import net.reini.rabbitmq.cdi.ThreadStopper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConsumerContainerWatcherThread
extends StoppableThread {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerContainerWatcherThread.class);
    private final ConsumerContainer consumerContainer;
    private final ReentrantLock lock;
    private final Condition noConnectionCondition;
    private final ThreadStopper threadStopper = new ThreadStopper();
    private long attempt;
    private long retryTime;

    ConsumerContainerWatcherThread(ConsumerContainer consumerContainer, long retryTime, ReentrantLock lock, Condition noConnectionCondition) {
        this.consumerContainer = consumerContainer;
        this.retryTime = retryTime;
        this.lock = lock;
        this.noConnectionCondition = noConnectionCondition;
        this.setDaemon(true);
        this.setName("consumer watcher thread");
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted() && !this.stopped) {
            boolean allConsumersActive = false;
            try {
                this.lock.lock();
                if (this.consumerContainer.isConnectionAvailable()) {
                    ++this.attempt;
                    allConsumersActive = this.consumerContainer.ensureConsumersAreActive();
                }
                if (allConsumersActive || !this.consumerContainer.isConnectionAvailable()) {
                    this.attempt = 0L;
                    this.noConnectionCondition.await();
                }
            }
            catch (InterruptedException e) {
                LOGGER.info("interrupted while waiting for notification");
                Thread.currentThread().interrupt();
                return;
            }
            finally {
                this.lock.unlock();
            }
            if (allConsumersActive || this.attempt <= 0L) continue;
            this.waitForRetry();
        }
    }

    public void stopThread() {
        this.threadStopper.stopThread(this);
    }

    private void waitForRetry() {
        LOGGER.warn("could not activate all consumer. Retry to activate failed consumers");
        try {
            Thread.sleep(this.retryTime);
        }
        catch (InterruptedException e) {
            LOGGER.info("interrupted while sleeping", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

