/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import net.reini.rabbitmq.cdi.ConnectionConfig;
import net.reini.rabbitmq.cdi.ConnectionRepository;
import net.reini.rabbitmq.cdi.ConsumerContainerWatcherThread;
import net.reini.rabbitmq.cdi.ConsumerHolder;
import net.reini.rabbitmq.cdi.ConsumerHolderFactory;
import net.reini.rabbitmq.cdi.ContainerConnectionListener;
import net.reini.rabbitmq.cdi.Declaration;
import net.reini.rabbitmq.cdi.DeclarerRepository;
import net.reini.rabbitmq.cdi.EventConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConsumerContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerContainer.class);
    private final ConnectionConfig config;
    private final ConnectionRepository connectionRepository;
    private final List<ConsumerHolder> consumerHolders;
    private final Condition noConnectionCondition;
    private DeclarerRepository declarerRepository;
    private final ReentrantLock lock;
    private ConsumerContainerWatcherThread consumerWatcherThread;
    private ConsumerHolderFactory consumerHolderFactory;
    private volatile boolean connectionAvailable = false;

    ConsumerContainer(ConnectionConfig config, ConnectionRepository connectionRepository, DeclarerRepository declarerRepository) {
        this(config, connectionRepository, declarerRepository, new CopyOnWriteArrayList<ConsumerHolder>(), new ConsumerHolderFactory(), new ReentrantLock());
    }

    ConsumerContainer(ConnectionConfig config, ConnectionRepository connectionRepository, DeclarerRepository declarerRepository, List<ConsumerHolder> consumerHolders, ConsumerHolderFactory consumerHolderFactory, ReentrantLock lock) {
        this.config = config;
        this.connectionRepository = connectionRepository;
        this.consumerHolders = consumerHolders;
        this.consumerHolderFactory = consumerHolderFactory;
        this.lock = lock;
        this.noConnectionCondition = lock.newCondition();
        this.declarerRepository = declarerRepository;
    }

    public void addConsumer(EventConsumer consumer, String queue, boolean autoAck, int prefetchCount, List<Declaration> declarations) {
        ConsumerHolder consumerHolder = this.consumerHolderFactory.createConsumerHolder(consumer, queue, autoAck, prefetchCount, this.connectionRepository, this.config, declarations, this.declarerRepository);
        this.consumerHolders.add(consumerHolder);
    }

    public void start() {
        this.connectionRepository.registerConnectionListener(this.config, new ContainerConnectionListener(this, this.lock, this.noConnectionCondition));
        this.connectionRepository.connect(this.config);
        this.consumerWatcherThread = new ConsumerContainerWatcherThread(this, this.config.getFailedConsumerActivationRetryTime(), this.lock, this.noConnectionCondition);
        this.consumerWatcherThread.start();
    }

    public void stop() {
        this.consumerWatcherThread.stopThread();
    }

    public void setConnectionAvailable(boolean connectionAvailable) {
        this.connectionAvailable = connectionAvailable;
    }

    boolean ensureConsumersAreActive() {
        boolean allConsumersActive = true;
        for (ConsumerHolder consumerHolder : this.consumerHolders) {
            try {
                consumerHolder.activate();
            }
            catch (Exception e) {
                allConsumersActive = false;
                LOGGER.warn("failed to activate consumer", (Throwable)e);
            }
        }
        return allConsumersActive;
    }

    boolean isConnectionAvailable() {
        return this.connectionAvailable;
    }

    void deactivateAllConsumer() {
        this.consumerHolders.forEach(consumer -> consumer.deactivate());
    }
}

