/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import net.reini.rabbitmq.cdi.ConnectionConfig;
import net.reini.rabbitmq.cdi.ConnectionRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConsumerChannelFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerChannelFactory.class);
    private final ConnectionRepository connectionRepository;
    private final ConnectionConfig config;

    ConsumerChannelFactory(ConnectionRepository connectionRepository, ConnectionConfig config) {
        this.connectionRepository = connectionRepository;
        this.config = config;
    }

    protected Channel createChannel() throws IOException {
        LOGGER.debug("Creating channel");
        Connection connection = this.connectionRepository.getConnection(this.config);
        Channel channel = connection.createChannel();
        LOGGER.debug("Created channel");
        return channel;
    }
}

