/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.util.concurrent.locks.ReentrantLock;
import net.reini.rabbitmq.cdi.ConnectionManager;
import net.reini.rabbitmq.cdi.ConnectionState;
import net.reini.rabbitmq.cdi.UnrecoverableErrorDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConnectionShutdownListener
implements ShutdownListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionManager.class);
    private final ReentrantLock connectionManagerLock;
    private UnrecoverableErrorDetector unrecoverableErrorDetector;
    private ConnectionManager connectionManager;

    public ConnectionShutdownListener(ConnectionManager connectionManager, ReentrantLock connectionManagerLock) {
        this.connectionManager = connectionManager;
        this.connectionManagerLock = connectionManagerLock;
        this.unrecoverableErrorDetector = new UnrecoverableErrorDetector();
    }

    public void shutdownCompleted(ShutdownSignalException cause) {
        LOGGER.debug("connection shutdown detected", (Throwable)cause);
        if (this.unrecoverableErrorDetector.isUnrecoverableError(cause)) {
            try {
                this.connectionManagerLock.lock();
                if (this.connectionManager.getState() == ConnectionState.CLOSED || this.connectionManager.getState() == ConnectionState.CONNECTING) {
                    return;
                }
                this.connectionManager.changeState(ConnectionState.CONNECTING);
                LOGGER.error("Connection lost by unrecoverable error reconnecting");
            }
            finally {
                this.connectionManagerLock.unlock();
            }
        }
    }
}

