/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import net.reini.rabbitmq.cdi.ConnectionConfig;
import net.reini.rabbitmq.cdi.ConnectionListener;
import net.reini.rabbitmq.cdi.ConnectionManager;

@ApplicationScoped
public class ConnectionRepository {
    private final Map<ConnectionConfig, ConnectionManager> connectionManagers = new ConcurrentHashMap<ConnectionConfig, ConnectionManager>();
    private Function<ConnectionConfig, ConnectionManager> connectionManagerFactoryFunction;

    public ConnectionRepository() {
        this(ConnectionManager::new);
    }

    ConnectionRepository(Function<ConnectionConfig, ConnectionManager> connectionManagerFactoryFunction) {
        this.connectionManagerFactoryFunction = connectionManagerFactoryFunction;
    }

    public Connection getConnection(ConnectionConfig config) throws IOException {
        return this.connectionManagers.computeIfAbsent(config, this.connectionManagerFactoryFunction).getConnection();
    }

    public void connect(ConnectionConfig config) {
        this.connectionManagers.computeIfAbsent(config, this.connectionManagerFactoryFunction).connect();
    }

    @PreDestroy
    public void close() {
        this.connectionManagers.values().forEach(ConnectionManager::close);
    }

    public void registerConnectionListener(ConnectionConfig config, ConnectionListener listener) {
        this.connectionManagers.computeIfAbsent(config, this.connectionManagerFactoryFunction).addListener(listener);
    }

    public void removeConnectionListener(ConnectionConfig config, ConnectionListener listener) {
        this.connectionManagers.computeIfAbsent(config, this.connectionManagerFactoryFunction).removeListener(listener);
    }
}

