/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import net.reini.rabbitmq.cdi.ConnectionManager;
import net.reini.rabbitmq.cdi.ConnectionState;
import net.reini.rabbitmq.cdi.StoppableThread;
import net.reini.rabbitmq.cdi.ThreadStopper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConnectionManagerWatcherThread
extends StoppableThread {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionManager.class);
    private final ReentrantLock connectionManagerLock;
    private final Condition noConnectionCondition;
    private final ThreadStopper threadStopper = new ThreadStopper();
    private long connectRetryWaitTime;
    private ConnectionManager connectionManager;

    ConnectionManagerWatcherThread(ReentrantLock connectionManagerLock, Condition noConnectionCondition, ConnectionManager connectionManager, long connectRetryWaitTime) {
        this.connectionManagerLock = connectionManagerLock;
        this.noConnectionCondition = noConnectionCondition;
        this.connectionManager = connectionManager;
        this.connectRetryWaitTime = connectRetryWaitTime;
        this.setDaemon(true);
        this.setName("rabbitmq-cdi connect thread");
    }

    @Override
    public void run() {
        this.ensureConnectionState();
    }

    void stopThread() {
        this.threadStopper.stopThread(this);
    }

    boolean isRunning() {
        return this.isAlive();
    }

    private void ensureConnectionState() {
        while (!Thread.currentThread().isInterrupted() && !this.stopped) {
            boolean connectionEstablished = false;
            try {
                this.connectionManagerLock.lock();
                if (this.reconnectNeeded() && (connectionEstablished = this.connectionManager.tryToEstablishConnection())) {
                    this.waitTillConnectionIsLost();
                }
            }
            catch (InterruptedException e) {
                LOGGER.debug("connect thread was interrupted while waiting", (Throwable)e);
                Thread.currentThread().interrupt();
                return;
            }
            finally {
                this.connectionManagerLock.unlock();
            }
            if (connectionEstablished || Thread.currentThread().isInterrupted() || this.stopped) continue;
            this.waitForRetry();
        }
    }

    private boolean reconnectNeeded() {
        return this.connectionManager.getState() == ConnectionState.NEVER_CONNECTED || this.connectionManager.getState() == ConnectionState.CONNECTING;
    }

    private void waitForRetry() {
        try {
            Thread.sleep(this.connectRetryWaitTime);
        }
        catch (InterruptedException e) {
            LOGGER.debug("connect thread was interrupted while sleeping", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private void waitTillConnectionIsLost() throws InterruptedException {
        this.noConnectionCondition.await();
    }
}

