/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ShutdownListener;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import net.reini.rabbitmq.cdi.ConnectionConfig;
import net.reini.rabbitmq.cdi.ConnectionListener;
import net.reini.rabbitmq.cdi.ConnectionManagerWatcherThread;
import net.reini.rabbitmq.cdi.ConnectionShutdownListener;
import net.reini.rabbitmq.cdi.ConnectionState;
import net.reini.rabbitmq.cdi.ResourceCloser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConnectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionManager.class);
    private final ConnectionConfig config;
    private final Set<ConnectionListener> listeners = ConcurrentHashMap.newKeySet();
    private final ReentrantLock connectionManagerLock;
    private final Condition noConnectionCondition;
    private final ConnectionManagerWatcherThread connectThread;
    private final ConnectionFactory connectionFactory;
    private ResourceCloser resourceCloser = new ResourceCloser();
    private ConnectionShutdownListener shutdownListener;
    private volatile Connection connection;
    private volatile ConnectionState state = ConnectionState.NEVER_CONNECTED;

    ConnectionManager(ConnectionConfig config) {
        this.config = config;
        this.connectionFactory = new ConnectionFactory();
        this.connectionManagerLock = new ReentrantLock();
        this.noConnectionCondition = this.connectionManagerLock.newCondition();
        this.shutdownListener = new ConnectionShutdownListener(this, this.connectionManagerLock);
        this.connectThread = new ConnectionManagerWatcherThread(this.connectionManagerLock, this.noConnectionCondition, this, config.getConnectRetryWaitTime());
    }

    ConnectionManager(ConnectionConfig config, ConnectionManagerWatcherThread connectThread, ConnectionShutdownListener shutdownListener, ConnectionFactory connectionFactory, ReentrantLock connectionManagerLock, Condition noConnectionCondition) {
        this.connectThread = connectThread;
        this.shutdownListener = shutdownListener;
        this.connectionFactory = connectionFactory;
        this.config = config;
        this.connectionManagerLock = connectionManagerLock;
        this.noConnectionCondition = noConnectionCondition;
    }

    void connect() {
        if (this.state == ConnectionState.CLOSED) {
            throw new IllegalStateException("Attempt to initiate a connect from a closed connection manager");
        }
        this.startConnectThread();
    }

    void addListener(ConnectionListener listener) {
        this.listeners.add(listener);
    }

    void removeListener(ConnectionListener listener) {
        this.listeners.remove(listener);
    }

    void changeState(ConnectionState newState) {
        this.state = newState;
        if (this.state == ConnectionState.CONNECTING) {
            try {
                this.connectionManagerLock.lock();
                this.noConnectionCondition.signalAll();
            }
            finally {
                this.connectionManagerLock.unlock();
            }
        }
        this.notifyListenersOnStateChange();
    }

    ConnectionState getState() {
        return this.state;
    }

    Connection getConnection() throws IOException {
        if (this.state == ConnectionState.CLOSED) {
            throw new IOException("Attempt to retrieve a connection from a closed connection factory");
        }
        if (this.state == ConnectionState.CONNECTED) {
            return this.connection;
        }
        LOGGER.error("Unable to retrieve connection");
        throw new IOException("Unable to retrieve connection");
    }

    boolean tryToEstablishConnection() {
        String connectWarning = "could not establish connection to host " + this.connectionFactory.getHost() + " on port " + this.connectionFactory.getPort() + ", retry to establish connection...";
        if (this.state == ConnectionState.CONNECTED || this.state == ConnectionState.CLOSED) {
            throw new IllegalStateException("connection manager illegal state to establish a connection: " + (Object)((Object)this.state));
        }
        try {
            this.connectionManagerLock.lock();
            this.connection = this.createNewConnection();
            boolean bl = true;
            return bl;
        }
        catch (IOException | TimeoutException e) {
            LOGGER.warn(connectWarning);
            LOGGER.debug("could not establish connection", (Throwable)e);
        }
        finally {
            this.connectionManagerLock.unlock();
        }
        return false;
    }

    void close() {
        try {
            this.connectionManagerLock.lock();
            if (this.state == ConnectionState.CLOSED) {
                LOGGER.warn("Attempt to close connection factory which is already closed");
                return;
            }
            LOGGER.info("Closing connection factory");
            this.stopConnectThread();
            if (this.connection != null) {
                this.connection.removeShutdownListener((ShutdownListener)this.shutdownListener);
                this.resourceCloser.closeResource((AutoCloseable)this.connection, "Unable to close current connection");
                this.connection = null;
            }
            this.changeState(ConnectionState.CLOSED);
            LOGGER.info("Closed connection factory");
        }
        finally {
            this.connectionManagerLock.unlock();
        }
    }

    private Connection createNewConnection() throws IOException, TimeoutException {
        LOGGER.debug("Trying to establish connection using {}", (Object)this.config);
        this.connection = this.config.createConnection(this.connectionFactory);
        this.connection.addShutdownListener((ShutdownListener)this.shutdownListener);
        LOGGER.debug("Established connection successfully");
        this.changeState(ConnectionState.CONNECTED);
        return this.connection;
    }

    private void notifyListenersOnStateChange() {
        LOGGER.debug("Notifying connection listeners about state change to {}", (Object)this.state);
        for (ConnectionListener listener : this.listeners) {
            try {
                switch (this.state) {
                    case CONNECTED: {
                        listener.onConnectionEstablished(this.connection);
                        break;
                    }
                    case CONNECTING: {
                        listener.onConnectionLost(this.connection);
                        break;
                    }
                    case CLOSED: {
                        listener.onConnectionClosed(this.connection);
                        break;
                    }
                }
            }
            catch (RuntimeException e) {
                LOGGER.warn("connection listener throw an exception while informing about state change", (Throwable)e);
            }
        }
    }

    private synchronized void startConnectThread() {
        this.connectThread.start();
    }

    private synchronized void stopConnectThread() {
        if (this.connectThread.isRunning()) {
            this.connectThread.stopThread();
        }
    }
}

