/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import net.reini.rabbitmq.cdi.ConnectionConfig;
import net.reini.rabbitmq.cdi.ConnectionConfigHolder;
import net.reini.rabbitmq.cdi.SSLContextFactory;

final class ConnectionConfiguration
implements ConnectionConfig,
ConnectionConfigHolder {
    private static final int DEFAULT_CONNECTION_HEARTBEAT_TIMEOUT_IN_SEC = 3;
    private static final int DEFAULT_CONNECT_TIMEOUT_IN_MS = 10000;
    private static final int DEFAULT_WAIT_TIME_RETRY_CONNECT_IN_MS = 10000;
    private static final long DEFAULT_WAIT_TIME_RETRY_ACTIVATE_CONSUMER_IN_MS = 10000L;
    private final List<Address> brokerHosts;
    private int requestedConnectionHeartbeatTimeout;
    private int connectTimeout;
    private long connectRetryWaitTime;
    private long failedConsumerActivationRetryTime;
    private boolean secure;
    private String username;
    private String password;
    private String virtualHost;
    private SSLContextFactory sslContextFactory;

    ConnectionConfiguration(SSLContextFactory sslContextFactory) {
        this.sslContextFactory = sslContextFactory;
        this.brokerHosts = new ArrayList<Address>();
        this.username = "guest";
        this.password = "guest";
        this.connectTimeout = 10000;
        this.requestedConnectionHeartbeatTimeout = 3;
        this.connectRetryWaitTime = 10000L;
        this.failedConsumerActivationRetryTime = 10000L;
    }

    ConnectionConfiguration() {
        this(SSLContext::getDefault);
    }

    @Override
    public void setUsername(String username) {
        this.username = username == null ? "guest" : username;
    }

    @Override
    public void setPassword(String password) {
        this.password = password == null ? "guest" : password;
    }

    @Override
    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    @Override
    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @Override
    public void addHost(Address hostAddress) {
        this.brokerHosts.add(hostAddress);
    }

    @Override
    public void setHosts(Set<Address> hosts) {
        this.brokerHosts.clear();
        this.brokerHosts.addAll(hosts);
    }

    @Override
    public void setRequestedConnectionHeartbeatTimeout(int requestedHeartbeat) {
        this.requestedConnectionHeartbeatTimeout = requestedHeartbeat;
    }

    @Override
    public void setConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
    }

    @Override
    public void setConnectRetryWaitTime(long waitTime) {
        this.connectRetryWaitTime = waitTime;
    }

    @Override
    public Connection createConnection(ConnectionFactory connectionFactory) throws IOException, TimeoutException {
        connectionFactory.setUsername(this.username);
        connectionFactory.setPassword(this.password);
        connectionFactory.setRequestedHeartbeat(this.requestedConnectionHeartbeatTimeout);
        connectionFactory.setConnectionTimeout(this.connectTimeout);
        if (this.secure) {
            SSLContext sslContext;
            try {
                sslContext = this.sslContextFactory.createSSLContext();
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("error during connect, fatal system configuration", e);
            }
            connectionFactory.setSslContextFactory(name -> sslContext);
        }
        if (this.virtualHost != null) {
            connectionFactory.setVirtualHost(this.virtualHost);
        }
        if (this.brokerHosts.isEmpty()) {
            throw new IllegalArgumentException("No broker host defined");
        }
        return connectionFactory.newConnection(new ArrayList<Address>(this.brokerHosts));
    }

    @Override
    public void setFailedConsumerActivationRetryTime(long failedConsumerActivationRetryTime) {
        this.failedConsumerActivationRetryTime = failedConsumerActivationRetryTime;
    }

    public String toString() {
        return String.format("broker hosts: %s, connect user: %s", this.brokerHosts, this.username);
    }

    public int hashCode() {
        return this.brokerHosts.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConnectionConfiguration)) {
            return false;
        }
        ConnectionConfiguration other = (ConnectionConfiguration)obj;
        return this.secure == other.secure && this.brokerHosts.equals(other.brokerHosts) && this.username.equals(other.username) && this.password.equals(other.password) && Objects.equals(this.virtualHost, other.virtualHost);
    }

    @Override
    public long getConnectRetryWaitTime() {
        return this.connectRetryWaitTime;
    }

    @Override
    public long getFailedConsumerActivationRetryTime() {
        return this.failedConsumerActivationRetryTime;
    }
}

