/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.Map;
import net.reini.rabbitmq.cdi.BindingDeclaration;
import net.reini.rabbitmq.cdi.Declarer;
import net.reini.rabbitmq.cdi.ExchangeDeclaration;
import net.reini.rabbitmq.cdi.QueueDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindingDeclarer
implements Declarer<BindingDeclaration> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BindingDeclaration.class);

    @Override
    public void declare(Channel channel, BindingDeclaration declaration) throws IOException {
        ExchangeDeclaration exchangeDeclaration = declaration.getExchangeDeclaration();
        QueueDeclaration queueDeclaration = declaration.getQueueDeclaration();
        String queueName = queueDeclaration.getQueueName();
        String exchangeName = exchangeDeclaration.getExchangeName();
        String routingKey = declaration.getRoutingKey();
        Map<String, Object> arguments = declaration.getArguments();
        LOGGER.info("binding queue {} to exchange {} with routingkey {}", new Object[]{queueName, exchangeName, routingKey});
        channel.queueBind(queueName, exchangeName, routingKey, arguments);
    }
}

