/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import java.util.HashMap;
import java.util.Map;
import net.reini.rabbitmq.cdi.Declaration;
import net.reini.rabbitmq.cdi.ExchangeDeclaration;
import net.reini.rabbitmq.cdi.QueueDeclaration;

public final class BindingDeclaration
implements Declaration {
    private final QueueDeclaration queueDeclaration;
    private final ExchangeDeclaration exchangeDeclaration;
    private String routingKey;
    private Map<String, Object> arguments;

    public BindingDeclaration(QueueDeclaration queueDeclaration, ExchangeDeclaration exchangeDeclaration) {
        this.queueDeclaration = queueDeclaration;
        this.exchangeDeclaration = exchangeDeclaration;
        this.routingKey = "";
        this.arguments = new HashMap<String, Object>();
    }

    public BindingDeclaration withArgument(String key, Object argument) {
        this.arguments.put(key, argument);
        return this;
    }

    public BindingDeclaration withRoutingKey(String routingKey) {
        this.routingKey = routingKey;
        return this;
    }

    ExchangeDeclaration getExchangeDeclaration() {
        return this.exchangeDeclaration;
    }

    QueueDeclaration getQueueDeclaration() {
        return this.queueDeclaration;
    }

    String getRoutingKey() {
        return this.routingKey;
    }

    Map<String, Object> getArguments() {
        return this.arguments;
    }

    public String toString() {
        return "queue to exchange binding for queue " + this.queueDeclaration.getQueueName() + " to exchange " + this.exchangeDeclaration.getExchangeName() + ", routingKey='" + this.routingKey + '\'' + ", arguments=" + this.arguments;
    }
}

