/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import net.reini.rabbitmq.cdi.EncodeException;
import net.reini.rabbitmq.cdi.Encoder;

final class PublisherConfiguration {
    private final AMQP.BasicProperties basicProperties;
    private final Encoder<?> messageEncoder;
    private final String exchange;
    private final String routingKey;

    PublisherConfiguration(String exchange, String routingKey, AMQP.BasicProperties.Builder basicPropertiesBuilder, Encoder<?> encoder) {
        this.exchange = exchange;
        this.routingKey = routingKey;
        this.messageEncoder = encoder;
        String contentType = this.messageEncoder.contentType();
        if (contentType != null) {
            basicPropertiesBuilder.contentType(contentType);
        }
        this.basicProperties = basicPropertiesBuilder.build();
    }

    void publish(Channel channel, Object event) throws EncodeException, IOException {
        byte[] data = this.messageEncoder.encode(event);
        channel.basicPublish(this.exchange, this.routingKey, this.basicProperties, data);
    }
}

