/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import net.reini.rabbitmq.cdi.ConnectionProducer;
import net.reini.rabbitmq.cdi.EncodeException;
import net.reini.rabbitmq.cdi.MessagePublisher;
import net.reini.rabbitmq.cdi.PublisherConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericPublisher
implements MessagePublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericPublisher.class);
    public static final int DEFAULT_RETRY_ATTEMPTS = 3;
    public static final int DEFAULT_RETRY_INTERVAL = 1000;
    private final ConnectionProducer connectionProducer;
    private Channel channel;

    public GenericPublisher(ConnectionProducer connectionProducer) {
        this.connectionProducer = connectionProducer;
    }

    protected Channel provideChannel() throws IOException, TimeoutException {
        if (this.channel == null || !this.channel.isOpen()) {
            Connection connection = this.connectionProducer.newConnection();
            this.channel = connection.createChannel();
        }
        return this.channel;
    }

    protected <T extends Exception> void handleIoException(int attempt, T exception) throws T {
        if (this.channel != null && this.channel.isOpen()) {
            try {
                this.channel.close();
            }
            catch (IOException | TimeoutException e) {
                LOGGER.warn("Failed to close channel after failed publish", (Throwable)e);
            }
        }
        this.channel = null;
        if (attempt == 3) {
            throw exception;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Sending message interrupted while waiting for retry attempt", (Throwable)e);
        }
    }

    @Override
    public void publish(Object event, PublisherConfiguration publisherConfiguration) throws IOException, TimeoutException {
        for (int attempt = 1; attempt <= 3; ++attempt) {
            if (attempt > 1) {
                LOGGER.debug("Attempt {} to send message", (Object)attempt);
            }
            try {
                publisherConfiguration.publish(this.provideChannel(), event);
                return;
            }
            catch (EncodeException e) {
                LOGGER.error("Unable to serialize {} due to: {}", event, (Object)e.getMessage());
                continue;
            }
            catch (IOException e) {
                this.handleIoException(attempt, e);
                continue;
            }
            catch (TimeoutException e) {
                this.handleIoException(attempt, e);
            }
        }
    }

    @Override
    public void close() throws IOException, TimeoutException {
        if (this.channel == null) {
            LOGGER.warn("Attempt to close a publisher channel that has not been initialized");
            return;
        }
        if (!this.channel.isOpen()) {
            LOGGER.warn("Attempt to close a publisher channel that has already been closed or is already closing");
            return;
        }
        LOGGER.debug("Closing publisher channel");
        this.channel.close();
        this.channel = null;
        LOGGER.debug("Successfully closed publisher channel");
    }
}

