/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.reini.rabbitmq.cdi.ConnectionProducer;
import net.reini.rabbitmq.cdi.GenericPublisher;
import net.reini.rabbitmq.cdi.MessagePublisher;
import net.reini.rabbitmq.cdi.PublisherConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EventPublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventPublisher.class);
    private final ConnectionProducer connectionProducer;
    private final Map<Class<?>, PublisherConfiguration> publisherConfigurations;
    private final ThreadLocal<Map<Class<?>, MessagePublisher>> publishers;

    @Inject
    public EventPublisher(ConnectionProducer connectionProducer) {
        this.connectionProducer = connectionProducer;
        this.publisherConfigurations = new HashMap();
        this.publishers = new ThreadLocal();
    }

    public void addEvent(Class<?> eventType, PublisherConfiguration configuration) {
        this.publisherConfigurations.put(eventType, configuration);
    }

    public void publishEvent(@Observes Object event) {
        Class<?> eventType = event.getClass();
        PublisherConfiguration publisherConfiguration = this.publisherConfigurations.get(eventType);
        if (publisherConfiguration == null) {
            LOGGER.trace("No publisher configured for event {}", event);
        } else {
            try (MessagePublisher publisher = this.providePublisher(eventType);){
                LOGGER.debug("Start publishing event {}...", event);
                publisher.publish(event, publisherConfiguration);
                LOGGER.debug("Published event successfully");
            }
            catch (IOException | TimeoutException e) {
                throw new RuntimeException("Failed to publish event to RabbitMQ", e);
            }
        }
    }

    MessagePublisher providePublisher(Class<?> eventType) {
        MessagePublisher publisher;
        Map<Class<?>, MessagePublisher> localPublishers = this.publishers.get();
        if (localPublishers == null) {
            localPublishers = new HashMap();
            this.publishers.set(localPublishers);
        }
        if ((publisher = localPublishers.get(eventType)) == null) {
            publisher = new GenericPublisher(this.connectionProducer);
            localPublishers.put(eventType, publisher);
        }
        return publisher;
    }
}

