/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import net.reini.rabbitmq.cdi.DecodeException;
import net.reini.rabbitmq.cdi.Decoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventConsumer
implements Consumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventConsumer.class);
    private final boolean autoAck;
    private final Decoder<?> decoder;
    private final Event<Object> eventControl;
    private final Instance<Object> eventPool;
    private Channel channel;

    EventConsumer(Decoder<?> decoder, boolean autoAck, Event<Object> eventControl, Instance<Object> eventPool) {
        this.decoder = decoder;
        this.autoAck = autoAck;
        this.eventControl = eventControl;
        this.eventPool = eventPool;
    }

    Channel getChannel() {
        return this.channel;
    }

    void setChannel(Channel channel) {
        this.channel = channel;
    }

    Object buildEvent(byte[] messageBody) {
        Object event;
        try {
            event = this.decoder.decode(messageBody);
        }
        catch (DecodeException e) {
            LOGGER.error("Unable to read decode event from message: ".concat(new String(messageBody)), (Throwable)e);
            event = this.eventPool.get();
        }
        return event;
    }

    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        long deliveryTag = envelope.getDeliveryTag();
        LOGGER.debug("Handle delivery: consumerTag: {}, deliveryTag: {}", (Object)consumerTag, (Object)deliveryTag);
        try {
            String contentType = properties.getContentType();
            if (this.decoder.willDecode(contentType)) {
                Object event = this.buildEvent(body);
                this.eventControl.fire(event);
            } else {
                LOGGER.error("Unable to process unknown message content type: {}", (Object)contentType);
            }
        }
        catch (Throwable t) {
            if (!this.autoAck) {
                LOGGER.error("Consumer {}: Message {} could not be handled due to an exception during message processing", new Object[]{consumerTag, deliveryTag, t});
                this.channel.basicNack(deliveryTag, false, false);
                LOGGER.warn("Nacked message: consumerTag: {}, deliveryTag: {}", new Object[]{consumerTag, deliveryTag, t});
            }
            return;
        }
        if (!this.autoAck) {
            try {
                this.channel.basicAck(deliveryTag, false);
                LOGGER.debug("Acked message: consumerTag: {}, deliveryTag: {}", (Object)consumerTag, (Object)deliveryTag);
            }
            catch (IOException e) {
                LOGGER.error("Consumer {}: Message {} was processed but could not be acknowledged due to an exception when sending the acknowledgement", new Object[]{consumerTag, deliveryTag, e});
                throw e;
            }
        }
    }

    public void handleConsumeOk(String consumerTag) {
        LOGGER.debug("Consumer {}: Received consume OK", (Object)consumerTag);
    }

    public void handleCancelOk(String consumerTag) {
        LOGGER.debug("Consumer {}: Received cancel OK", (Object)consumerTag);
    }

    public void handleCancel(String consumerTag) throws IOException {
        LOGGER.debug("Consumer {}: Received cancel", (Object)consumerTag);
    }

    public void handleShutdownSignal(String consumerTag, ShutdownSignalException sig) {
        LOGGER.debug("Consumer {}: Received shutdown signal: {}", (Object)consumerTag, (Object)sig.getMessage());
    }

    public void handleRecoverOk(String consumerTag) {
        LOGGER.debug("Consumer {}: Received recover OK", (Object)consumerTag);
    }
}

