/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.MessageProperties;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import net.reini.rabbitmq.cdi.ConnectionProducer;
import net.reini.rabbitmq.cdi.ConsumerContainer;
import net.reini.rabbitmq.cdi.Decoder;
import net.reini.rabbitmq.cdi.Encoder;
import net.reini.rabbitmq.cdi.EventConsumer;
import net.reini.rabbitmq.cdi.EventPublisher;
import net.reini.rabbitmq.cdi.JsonDecoder;
import net.reini.rabbitmq.cdi.JsonEncoder;
import net.reini.rabbitmq.cdi.PublisherConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public abstract class EventBinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventBinder.class);
    private final Set<QueueBinding<?>> queueBindings;
    private final Set<ExchangeBinding<?>> exchangeBindings = new HashSet();
    @Inject
    private Event<Object> remoteEventControl;
    @Inject
    private Instance<Object> remoteEventPool;
    @Inject
    private EventPublisher eventPublisher;
    @Inject
    private ConnectionProducer connectionProducer;
    private ConsumerContainer consumerContainer;
    private BinderConfiguration configuration;

    public EventBinder() {
        this.queueBindings = new HashSet();
    }

    protected abstract void bindEvents();

    public BinderConfiguration configuration() {
        return this.configuration;
    }

    public void initialize() throws IOException {
        this.bindEvents();
        this.processQueueBindings();
        this.consumerContainer.startAllConsumers();
        this.processExchangeBindings();
    }

    @PostConstruct
    void initializeConsumerContainer() {
        this.consumerContainer = new ConsumerContainer(this.connectionProducer);
        this.configuration = new BinderConfiguration();
    }

    void processExchangeBindings() {
        for (ExchangeBinding<?> exchangeBinding : this.exchangeBindings) {
            this.bindExchange(exchangeBinding);
        }
        this.exchangeBindings.clear();
    }

    void processQueueBindings() {
        for (QueueBinding<?> queueBinding : this.queueBindings) {
            this.bindQueue(queueBinding);
        }
        this.queueBindings.clear();
    }

    void bindQueue(QueueBinding<?> queueBinding) {
        Event eventControl = this.remoteEventControl.select(((QueueBinding)queueBinding).eventType, new Annotation[0]);
        Instance eventPool = this.remoteEventPool.select(((QueueBinding)queueBinding).eventType, new Annotation[0]);
        EventConsumer consumer = new EventConsumer(((QueueBinding)queueBinding).decoder, ((QueueBinding)queueBinding).autoAck, (Event<Object>)eventControl, (Instance<Object>)eventPool);
        this.consumerContainer.addConsumer(consumer, ((QueueBinding)queueBinding).queue, ((QueueBinding)queueBinding).autoAck);
        LOGGER.info("Binding between queue {} and event type {} activated", (Object)((QueueBinding)queueBinding).queue, (Object)((QueueBinding)queueBinding).eventType.getSimpleName());
    }

    void bindExchange(ExchangeBinding<?> exchangeBinding) {
        PublisherConfiguration cfg = new PublisherConfiguration(((ExchangeBinding)exchangeBinding).exchange, ((ExchangeBinding)exchangeBinding).routingKey, ((ExchangeBinding)exchangeBinding).basicPropertiesBuilder, ((ExchangeBinding)exchangeBinding).encoder);
        this.eventPublisher.addEvent(((ExchangeBinding)exchangeBinding).eventType, cfg);
        LOGGER.info("Binding between exchange {} and event type {} activated", (Object)((ExchangeBinding)exchangeBinding).exchange, (Object)((ExchangeBinding)exchangeBinding).eventType.getSimpleName());
    }

    public <M> EventBindingBuilder<M> bind(Class<M> event) {
        return new EventBindingBuilder<M>(event);
    }

    public final class BinderConfiguration {
        @Deprecated
        public BinderConfiguration setHost(String hostName) {
            return this.addHost(Address.parseAddress((String)hostName));
        }

        public BinderConfiguration addHost(String hostName) {
            return this.addHost(Address.parseAddress((String)hostName));
        }

        public BinderConfiguration addHost(Address hostAddress) {
            EventBinder.this.connectionProducer.getBrokerHosts().add(hostAddress);
            return this;
        }

        public BinderConfiguration setUsername(String username) {
            EventBinder.this.connectionProducer.getConnectionFactory().setUsername(username);
            return this;
        }

        public BinderConfiguration setPassword(String password) {
            EventBinder.this.connectionProducer.getConnectionFactory().setPassword(password);
            return this;
        }

        public BinderConfiguration setVirtualHost(String virtualHost) {
            EventBinder.this.connectionProducer.getConnectionFactory().setVirtualHost(virtualHost);
            return this;
        }
    }

    public final class ExchangeBinding<T> {
        private final Class<T> eventType;
        private final String exchange;
        private String routingKey;
        private Encoder<T> encoder;
        private AMQP.BasicProperties.Builder basicPropertiesBuilder;

        ExchangeBinding(Class<T> eventType, String exchange) {
            this.eventType = eventType;
            this.exchange = exchange;
            this.encoder = new JsonEncoder();
            this.basicPropertiesBuilder = MessageProperties.BASIC.builder();
            EventBinder.this.exchangeBindings.add(this);
            LOGGER.info("Binding created between exchange {} and event type {}", (Object)exchange, (Object)eventType.getSimpleName());
        }

        public ExchangeBinding<T> withRoutingKey(String key) {
            this.routingKey = Objects.requireNonNull(key, "key must not be null");
            LOGGER.info("Routing key for event type {} set to {}", (Object)this.eventType.getSimpleName(), (Object)key);
            return this;
        }

        public ExchangeBinding<T> withEncoder(Encoder<T> messageEncoder) {
            this.encoder = Objects.requireNonNull(messageEncoder, "encoder must not be null");
            LOGGER.info("Encoder for event type {} set to {}", (Object)this.eventType.getSimpleName(), (Object)this.encoder.getClass().getName());
            return this;
        }

        public ExchangeBinding<T> withProperties(AMQP.BasicProperties properties) {
            this.basicPropertiesBuilder = Objects.requireNonNull(properties, "propeties must not be null").builder();
            LOGGER.info("Publisher properties for event type {} set to {}", (Object)this.eventType.getSimpleName(), (Object)properties.toString());
            return this;
        }
    }

    public final class QueueBinding<T> {
        private final Class<T> eventType;
        private final String queue;
        private boolean autoAck;
        private Decoder<T> decoder;

        QueueBinding(Class<T> eventType, String queue) {
            this.eventType = eventType;
            this.queue = queue;
            this.decoder = new JsonDecoder<T>(eventType);
            EventBinder.this.queueBindings.add(this);
            LOGGER.info("Binding created between queue {} and event type {}", (Object)queue, (Object)eventType.getSimpleName());
        }

        public QueueBinding<T> autoAck() {
            this.autoAck = true;
            LOGGER.info("Auto acknowledges enabled for event type {}", (Object)this.eventType.getSimpleName());
            return this;
        }

        public QueueBinding<T> withDecoder(Decoder<T> messageDecoder) {
            this.decoder = Objects.requireNonNull(messageDecoder, "decoder must not be null");
            LOGGER.info("Decoder set to {} for event type {}", messageDecoder, (Object)this.eventType.getSimpleName());
            return this;
        }
    }

    public final class EventBindingBuilder<T> {
        private final Class<T> eventType;

        EventBindingBuilder(Class<T> eventType) {
            this.eventType = eventType;
        }

        public QueueBinding<T> toQueue(String queue) {
            return new QueueBinding<T>(this.eventType, queue);
        }

        public ExchangeBinding<T> toExchange(String exchange) {
            return new ExchangeBinding<T>(this.eventType, exchange);
        }
    }
}

