/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import net.reini.rabbitmq.cdi.ConnectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class ConnectionProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionProducer.class);
    public static final int CONNECTION_HEARTBEAT_IN_SEC = 3;
    public static final int CONNECTION_TIMEOUT_IN_MS = 1000;
    public static final int CONNECTION_ESTABLISH_INTERVAL_IN_MS = 500;
    private final Object operationOnConnectionMonitor;
    private final ConnectionFactory connectionFactory = new ConnectionFactory();
    private final Set<Address> brokerHosts;
    private final Set<ConnectionListener> connectionListeners;
    private volatile Connection connection;
    private volatile State state;

    public ConnectionProducer() {
        this.operationOnConnectionMonitor = new Object();
        this.brokerHosts = ConcurrentHashMap.newKeySet();
        this.connectionListeners = ConcurrentHashMap.newKeySet();
        this.state = State.NEVER_CONNECTED;
        this.connectionFactory.setRequestedHeartbeat(3);
        this.connectionFactory.setConnectionTimeout(1000);
    }

    public Connection newConnection() throws IOException, TimeoutException {
        if (this.state == State.CLOSED) {
            throw new IOException("Attempt to retrieve a connection from a closed connection factory");
        }
        if (this.state == State.NEVER_CONNECTED) {
            this.establishConnection();
        }
        if (this.connection != null && this.connection.isOpen()) {
            return this.connection;
        }
        LOGGER.error("Unable to retrieve connection");
        throw new IOException("Unable to retrieve connection");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void close() {
        Object object = this.operationOnConnectionMonitor;
        synchronized (object) {
            if (this.state == State.CLOSED) {
                LOGGER.warn("Attempt to close connection factory which is already closed");
                return;
            }
            LOGGER.info("Closing connection factory");
            if (this.connection != null) {
                try {
                    this.connection.close();
                    this.connection = null;
                }
                catch (IOException e) {
                    if (!this.connection.isOpen()) {
                        LOGGER.warn("Attempt to close an already closed connection");
                    }
                    LOGGER.error("Unable to close current connection", (Throwable)e);
                }
            }
            this.changeState(State.CLOSED);
            LOGGER.info("Closed connection factory");
        }
    }

    public void registerListener(ConnectionListener connectionListener) {
        this.connectionListeners.add(connectionListener);
    }

    public void removeConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.remove(connectionListener);
    }

    Set<Address> getBrokerHosts() {
        return this.brokerHosts;
    }

    ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    void changeState(State newState) {
        this.state = newState;
        this.notifyListenersOnStateChange();
    }

    void notifyListenersOnStateChange() {
        LOGGER.debug("Notifying connection listeners about state change to {}", (Object)this.state);
        for (ConnectionListener listener : this.connectionListeners) {
            switch (this.state) {
                case CONNECTED: {
                    listener.onConnectionEstablished(this.connection);
                    break;
                }
                case CONNECTING: {
                    listener.onConnectionLost(this.connection);
                    break;
                }
                case CLOSED: {
                    listener.onConnectionClosed(this.connection);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void establishConnection() throws IOException, TimeoutException {
        Object object = this.operationOnConnectionMonitor;
        synchronized (object) {
            Set<Address> addrs;
            if (this.state == State.CLOSED) {
                throw new IOException("Attempt to establish a connection with a closed connection factory");
            }
            if (this.state == State.CONNECTED) {
                LOGGER.warn("Establishing new connection although a connection is already established");
            }
            if ((addrs = this.getBrokerHosts()).isEmpty()) {
                addrs.add(new Address(this.connectionFactory.getHost(), this.connectionFactory.getPort()));
            }
            LOGGER.debug("Trying to establish connection to on of: {}", addrs);
            this.connection = this.connectionFactory.newConnection(this.brokerHosts.toArray(new Address[0]));
            this.connection.addShutdownListener(cause -> this.shutdownCompleted(cause));
            LOGGER.debug("Established connection successfully");
            this.changeState(State.CONNECTED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdownCompleted(ShutdownSignalException cause) {
        if (!cause.isHardError()) {
            return;
        }
        Object object = this.operationOnConnectionMonitor;
        synchronized (object) {
            if (this.state == State.CLOSED || this.state == State.CONNECTING) {
                return;
            }
            this.changeState(State.CONNECTING);
        }
        LOGGER.error("Connection lost");
        while (this.state == State.CONNECTING) {
            try {
                this.establishConnection();
                return;
            }
            catch (IOException | TimeoutException e) {
                LOGGER.debug("Next reconnect attempt in {} ms", (Object)500);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    return;
                }
            }
        }
    }

    private static enum State {
        NEVER_CONNECTED,
        CONNECTING,
        CONNECTED,
        CLOSED;

    }
}

